/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalDeviceMetricsTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.MaximumProfileTable;
import com.google.typography.font.tools.conversion.eot.MagnitudeDependentWriter;

public class HdmxEncoder {
    private static int HEADER_SIZE = 8;
    private static int RECORD_SIZE = 2;

    public WritableFontData encode(Font font) {
        int n;
        int n2;
        HorizontalDeviceMetricsTable horizontalDeviceMetricsTable = (HorizontalDeviceMetricsTable)font.getTable(Tag.hdmx);
        HorizontalMetricsTable horizontalMetricsTable = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        MaximumProfileTable maximumProfileTable = (MaximumProfileTable)font.getTable(Tag.maxp);
        FontHeaderTable fontHeaderTable = (FontHeaderTable)font.getTable(Tag.head);
        int n3 = fontHeaderTable.unitsPerEm();
        int n4 = horizontalDeviceMetricsTable.numRecords();
        int n5 = maximumProfileTable.numGlyphs();
        MagnitudeDependentWriter magnitudeDependentWriter = new MagnitudeDependentWriter();
        for (int i = 0; i < n4; ++i) {
            n2 = horizontalDeviceMetricsTable.pixelSize(i);
            for (int j = 0; j < n5; ++j) {
                n = ((64 * n2 * horizontalMetricsTable.advanceWidth(j) + n3 / 2) / n3 + 32) / 64;
                int n6 = horizontalDeviceMetricsTable.width(i, j) - n;
                magnitudeDependentWriter.writeValue(n6);
            }
        }
        magnitudeDependentWriter.flush();
        byte[] byArray = magnitudeDependentWriter.toByteArray();
        n2 = byArray.length + HEADER_SIZE + RECORD_SIZE * n4;
        WritableFontData writableFontData = WritableFontData.createWritableFontData(n2);
        writableFontData.writeUShort(0, 0);
        writableFontData.writeUShort(2, n4);
        writableFontData.writeLong(4, horizontalDeviceMetricsTable.recordSize());
        for (n = 0; n < n4; ++n) {
            writableFontData.writeByte(HEADER_SIZE + RECORD_SIZE * n, (byte)horizontalDeviceMetricsTable.pixelSize(n));
            writableFontData.writeByte(HEADER_SIZE + RECORD_SIZE * n + 1, (byte)horizontalDeviceMetricsTable.maxWidth(n));
        }
        writableFontData.writeBytes(HEADER_SIZE + RECORD_SIZE * n4, byArray);
        return writableFontData;
    }
}

