/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.core.FontHeaderTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class LocaTable
extends Table {
    private FontHeaderTable.IndexToLocFormat version;
    private int numGlyphs;

    private LocaTable(Header header, ReadableFontData readableFontData, FontHeaderTable.IndexToLocFormat indexToLocFormat, int n) {
        super(header, readableFontData);
        this.version = indexToLocFormat;
        this.numGlyphs = n;
    }

    public FontHeaderTable.IndexToLocFormat formatVersion() {
        return this.version;
    }

    public int numGlyphs() {
        return this.numGlyphs;
    }

    public int glyphOffset(int n) {
        if (n < 0 || n >= this.numGlyphs) {
            throw new IndexOutOfBoundsException("Glyph ID is out of bounds.");
        }
        return this.loca(n);
    }

    public int glyphLength(int n) {
        if (n < 0 || n >= this.numGlyphs) {
            throw new IndexOutOfBoundsException("Glyph ID is out of bounds.");
        }
        return this.loca(n + 1) - this.loca(n);
    }

    public int numLocas() {
        return this.numGlyphs + 1;
    }

    public int loca(int n) {
        if (n > this.numGlyphs) {
            throw new IndexOutOfBoundsException();
        }
        if (this.version == FontHeaderTable.IndexToLocFormat.shortOffset) {
            return 2 * this.data.readUShort(n * FontData.DataSize.USHORT.size());
        }
        return this.data.readULongAsInt(n * FontData.DataSize.ULONG.size());
    }

    Iterator<Integer> iterator() {
        return new LocaIterator();
    }

    public static class Builder
    extends Table.Builder<LocaTable> {
        private FontHeaderTable.IndexToLocFormat formatVersion = FontHeaderTable.IndexToLocFormat.longOffset;
        private int numGlyphs = -1;
        private List<Integer> loca;

        public static Builder createBuilder(Header header, WritableFontData writableFontData) {
            return new Builder(header, writableFontData);
        }

        private Builder(Header header, WritableFontData writableFontData) {
            super(header, writableFontData);
        }

        private Builder(Header header, ReadableFontData readableFontData) {
            super(header, readableFontData);
        }

        private void initialize(ReadableFontData readableFontData) {
            this.clearLoca(false);
            if (this.loca == null) {
                this.loca = new ArrayList<Integer>();
            }
            if (readableFontData != null) {
                if (this.numGlyphs < 0) {
                    throw new IllegalStateException("numglyphs not set on LocaTable Builder.");
                }
                LocaTable locaTable = new LocaTable(this.header(), readableFontData, this.formatVersion, this.numGlyphs);
                Iterator<Integer> iterator = locaTable.iterator();
                while (iterator.hasNext()) {
                    this.loca.add(iterator.next());
                }
            }
        }

        private int checkGlyphRange(int n) {
            if (n < 0 || n > this.lastGlyphIndex()) {
                throw new IndexOutOfBoundsException("Glyph ID is outside of the allowed range.");
            }
            return n;
        }

        private int lastGlyphIndex() {
            return this.loca != null ? this.loca.size() - 2 : this.numGlyphs - 1;
        }

        private List<Integer> getLocaList() {
            if (this.loca == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.loca;
        }

        private void clearLoca(boolean bl) {
            if (this.loca != null) {
                this.loca.clear();
            }
            if (bl) {
                this.loca = null;
            }
            this.setModelChanged(false);
        }

        public FontHeaderTable.IndexToLocFormat formatVersion() {
            return this.formatVersion;
        }

        public void setFormatVersion(FontHeaderTable.IndexToLocFormat indexToLocFormat) {
            this.formatVersion = indexToLocFormat;
        }

        public List<Integer> locaList() {
            return this.getLocaList();
        }

        public void setLocaList(List<Integer> list) {
            this.loca = list;
            this.setModelChanged();
        }

        public int glyphOffset(int n) {
            this.checkGlyphRange(n);
            return this.getLocaList().get(n);
        }

        public int glyphLength(int n) {
            this.checkGlyphRange(n);
            return this.getLocaList().get(n + 1) - this.getLocaList().get(n);
        }

        public void setNumGlyphs(int n) {
            this.numGlyphs = n;
        }

        public int numGlyphs() {
            return this.lastGlyphIndex() + 1;
        }

        public void revert() {
            this.loca = null;
            this.setModelChanged(false);
        }

        public int numLocas() {
            return this.getLocaList().size();
        }

        public int loca(int n) {
            return this.getLocaList().get(n);
        }

        @Override
        protected LocaTable subBuildTable(ReadableFontData readableFontData) {
            return new LocaTable(this.header(), readableFontData, this.formatVersion, this.numGlyphs);
        }

        @Override
        protected void subDataSet() {
            this.initialize(this.internalReadData());
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.loca == null) {
                return 0;
            }
            if (this.formatVersion == FontHeaderTable.IndexToLocFormat.longOffset) {
                return this.loca.size() * FontData.DataSize.ULONG.size();
            }
            return this.loca.size() * FontData.DataSize.USHORT.size();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.loca != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n = 0;
            for (int n2 : this.loca) {
                if (this.formatVersion == FontHeaderTable.IndexToLocFormat.longOffset) {
                    n += writableFontData.writeULong(n, n2);
                    continue;
                }
                n += writableFontData.writeUShort(n, n2 / 2);
            }
            this.numGlyphs = this.loca.size() - 1;
            return n;
        }
    }

    private final class LocaIterator
    implements Iterator<Integer> {
        int index;

        private LocaIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index <= LocaTable.this.numGlyphs;
        }

        @Override
        public Integer next() {
            return LocaTable.this.loca(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

