/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CMapFormat8
extends CMap {
    private final int numberOfGroups;

    protected CMapFormat8(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format8.value, cMapId);
        this.numberOfGroups = this.data.readULongAsInt(CMapTable.Offset.format8nGroups.offset);
    }

    private int firstChar(int n) {
        return this.readFontData().readULongAsInt(CMapTable.Offset.format8Groups.offset + n * CMapTable.Offset.format8Group_structLength.offset + CMapTable.Offset.format8Group_startCharCode.offset);
    }

    private int endChar(int n) {
        return this.readFontData().readULongAsInt(CMapTable.Offset.format8Groups.offset + n * CMapTable.Offset.format8Group_structLength.offset + CMapTable.Offset.format8Group_endCharCode.offset);
    }

    @Override
    public int glyphId(int n) {
        return this.readFontData().searchULong(CMapTable.Offset.format8Groups.offset + CMapTable.Offset.format8Group_startCharCode.offset, CMapTable.Offset.format8Group_structLength.offset, CMapTable.Offset.format8Groups.offset + CMapTable.Offset.format8Group_endCharCode.offset, CMapTable.Offset.format8Group_structLength.offset, this.numberOfGroups, n);
    }

    @Override
    public int language() {
        return this.data.readULongAsInt(CMapTable.Offset.format8Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat8> {
        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readULongAsInt(n + CMapTable.Offset.format8Length.offset)), CMap.CMapFormat.Format8, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readULongAsInt(n + CMapTable.Offset.format8Length.offset)), CMap.CMapFormat.Format8, cMapId);
        }

        @Override
        protected CMapFormat8 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat8(readableFontData, this.cmapId());
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int groupIndex = 0;
        private int firstCharInGroup = -1;
        private int endCharInGroup;
        private int nextChar;
        private boolean nextCharSet;

        private CharacterIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextCharSet) {
                return true;
            }
            while (this.groupIndex < CMapFormat8.this.numberOfGroups) {
                if (this.firstCharInGroup < 0) {
                    this.firstCharInGroup = CMapFormat8.this.firstChar(this.groupIndex);
                    this.endCharInGroup = CMapFormat8.this.endChar(this.groupIndex);
                    this.nextChar = this.firstCharInGroup;
                    this.nextCharSet = true;
                    return true;
                }
                if (this.nextChar < this.endCharInGroup) {
                    ++this.nextChar;
                    this.nextCharSet = true;
                    return true;
                }
                ++this.groupIndex;
                this.firstCharInGroup = -1;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextCharSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextCharSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

