/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.core;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.math.FontMath;
import com.google.typography.font.sfntly.table.core.CMap;
import com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class CMapFormat4
extends CMap {
    private final int segCount;
    private final int glyphIdArrayOffset;

    protected CMapFormat4(ReadableFontData readableFontData, CMapTable.CMapId cMapId) {
        super(readableFontData, CMap.CMapFormat.Format4.value, cMapId);
        this.segCount = this.data.readUShort(CMapTable.Offset.format4SegCountX2.offset) / 2;
        this.glyphIdArrayOffset = CMapFormat4.glyphIdArrayOffset(this.segCount);
    }

    @Override
    public int glyphId(int n) {
        int n2 = this.data.searchUShort(CMapFormat4.startCodeOffset(this.segCount), FontData.DataSize.USHORT.size(), CMapTable.Offset.format4EndCount.offset, FontData.DataSize.USHORT.size(), this.segCount, n);
        if (n2 == -1) {
            return 0;
        }
        int n3 = this.startCode(n2);
        return this.retrieveGlyphId(n2, n3, n);
    }

    public int retrieveGlyphId(int n, int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.idRangeOffset(n);
        if (n4 == 0) {
            return (n3 + this.idDelta(n)) % 65536;
        }
        return this.data.readUShort(n4 + this.idRangeOffsetLocation(n) + 2 * (n3 - n2));
    }

    public int getSegCount() {
        return this.segCount;
    }

    public int startCode(int n) {
        this.isValidIndex(n);
        return CMapFormat4.startCode(this.data, this.segCount, n);
    }

    private static int length(ReadableFontData readableFontData) {
        int n = readableFontData.readUShort(CMapTable.Offset.format4Length.offset);
        return n;
    }

    private static int segCount(ReadableFontData readableFontData) {
        int n = readableFontData.readUShort(CMapTable.Offset.format4SegCountX2.offset) / 2;
        return n;
    }

    private static int startCode(ReadableFontData readableFontData, int n, int n2) {
        int n3 = readableFontData.readUShort(CMapFormat4.startCodeOffset(n) + n2 * FontData.DataSize.USHORT.size());
        return n3;
    }

    private static int startCodeOffset(int n) {
        int n2 = CMapTable.Offset.format4EndCount.offset + FontData.DataSize.USHORT.size() + n * FontData.DataSize.USHORT.size();
        return n2;
    }

    private static int endCode(ReadableFontData readableFontData, int n, int n2) {
        int n3 = readableFontData.readUShort(CMapTable.Offset.format4EndCount.offset + n2 * FontData.DataSize.USHORT.size());
        return n3;
    }

    private static int idDelta(ReadableFontData readableFontData, int n, int n2) {
        int n3 = readableFontData.readShort(CMapFormat4.idDeltaOffset(n) + n2 * FontData.DataSize.SHORT.size());
        return n3;
    }

    private static int idDeltaOffset(int n) {
        int n2 = CMapTable.Offset.format4EndCount.offset + (2 * n + 1) * FontData.DataSize.USHORT.size();
        return n2;
    }

    private static int idRangeOffset(ReadableFontData readableFontData, int n, int n2) {
        int n3 = readableFontData.readUShort(CMapFormat4.idRangeOffsetOffset(n) + n2 * FontData.DataSize.USHORT.size());
        return n3;
    }

    private static int idRangeOffsetOffset(int n) {
        int n2 = CMapTable.Offset.format4EndCount.offset + (2 * n + 1) * FontData.DataSize.USHORT.size() + n * FontData.DataSize.SHORT.size();
        return n2;
    }

    private static int glyphIdArrayOffset(int n) {
        int n2 = CMapTable.Offset.format4EndCount.offset + (3 * n + 1) * FontData.DataSize.USHORT.size() + n * FontData.DataSize.SHORT.size();
        return n2;
    }

    public int endCode(int n) {
        this.isValidIndex(n);
        return CMapFormat4.endCode(this.data, this.segCount, n);
    }

    private void isValidIndex(int n) {
        if (n < 0 || n >= this.segCount) {
            throw new IllegalArgumentException();
        }
    }

    public int idDelta(int n) {
        this.isValidIndex(n);
        return CMapFormat4.idDelta(this.data, this.segCount, n);
    }

    public int idRangeOffset(int n) {
        this.isValidIndex(n);
        return this.data.readUShort(this.idRangeOffsetLocation(n));
    }

    public int idRangeOffsetLocation(int n) {
        this.isValidIndex(n);
        return CMapFormat4.idRangeOffsetOffset(this.segCount) + n * FontData.DataSize.USHORT.size();
    }

    private int glyphIdArray(int n) {
        return this.data.readUShort(this.glyphIdArrayOffset + n * FontData.DataSize.USHORT.size());
    }

    @Override
    public int language() {
        return this.data.readUShort(CMapTable.Offset.format4Language.offset);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new CharacterIterator();
    }

    public static class Builder
    extends CMap.Builder<CMapFormat4> {
        private List<Segment> segments;
        private List<Integer> glyphIdArray;

        protected Builder(WritableFontData writableFontData, int n, CMapTable.CMapId cMapId) {
            super(writableFontData == null ? null : writableFontData.slice(n, writableFontData.readUShort(n + CMapTable.Offset.format4Length.offset)), CMap.CMapFormat.Format4, cMapId);
        }

        protected Builder(ReadableFontData readableFontData, int n, CMapTable.CMapId cMapId) {
            super(readableFontData == null ? null : readableFontData.slice(n, readableFontData.readUShort(n + CMapTable.Offset.format4Length.offset)), CMap.CMapFormat.Format4, cMapId);
        }

        private void initialize(ReadableFontData readableFontData) {
            int n;
            this.segments = new ArrayList<Segment>();
            this.glyphIdArray = new ArrayList<Integer>();
            if (readableFontData == null || readableFontData.length() == 0) {
                return;
            }
            int n2 = CMapFormat4.segCount(readableFontData);
            for (n = 0; n < n2; ++n) {
                Segment segment = new Segment();
                segment.setStartCount(CMapFormat4.startCode(readableFontData, n2, n));
                segment.setEndCount(CMapFormat4.endCode(readableFontData, n2, n));
                segment.setIdDelta(CMapFormat4.idDelta(readableFontData, n2, n));
                segment.setIdRangeOffset(CMapFormat4.idRangeOffset(readableFontData, n2, n));
                this.segments.add(segment);
            }
            n = CMapFormat4.length(readableFontData) - CMapFormat4.glyphIdArrayOffset(n2);
            for (int i = 0; i < n; i += FontData.DataSize.USHORT.size()) {
                this.glyphIdArray.add(readableFontData.readUShort(i + CMapFormat4.glyphIdArrayOffset(n2)));
            }
        }

        public List<Segment> getSegments() {
            if (this.segments == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.segments;
        }

        public void setSegments(List<Segment> list) {
            this.segments = Segment.deepCopy(list);
            this.setModelChanged();
        }

        public List<Integer> getGlyphIdArray() {
            if (this.glyphIdArray == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.glyphIdArray;
        }

        public void setGlyphIdArray(List<Integer> list) {
            this.glyphIdArray = new ArrayList<Integer>(list);
            this.setModelChanged();
        }

        @Override
        protected CMapFormat4 subBuildTable(ReadableFontData readableFontData) {
            return new CMapFormat4(readableFontData, this.cmapId());
        }

        @Override
        protected void subDataSet() {
            this.segments = null;
            this.glyphIdArray = null;
            super.setModelChanged(false);
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (!this.modelChanged()) {
                return super.subDataSizeToSerialize();
            }
            int n = CMapTable.Offset.format4FixedSize.offset + this.segments.size() * (3 * FontData.DataSize.USHORT.size() + FontData.DataSize.SHORT.size()) + this.glyphIdArray.size() * FontData.DataSize.USHORT.size();
            return n;
        }

        @Override
        protected boolean subReadyToSerialize() {
            if (!this.modelChanged()) {
                return super.subReadyToSerialize();
            }
            return this.segments != null;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            int n;
            if (!this.modelChanged()) {
                return super.subSerialize(writableFontData);
            }
            int n2 = 0;
            n2 += writableFontData.writeUShort(n2, CMap.CMapFormat.Format4.value());
            n2 += FontData.DataSize.USHORT.size();
            n2 += writableFontData.writeUShort(n2, this.language());
            int n3 = this.segments.size();
            n2 += writableFontData.writeUShort(n2, n3 * 2);
            int n4 = FontMath.log2(this.segments.size());
            int n5 = 1 << n4 + 1;
            n2 += writableFontData.writeUShort(n2, n5);
            int n6 = n4;
            n2 += writableFontData.writeUShort(n2, n6);
            int n7 = 2 * n3 - n5;
            n2 += writableFontData.writeUShort(n2, n7);
            for (n = 0; n < n3; ++n) {
                n2 += writableFontData.writeUShort(n2, this.segments.get(n).getEndCount());
            }
            n2 += FontData.DataSize.USHORT.size();
            for (n = 0; n < n3; ++n) {
                n2 += writableFontData.writeUShort(n2, this.segments.get(n).getStartCount());
            }
            for (n = 0; n < n3; ++n) {
                n2 += writableFontData.writeShort(n2, this.segments.get(n).getIdDelta());
            }
            for (n = 0; n < n3; ++n) {
                n2 += writableFontData.writeUShort(n2, this.segments.get(n).getIdRangeOffset());
            }
            for (n = 0; n < this.glyphIdArray.size(); ++n) {
                n2 += writableFontData.writeUShort(n2, this.glyphIdArray.get(n));
            }
            writableFontData.writeUShort(CMapTable.Offset.format4Length.offset, n2);
            return n2;
        }

        public static class Segment {
            private int startCount;
            private int endCount;
            private int idDelta;
            private int idRangeOffset;

            public static List<Segment> deepCopy(List<Segment> list) {
                ArrayList<Segment> arrayList = new ArrayList<Segment>(list.size());
                for (Segment segment : list) {
                    arrayList.add(new Segment(segment));
                }
                return arrayList;
            }

            public Segment() {
            }

            public Segment(Segment segment) {
                this(segment.startCount, segment.endCount, segment.idDelta, segment.idRangeOffset);
            }

            public Segment(int n, int n2, int n3, int n4) {
                this.startCount = n;
                this.endCount = n2;
                this.idDelta = n3;
                this.idRangeOffset = n4;
            }

            public int getStartCount() {
                return this.startCount;
            }

            public void setStartCount(int n) {
                this.startCount = n;
            }

            public int getEndCount() {
                return this.endCount;
            }

            public void setEndCount(int n) {
                this.endCount = n;
            }

            public int getIdDelta() {
                return this.idDelta;
            }

            public void setIdDelta(int n) {
                this.idDelta = n;
            }

            public int getIdRangeOffset() {
                return this.idRangeOffset;
            }

            public void setIdRangeOffset(int n) {
                this.idRangeOffset = n;
            }

            public String toString() {
                return String.format("[0x%04x - 0x%04x, delta = 0x%04x, rangeOffset = 0x%04x]", this.startCount, this.endCount, this.idDelta, this.idRangeOffset);
            }
        }
    }

    private class CharacterIterator
    implements Iterator<Integer> {
        private int segmentIndex = 0;
        private int firstCharInSegment = -1;
        private int lastCharInSegment;
        private int nextChar;
        private boolean nextCharSet;

        private CharacterIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextCharSet) {
                return true;
            }
            while (this.segmentIndex < CMapFormat4.this.segCount) {
                if (this.firstCharInSegment < 0) {
                    this.firstCharInSegment = CMapFormat4.this.startCode(this.segmentIndex);
                    this.lastCharInSegment = CMapFormat4.this.endCode(this.segmentIndex);
                    this.nextChar = this.firstCharInSegment;
                    this.nextCharSet = true;
                    return true;
                }
                if (this.nextChar < this.lastCharInSegment) {
                    ++this.nextChar;
                    this.nextCharSet = true;
                    return true;
                }
                ++this.segmentIndex;
                this.firstCharInSegment = -1;
            }
            return false;
        }

        @Override
        public Integer next() {
            if (!this.nextCharSet && !this.hasNext()) {
                throw new NoSuchElementException("No more characters to iterate.");
            }
            this.nextCharSet = false;
            return this.nextChar;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove a character from cmap.");
        }
    }
}

