
type ProjectOrientation = 'landscape' | 'portrait' | 'auto';

interface ProjectDesc {
	id: string;
	title: string;
	icon: string;
	mainScene: string;
	/** Path to project`s folder. Filed generated by fs */
	dir: string;
	defaultFont: string;
	jpgQuality: number;
	screenOrientation: ProjectOrientation;
	width: number;
	height: number;
	portraitWidth: number;
	portraitHeight: number;
	renderResolution: number;
	renderResolutionMobile: number;
	framesSkipLimit: number;
	dynamicStageSize: boolean;
	__buildConfigDebug: string;
	__buildConfigRelease: string;
	preventUpscale: boolean;
	webfontloader: {
		custom?: {
			families: string[];
		};
		google?: {
			families: string[];
		};
		timeout: number;
	} | null | WebFont.Config;
	fontHolderText: string;
	mipmap: false;
	version: string;
	soundFormats: string[];
	soundDefaultBitrate: number;
	soundBitRates: KeyedMap<number>;
	loadOnDemandSounds: KeyedMap<number>;
	loadOnDemandTextures: KeyedMap<number>;
	defaultMusVol: number;
	defaultSoundsVol: number;
	embedLocales: boolean;
	__localesNewKeysPrefix: string;
	__doNotAutoCreateLocalizationFiles: string;
	__suspendWarnings: number[];
	defaultLanguage: string;
	autoFullScreenDesktop: false;
	autoFullScreenMobile: false;
	__proxyFetchesViaNodeServer: false;
	__group: string;
	libs: string[];
}


