title: Who Won?
tags: dama
date: 2016-07-22 12:41:26+00:00

In Dama, a game ends under the following conditions:

+ A player disconnects
+ A player surrenders
+ The players agree on a draw
+ The game reaches a draw state
+ The game reaches an ended state

So many different ways to end the game, and thankfully it was super simple to streamline all this in Elixir. It's actually quite neat, and would make for a nice post one day...

In any case, when the game ends, the backend sends a `game_ended` message to the frontend, with the `GameResult`. The game result contains the rewards the players get, if any, as well as the new rating of the players, if those changed.

For now, I need to figure out how should the frontend handle this? Since the old days, the frontend simply checked the game state to see if it's still running, but that obviously doesn't cover the first three termination conditions.

So, the best way to go about this is to embed the "winning" information in the `GameResult` payload. It would need to represent the following information:

+ winner -> player x
+ draw

in Elixir, I usually represent this using atoms and tuples as follows:

```elixir
case result do
  {:winner, :white_player} -> ...
  :draw -> ...
end
```

That doesn't translate well to CSharp for the frontend .. I guess my options are:

+ String: "winner:player", "draw"
+ Enum: winner_white, winner_black, draw

I can't think of any other viable options, really ... The enum approach sounds nice, but would be painful to debug if the backend and frontend fall out of sync .. So, strings is the way to go.
