title: Growth
tags: rant
date: 2017-08-30 14:44:24+00:00

## Introduction

To be honset, I thought I lost it. This flow of inspiration to write. Share an experience, learning or otherwise quite meaningless life story. Somehow, I feel it's back now. After all this time.

What changed? Hmm .. This could be a separate blog post in of itself! Let's just say I had a turning point last week, which lead to an extremely wide range of results, as an affect of a single action from someone can really influence you in the most bizzare ways...

Well, this blog post is mostly gonna be about what I've been up to at work, and how much growth I've went through in a seemingly short period of time..

## It's The Little Things

Seemingly small changes can have a profound impact on productivity. My latest proof is [FiraCode][firacode-link].

Starting to use this font has made code **much** nicer too gaze at. As much as I "hated" operator overloading, it has become rather acceptable with the new symbols this font introduce. `~=`, `|>`, `->`, ... etc, all these look much more natural and nicer on the eyes as well.

After learning about this font, I was sitting in a coffee shop trying to solve a rather annoying problem. How can I structure the networking library tests, to encourage developers to quickly and easily write tests for their new endpoints?

My immediate inclination was to introduce a custom `XCTAssert`. That would lead to duplication, since I what I was thinking was something in the lines of:

```swift
// asserts each property separately
XCTAssertEndpointURL(endpoint, "http://mazyod.com")
XCTAssertEndpointMethod(endpoint, .post)
```

However .. I realized I should probably just implement `Equatable` protocol on `Endpoint` at this point and assert against `expectedEndpoint`:

```swift
// filling up the endpoint struct is tedious!!
var expectedEndpoint = Endpoint()
expectedEndpoint.api.baseUrl = ...
expectedEndpoint.api.headers = ...
expectedEndpoint.api.modifiers = ...
```

Yeah, it was as tedious as hell. After taking a look at the `Endpoint` objects we are building, I realized, as a tester, I want to quickly just verify the end result is somewhat appropriate. So .. I ended up adding a custom `EndpointData` helper class in the tests target, which works something like this:

```swift
// FiraCode shines here!
XCTAssert(endpoint ~= EndpointData(url: "https://testing.com/path?query=yes",
                                   method: .post,
                                   headers: ["assert-this": "ignores rest"],
                                   body: optionalBody)
```

This network endpoint testing deserves it's own post, but for the sake of this scope, here is where FiraCode sneaks in. This relationship between the two classes isn't equality, but we still want to match them ... Kinda like regex ... Which is usually annotated as `~=` in many languages ... Hence, this.

## Native Reaction

I've had to invest a lot of time and work on packing a react native component into an ObjC framework to be shipped with a fully native app. The process is not trivial, and for the uninitiated, borderline impossible.

The way ReactNative generates its projects is extremely annoying, since it creates an Xcode project, that depend on other Xcode projects in the `nodule_modules` directory. At this point, you're involving `yarn` into your Xcode build process, which isn't neat at all.

Besides that, the team is using `create-react-native-app` project, which requires ejecting before packaging .. Ejection process is [interactive, as of yet][crna-interactive]. This adds an annoying manual step in the build process.

Besides all the RN stuff, building ObjC frameworks is just super annoying, with all the header tweaking, architecture lipo-ing, and namespacing crap.

## I Shall Cast a Spell On You

Last but not least to cover this week ... [Sourcery][sourcery-link]! After contributing to Swiftlint, I really loved how they were using sourcery to generate the linux tests counterparts. That involved no extra work from the developer side, and was integrated as part of the of the build process.

I've worked many times on generating code before, but this stencil-based templating just make things way easier than writing a custom Python script each and everytime that traverses stuff in certain ways and relies on a format-based templates.

I don't, and probably won't, be using Sourcery for the `Equatable` and other protocols it demos, but certainly for other neat automations, such generating ObjC compatible bridge for generics and other Swift only types.

## Conclusion

I am liking my new job, 6 months in now! Hopefully, can focus more in the upcoming days on leveraging automation and cleansing the project further from tedious typing and legacy ... What can I say, it's a hobby for me.


[firacode-link]: https://github.com/tonsky/FiraCode
[crna-interactive]: https://github.com/react-community/create-react-native-app/pull/346
[sourcery-link]: https://github.com/krzysztofzablocki/Sourcery
