title: Freelancing Stories
tags: freelancing, programming, career, contract, toptal, client, ios, communication, project, management
date: 2015-12-02 11:24:16+00:00

## Introduction

It wouldn't be unusual to be sitting at some day job thinking... Wouldn't it be great to be one's own boss? Taking vacations anytime, no one pestering you about what you wear or when you wake up ... Sounds like the perfect lifetime plan! But how...

Of course! Why not try freelancing? You pick your own projects, finish work at your own pace, heck, you get get to decide what your salary is gonna be. You can't possibly go wrong there? .. __WRONG__.

## Negotiation

Before any project takes place, you must actually find a project. If you are a software developer, you simply don't have a problem there. Period. Clients are everywhere, with so much variety, there is literally a client for any weird scenario you may think of. That's why I decided to skip the discovery phase and start with the negotiation phase right off the bat.

### Lesson 1: People Matter

Negotiating purely on the project scope and pay spells out disaster for you as a freelancer. First think you should care about are the people you'll be working for.

One of my clients I worked for wanted a pretty simple and straight-forward iOS app. They had absolutely no clue how developing iOS apps work, and I thought to myself: "That's great! I get to set my own rules and standards, and teach them along the way". We agreed on the price, money was paid on time and all, and the project started...

As the project progressed, I first kept working on the UI side, throwing suggestions at the client, and the client was happy. The client was seeing progress, listening to my feedback, and only synced up with me once a week.

By the end of the first sprint, I showed the client a complete basic app fully functional, but without backend integration. All the data in the app was dummy data, but at least the UI implementation was almost perfect. The client sent back some minor feedback regarding the UI demo, and decided to move forward with the project and start integrating the backend ... This is where things went south.

As I started integrating various endpoints, I discovered many problems with the backend API design. It was flawed. I patiently worked with the backend developer to amend these flaws, and trying to integrate whatever I can with the app itself. At that time, the transition between Xcode 6 and 7 happened, as well as my discovery that [CoreData and Swift don't work well with each other]({filename}2015-09-09-welcome-to-realm.md).

Progress wasn't being made as fast as it started thanks to these problems, and then out of nowhere, the client got worried and discouraged. I tried to explain how the problems affecting development were slowing the progress, but due to severe lack of communication, the client just made up theories about this project, and decided to end the contract.

This was the best possible outcome for me, I was starting to hate the project, but still. I had worked hard to put this together and didn't like it ending that way. So, I started thinking back, where did it all go wrong?

It was the negotiation phase. If the client knew a little bit about the issues I was going through, they would've appreciated the effort put into making this app happen. I guess trust plays part, as well. The client didn't trust anyone, and even complained about the designer not doing his job... It was only a matter of time I would run into this issue, and I did.

### Lesson 2: Price

Whatever you do, never work for a fixed price. ___Never___. No exceptions.

There are literally zero clients that will come to you and say "Hey, my project is complicated, and I appreciate any effort you put in". Instead, all their projects are "simple" and "straight-forward", should be done in less then a few months, and they have all the details figured out... You're looking at the wireframes going, "Yeah... that's a scribble on a napkin, what am I suppose to make out of that?"

![image](/images/software_development_comic.jpg)

The solution to that is actually quite simple. Don't work for fixed price, ever. For your sake and the sake of the client, working for fixed price means one will be cheating the other. It'll either be the developer doing a crappy job and demanding the whole pay, or the client making unreasonable claims about the scope as they envisioned it, demanding you see it through (even if it takes years). Really, you don't want that.

If you are paid an hourly rate, it no longer matters how things turn out. If you are are not holding up your end of the bargain, your payment is cut. If the client wants to keep making demands, they have to start shaking them pockets. It's simply the most fair setup I found.

## Conclusion

Well, look at that! Just discussing the negotiation part took so much to cover, and yet more parts are to be discussed! I'll leave this here for now, but will hopefully post more on this topic later.
