title: POCO
tags: poco, cpp, programming, library, compile, swift, optional, compare, portability
comments: true
date: 2015-04-09 09:21:51+00:00

## Introduction

Recently, I've quit my job, and started doing lots of things I had in mind for years now. Point is, I am my own boss, and I would like to make stuff as perfect as possible.

When you are working in a very small team (1) the number one priority for you becomes speed. It doesn't matter anymore how robust your system is, how performant, how scalable ... etc, as long as you can get stuff done quickly and ship! Otherwise, welcome to the endless world of programming indulgence.

With that said, you ultimately have requirements, which are the absolute rules you can never violate. You may be able to bend some, but some hard requirements just have to be accommodated.

For my stuff, it has increasingly became apparent that I need to scale. I have verified the success of a few projects on the iOS platform in the local market, and now it's either expanding internationally or to other platforms .. Hopefully, both!

The number one language for mobile portability is without doubt C++. Apple uses C++ internally for loads of frameworks, so does Dropbox in their mobile app to share code, let's not forget Realm, it basically C++ core, and last but not least .. Facebook's fresh ComponentsKit. The C++ there actually goes beyond the internals, and is exposed in the interface!

Bottom line, brace yourself for C++ programming if you plan on going cross platform. Good news, though. We'll see why it isn't so bad to write C++ code anymore.

## What Was Wrong?

Back in the dark ages of pre-C++11 (C++x0), C++ was such a painful language with very limited features that made it very lacking when compared to newly created modern languages.

I entered the C++ world by working at a game during my time at Sourcebits. The team, (which I hope they aren't reading this now) including me, were "very behind" when it came to pure C++ programming. I mean, it was 2013, and the team didn't know about the foreach syntax, lambdas, and other essential productivity features. These features were replaced by ruthless labor of basic design patterns. The code was horrible.

I can't really go into much details here, because to me, C++ was so horrible, I might've quit programming if it was the only choice. Hence, never programmed much in it during that time, as I sticked to working on tools and scripting with ObjC and Python.

That all changed, because it had to.

## What Changed?

After that experience, I was a bit more ready to use C++, since I've learned after that job about how C++11 changed everything. Downloading Cocos2d-X and learning from it's opensource galore helped a lot in utilizing the new features.

After about a year or so doing that, I wasn't going anywhere. Dealing with Pointers, memory management, and other awefulness imposed by the Cocos2d-X engine for the sake of performance was really getting to me .. Remember the first thing I said in the introduction? Speed can't be compromised!

Meanwhile, Swift came out, and it taught me an insanely important lesson. Don't fool yourself. Language matters, and productivity is greatly effected by choosing it, so choose carefully. Also, make sure it's the language, and not that you are just a bad programmer.

So, what happened was I realized I was a really bad C++ programmer. I approached C++ the same way I would approach ObjC or python, which was a huge source of pain. Classes where unnecessarily humongous, every class depended on every other class in the system, and yeah. I didn't utilize any library.. !

## The New C++

The new C++ to me is POCO.

![image](/images/pocologo.png)

By seeing POCO's modular system and insane set of features, everything clicked. C++ is a great language, just need to utilize all available resources!

It is very important to break every single component into small pieces. Attempt to make it generic, as well, so it doesn't have many dependencies. Finally, utilize the hell out of the POCO library itself! The feature set it has and cross platform compatibility/portability is worthy of high praise. 

## But...

I know, still, this is no silver bullet. Integrating C++ with other platform languages in order to leverage native frameworks is usually painful. NDK on android isn't the most usable thing, nor C#'s dynamic plugin loader, but by investing the time upfront to put a solid build system, it could really payoff.

Tools like Djinni, SWIG, ... etc help, probably, though I have yet to start using them.

## Conclusion

I'll leave with this statement as food for thought:

> Premature optimization in C++ is worst than being a really bad programmer.


