title: 2D Game Engines
tags: comparison, cocos2d, cocos2d-x, ios, android, cross-platform, game, engine, unity3d, spritebuilder, 2d, opensource, rant, development
comments: true
date: 2015-03-15 17:14:22+00:00

## Introduction

> Vent: the expression or release of a strong emotion, energy, etc.: children give vent to their anger in various ways.

That's what's gonna happen for the next few minutes.

Regarding the backstory of all this, here is my experience with games in a nutshell:

I started game development as a hobby during college, using Java canvas to make a snake game, ping pong, and other useless stuff. Then, real game development started with cocos2d-iphone, at least that was the name back in the day. It was awesome, and one cool game was released. yay!

After that, it was a journey to set out and look for the best cross-platform 2d game engine out there...

## Game Closure

I have no idea if these guys are still around or not, but this game engine was seriously cool. It was a startup at Mountain View, CA, and I had the pleasure to go there and meet the guys.

The engine is JavaScript based, and used HTML5 canvas element to draw the game on the browser. When compiled to iOS or Android, however, the calls would be intercepted, and openGL calls would be made instead, for maximum performance.

Also made some useless snake game with this engine, and that went well, but ultimately, javascript was a language I couldn't bare write games in.

## Unity3D

Whether it's called Unity3D or without the 3D part, I don't care anymore. This game engine is a curse, the way I see it. I've spent quite some time trying to make simple games with this engine, but the workflow, glitches, rigidness .. Just unbearable. Just from my very first take on Unity, doing a simple game, I ran into a bug with animation transitions. 

I'm not used to working with unreliable closed-source technologies, so that really put me off, and I have yet to return to working with Unity since.

## Honorable Mentions

[__Godot__](https://github.com/okamstudio/godot): Looks like a really weird game engine, and I have no idea how to get stuff done with it. The problem with me, I guess, is that I can't stand game engines that provide editors, as well. Especially really clunky editors that always get in your way.

[__Unreal__](https://www.unrealengine.com): If you haven't given this engine a look, I really pity you.. Actually, I pity myself, since I haven't tried the engine yet! It's downloading as I write this, so will give it a quick shot today!

[SpriteKit/SceneKit](http://apple.com): If you are targeting apple platforms exclusively, I have no idea why you won't use these nice tools. The engine is written and polished by Apple, and even though it is closed source, it's still very stable, as it has survived the iOS 7 audit, and we are already at iOS 8 these days.

## Cocos2d-X

This is the winner, and yet this engine is _very far_ away from the dream engine I would love to have. 

Cocos2d-x is opensource, cross-platform, fast, written in C++, and extremely active. To me, that last part is why I use it.

Looking at other engines, it might take months for the team to look into a bug or regression that has been introduced, but not for the cocos2d-x team. If you submit a PR, they happily review it and merge it in record time, usually. And finally, they are always active in their forums, and interesting topics float around over there.

The only thing I really hate about this engine is that they lack a sense of maintainability, consistency, and future planning. __I don't think this applies to the code engine__, but does apply to the extensions and tools built around the engine. That's just my opinion, but here is why I think that:

### Constant Flux

The high activity comes with a toll. What works for you now, may not work in a few hours after you pull the latest code. Decisions seem to be made on the spot without any high level "Zen" that the engine should follow. 

The only thing I realized the team focuses a lot on is performance, which is fair .. But, when it comes to stuff like networking, file access, and other native APIs or I/Os, who cares about performance? The bottleneck won't be your code in those cases, it will be the outside operation.

### Inconsistency

Due to the high volume of PRs submitted, and lack of proper formatting and code structure, the code is nowhere near consistent. The core engine may be consistent and doing an amazing job, but once you go beyond that to the extensions and other plugins, it becomes a huge mess.

### Future Planning

Unfortunately, there is a lot of waste in energy and time because of this problem. A component is in the engine as a temporary solution, and a bunch of collaborators submit PRs to improve that code .. Ultimately, it gets thrown out and replaced by some new, potentially buggy, code.

## Solution?

I proposed a solution on the forums, but it didn't get much attention, unfortunately.

My solution is to have a code review teams, selected from the community, to review all PRs specific to certain changes.

For example, you would have the iOS review team, and any iOS PR must be approved by at least 2 reviewers from the iOS review team, and so on. This will help the community feel ownership, as well as contribute their expertise in fields they feel confident in. Ultimately, the more eyes on your code the better.

## Conclusion

This is my take on game engines, take it or leave it!
