title: TOL
tags: swift, programming, development, snippets, tips
comments: true
date: 2014-11-17 08:13:34+00:00

Apple have emphasized many times on the most important value that Swift prioritizes, and that is safety. They couldn't make the language safe all the way due to required Objective-C compatibility, but they did make the pure swift code as safe as possible.

Yeah, this does make our lives less stressful, but also, very arguably, makes programming more of a mechanical, manual labor rather than a creative and dynamic one. Instead of relying on "magic" to glue code together dynamically, it is now preferred to be more explicit and static.

The main issue is the lack of our favorite type in Objective-c, that is `id`. Sure, Swift has `AnyObject`, but due to some unresolved compiler issues, you can't access properties on the object directly or something. Also, resolving selectors and class from strings was an insanely powerful tool.

With all that being said, I want to quote McConnel from Code Complete:

> Don't program in a language, program into a language instead.

The gist of it is, don't let the language dictate how you solve design problems, rather solve it in a language agnostic manner, then extend your programming language if needed to meet that design.

## Conclusion

I have yet to reveal the meaning of `TOL`, and I guess I'm gonna leave it for another day.
