title: Swift V
tags: swift, tips, snippets, development, programming, xcode, enums, objc, bridging, interoperability
comments: true
date: 2014-11-12 15:58:32+00:00

For the record, I needed to use [Alfred spell command](http://support.alfredapp.com/features:dictionary) to be able to spell interoperability correctly ...

Anyways, some time ago, Apple introduced [`NS_ENUM` and `NS_OPTIONS`](http://nshipster.com/ns_enum-ns_options/) to Objective-C. Back then, it wasn't a huge improvement to warrant rolling out these macros that were pretty much handled properly by their C counterparts. However...

If one had a mind as sharp as Kenpachi's sword, then maybe they'd smelled the scent of what about to come

![image](/images/kenpachi.jpg)

First, there was the introduction of the 64-bit devices. Sure, it's ambiguous to know the size backing those enums, but I mean, if you're that much of an enum fan, I doubt anyone would want to touch your code.

The big cheese introduced this year, namely Swift, actually benefits greatly from those macros (I think they later turned into actual identifiers). When your Objective-C enums are defined using `NS_ENUM` and `NS_OPTIONS`, they are properly ported to swift enums when accessed from swift. Here is an example taken directly from my app:

```objc
typedef NS_ENUM(NSInteger, ESettingsCellType) {
    ESettingsCellPlain,
    ESettingsCellOptions,
    ESettingsCellSegmented,
    ESettingsCellSwitch,
    ESettingsCellSlider,
    ESettingsCellButton,
    ESettingsCellCheckmark,
    ESettingsCellDownload
};
```

```swift
private let reuseMap: [ESettingsCellType:String] = [
    .Plain     : "disclosure",
    .Options   : "options",
    .Segmented : "picker",
    .Switch    : "picker",
    .Slider    : "picker",
    .Button    : "disclosure",
    .Checkmark : "checkmark",
    .Download  : "download",
]
```

I am guilty of not using `NS_ENUM` at first, since this code is as old as my college days take me, but as soon as I migrated, everything ran smoothly.

Pretty cool stuff, this ObjC/Swift thingie...
