title: Swift III
tags: swift, learn, snippet, functional, programming, development, tips, xcode
comments: true
date: 2014-11-05 22:46:23+00:00

With swift, we can finally act smarter and use some sexy functional code! Functional operations, unlike python, are added as part of the object type. So, if you have an `Array`, you'd do something like `array.filter` to access the functional operator.

I don't want to go into details of how to actually use the operators, since they are superbly presented [over at the Ray Wenderlich site](http://www.raywenderlich.com/82599/swift-functional-programming-tutorial). What I am going to bore you with, however, is how this changes the way you write code.

Remember that time when you had to copy all those CollectionView layout attributes, and mutate each one, creating a new array and sending it as the return value? Let's check it out in swift, with functional awesomeness:

```swift
let layoutAttributes = super.layoutAttributesForElementsInRect(rect)
return layoutAttributes?.map() {
    (attribute) -> UICollectionViewLayoutAttributes in

    let newAttributes = attribute.copy() as UICollectionViewLayoutAttributes
    newAttributes.center = ... // do whatever
        
    return newAttributes
}
```

How can you not fall in love with that?
