title: Swift II
tags: swift, snippet, awesome, tricks, tips, learn, programming
comments: true
date: 2014-11-05 22:31:53+00:00

Apple have really took all that frustration that bottled up in Objective-C developers, and decimated it in Swift.

In Objective-C, you had to do a small dance to configure C struct variables on Objective-C objects. Here is what I mean:

```objc
CGRect frame = self.view.frame;
frame.origin.y = 0;

self.view.frame = frame;
```

This is because when you access `view.frame`, that returns a C object by **value**. Any changes you make to it do not reflect back to the view.

In Swift, not only have Apple removed that problem, but went ahead and kicked ass beyond what we hoped for:

```swift
view.frame.origin.x = 0     // Works!!
let minY = view.frame.minY  // AWESOME!!
...
```

So basically, Apple really got rid of that C baggage that included using `CGRectGet...` stuff.. 
