title: On APNS
tags: ios, apple, apn, push-notifications, remote-notifications, register, unregister, ios8
comments: true
date: 2014-10-24 16:27:16+00:00

Recently, I went back to my undocumented project to implement a few new features that are related to the recent change the the push notification API on iOS 8. I fell into a trap, that I only recalled I've fell into it before after falling into it again `>__<`

## Push Notifications

Apparently, you should only call "unregister for remote notifications" on [rare circumstances](https://developer.apple.com/library/ios/DOCUMENTATION/UIKit/Reference/UIApplication_Class/index.html#//apple_ref/occ/instm/UIApplication/unregisterForRemoteNotifications). The reason for that is, Apple is saying that you should tweak the push notification behavior on the server side rather than unregistering and re-registering based on the user settings.

An important note here is, the user is able to completely block push notifications from the app through the iOS settings.app. That is how Apple wants users to behave:

> Don't make users disable and enabled push notifications through the app. Instead, there is a single place to manage all notification settings for all apps, and that is in the settings app.

Of course, that quote isn't from Apple, but I am just shoving words in their mouths from what I can conclude from the docs.

## iOS 8

If you haven't heard, Apple has transitioned in iOS 8 to `UIUserNotification` APIs, that consolidate the `UILocalNotifications` and `UIRemoteNotifications` APIs. It's nice, and it completely lacks the `unregister` method discussed above. So, you are forced to do things the Apple-way.

## Conclusion

I really hope Apple just stops everything for a whole year, and stabilize iOS, Mac, Swift, Xcode, and all the other new goodies they threw at us. They are all pretty awesome, but lots of issues are surfacing with these new changes.
