title: Amazon EC2
tags: amazon, ec2, ubuntu, permission, wsgi, rsync, deploy, bottle, flask, initialize
comments: true
date: 2014-10-06 21:06:41+00:00

## Introduction

As the case is with most developers, I decided to move away from GoDaddy's PHP hosting, and move to Amazon EC2, because that's what the cool kids do these days. I have to say, though, if you just want to get shit done, GoDaddy was 100 times less painful. However, after deploying on GoDaddy, I still felt novice and didn't learn a thing... So, for the sake of improving and learning, EC2 is way better.

## Pandora's Box

The first thing I had to do was run our site on this shiny new server. My choice of poison was [Flask](http://flask.pocoo.org/). Honestly, [bottle](http://bottlepy.org/docs/dev/index.html) would've served me just as well, but in any case.

I got the site up and running in no time on my local machine. The horrors started after I wanted to deploy.

### Lesson #1: Permissions

> If something doesn't work on Linux, check your permissions.

After following a tutorial step-by-step and setting up apache, along side the wsgi configuration, I got really weird errors from the server. I looked up the logs, nothing. It wasn't even logging properly.

Banding my head for hours, and stripping down the application to a bare minimum, I finally stumbled upon a solution that suggested checking your permissions. Now, the first thing I do is permissions, before checking if I missed a semi-colon.

### Lesson #2: Invest in the Best

> Beyond your first option, is a best option.

The wsgi thingie worked! I was happy to see all the things showing when I navigate to our site. It was a happy moment, yet too early to celebrate.

Our site provides a service that needs to be up-to-date on daily basis. Hello, Daemons.

Daemons was a very new topic to me, and the whole Linux thing was, too. I am no sysadmin, and it was torture to work as one. Reality is, I had to do it, anyway.

[Code monkey](http://www.youtube.com/watch?v=qYodWEKCuGg) search online for resources...

Code monkey find `init.d` daemons...

Code monkey thinks this is the best way...

Code monkey wastes hours messing with the syntax.. 

Code monkey finally searches for alternatives and finds the awesome [Upstart](http://upstart.ubuntu.com/cookbook/).

With upstart, it was as easy as pi to get the daemon running, and it was time to actually put together the daemon script!

### Lesson #3: Log is your friend

> No matter what application you are writing, just make sure you have logging setup properly right off the bat.

I didn't really learn that logging is your friend from this experience, but I did invest a lot of time setting up proper logging. What is a better logging mechanism than to get an email when something happens? Get an SMS!

Well, I didn't setup SMS notification (yet), but email logging is pretty cool by itself. The problem is, python's default mail handler, [SMTPHandler](https://docs.python.org/2/library/logging.handlers.html) doesn't have TLS capabilities integrated, so it didn't work with Gmail accounts. Searching for solutions online, they didn't seem to work properly for me. That's when I looked outside python.

I was unfortunate to try and setup email logging through [postfix](http://www.postfix.org/) initially, which is a freakin overkill.

It didn't get any better when I found [sSMTP](https://wiki.archlinux.org/index.php/SSMTP). After installing ssmtp, it was easy to send emails through terminal, but I had to go through all the [subprocess](https://docs.python.org/2/library/subprocess.html) ride to get something working, and it didn't work as expected...

After trying to fix it for a while, I went back to look into python again, and found [smtplib](https://docs.python.org/2/library/smtplib.html). This worked perfectly, alongside a simple producer/consumer setup, using [Queue](https://docs.python.org/2/library/queue.html), it was working like a charm.

With all that in place, one can now have a little piece of mind knowing that if the server chokes, we'll get notified right away.

### Lesson #4: Automation

> Computers are good for two things: Crunching numbers and repetition

I can't really imagine anyone trying to configure a server and develop on it without having some sort of scripting language in their toolset. If you're spending more than 1% of your time not writing business logic and solving problems, your process is not automated enough.

That doesn't only include scripts to make your workflow easier and faster, but also loggers to identify problems quickly and unit testing / regression testing.

## Conclusion

If you ever decided to build your backend service on Amazon EC2, make sure you're doing it for the right reasons. There are many other better and easier alternatives, otherwise, prepare to invest lots of time in this.
