title: Rant
tags: rant, refactoring, refactor, code, programming, objective-c, dispatch, uiview, animation
comments: true
date: 2014-05-15 21:47:12+00:00

I had this urge to just write a blog post, but don't exactly know what to write about... Something broke along the way, I should be blogging like twice a day on average.

Anyways, let me see what should the first topic be...

## Refactoring

I have been spending most of my extra energy refactoring the code I am working with at work. Some code hasn't been visited since 2012, and I am just looking at the code, and I am thinking ... "I have to understand what this does". You see, you can't really go into the flow state without a full clear idea of a macro perceptive of what you are working on.

Let's track back a bit, I am saying too many things...

One, [the flow state](http://en.wikipedia.org/wiki/Flow_(psychology). You can only be _truly_ productive if you enter this state. In order to enter this state, you need a clear goal, and very strong understanding of the work that has to be done. Basically, there is no flow state when you are just staring at the screen trying to understand something.

So, while I am looking around understanding code, I come across old code, which of course, is "bad" in terms of the current state of the project. Instead of enduring the pain of understanding the code, I go ahead and refactor it as well, so my future self, or other programmers don't endure it, as well.

The process of refactoring is awesome because it actually allows you to enter the flow state even though you don't understand the code, and you are trying to understand it! HOW?!

Let me pull a real example:

```objc
// FROM
[UIView animateWithDuration:1.6
                 animations:^{
                     dispatch_async(dispatch_get_main_queue(), ^{
                         int64_t delayInSeconds = 1500; //milliseconds actually
                         dispatch_time_t popTime = dispatch_time(DISPATCH_TIME_NOW, delayInSeconds * NSEC_PER_MSEC);
                         dispatch_after(popTime, dispatch_get_main_queue(), ^(void){
                                [self doSomething];
                        });
                     });
                 }
                 completion:^(BOOL finished) {
}];

```

Anyways, this is code that hasn't evolved as fast as the project.

So, while in complete focus, you see that the code is in `dispatch_asyc`, and then another dispatch is made. Obviously, we don't need both, so BAM. Get rid of the outer async call.

Then, you see the `milliseconds actually` comment, and you simply rename that variable, and delete the comment. It's a systematic process. You just apply what makes sense. Now, you got rid of that async call and useless comment.

Finally, you realize the delay can be added to the `animateWithDuration` call, and after you do that, the code doesn't work anymore! You go into `doSomething`, and voala! There is **another** `animateWithDuration` call, and that's why it didn't work.

All this, as I mentioned, is systematic, and you can easily submit to the flow, and before you realize it, you have this code instead:

```objc
// TO
dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1.5f * NSEC_PER_SEC)), dispatch_get_main_queue(), ^
{
    [self doSomething];
});

```

Now, if anyone dares looks me in the eye and says refactoring is a waste of time, I'd probably lose hope in that individual's future.

**Yes, this is real code I dealt with.**

## Google Tag Manager

Because, why not?

Recently, I was asked to implement Google Tag Manager in our application for marketing purposes, and I'd like to share my thoughts on this beast.

We haven't used it much, but my initial thought is.. *WOW*.

This beast is like a container for your "tags". A tag is basically an addon that drives your application. This addon can be other apps, custom data, ... you name it! All managed from [a single slick web interface over at google's website](http://www.google.com/tagmanager).

So, after integrating your app with GTM, all you have to do as a developer is deal with this single SDK! The powers it gives you are:

1. Pull custom data from backend. (Customization)
2. Integrate with apps on the fly. (AdWords, analytics, .. etc.)
3. Manage container versions, and be backward compatible!

Yeah, it's pretty darn awesome. Will post later how it actually performs, though.

## Decorator Pattern

I made use of the decorator pattern, so I might as well share that! :D

The premise of the decorator pattern for GUI systems is that .. You decorate the base view with decorators! So, the decorator I wrote simply applies a "popup" effect, by rounding the corners and adding a close button at the top left corner.

Pretty neat stuff! Now, any view you want to show as a popup is developed independent of this aesthetic look... Truly awesome stuff. *MUCH, MUCH* better than the naive approach of "Uh, yeah, let's just subclass".

## Reading

Opposed to my lack of blogging recently, I have been reading... and reading A LOT. If I am walking.. Just walking, and not responding to emails, whatsapps, ... etc, I am reading something. To the point that, I walked the whole Mall of the Emirates back and forth to take a passport pic, and while walking, I finished 5 chapters of my book.

I am not sure it's good or bad, but it's sure productive! Walking is now coupled with reading, and is no longer irritating. Sometimes while walking, some (me) get affected by their surrounding negatively, and could flip their mood completely. But reading, and immersing yourself in that book instead of what's around you, ... is bad, actually. One ought to be more social than that...

## Food

Without feeding, we can't survive... Wait, wth am I writing! OK, I need to go eat .. NOW.

## Conclusion

I like blogging... I wish people would blog more often, and especially people like [Abdullah Al-Shalabi](http://startupq8.com/). Freaking awesome stuff he puts up on those posts.
