title: apiary
tags: io, api, design, snippets, rant, backend, development, restful
comments: true
date: 2014-04-04 11:21:32+00:00

For this weekend, I have made a switch to backend development. I haven't touched the project for a while, and it seems I have a severe misunderstanding on how the process should be...

### Mistake #1

I had a freaking GUI application written with [Kivy](http://kivy.org/) in order to test the backend! I mean, I loved kivy, and wanted to test it out anyway, but ... Not for this, man!!

Testing systems must be autonomous!! As you add more features to the backend, checking for regression should be done with a simple hit on the "Enter" key. That's why, the first thing I need to do is migrate the GUI app tests to use [pyTest](http://pythontesting.net/framework/pytest/pytest-introduction/) + [requests](http://docs.python-requests.org/en/latest/).

### Mistake #2

I am using Google App Engine (GAE) for the backend, and I was trying to write unit tests using their recommended testbed/unittest combo. It's all good until I realized that the test cases I was trying to write were for the webapp2 router, not he GAE goodies (memcache, datastore, ... etc).

So, as mentioned, I am migrating to pyTest, and hopefully life will be all rainbows and unicorns.

### Mistake #3

The first thing I tried to do when I jumped on the project was to write the pyTest cases, however, there was one slight problem... I don't freaking remember how I designed the API responses!! I know the request is gonna return a JSON response, but ... What exactly??

Of course, I could just jump into the code, and look all over the place for the JSON response builder and stuff, which might change, and I might forget or break, since it looks different in code...

That's where [apiary](http://apiary.io/) came in. Design and even test the API before you freaking implement it?! That's freaking genius. This way, I can hopefully do some rapid development... In their website, it has this pic:

![image](/images/design-use-implement-schematics-3a62dc1bfe04ad11.png)

I don't disagree, but in my case, it will probably be:

```text
design <--> write test case

```

That will be awesome. Then, hooking the test cases with the actual GAE application, I can immediately start working on making all the tests pass!

## Conclusion

I thought that the point of working at a company/startup was to learn the industry standards and tools... That is just a secondary goal, actually. The greater learning experience is in how to approach and tackle problems.
