title: Enter the New Job
tags: rant, snippets, diary, programmer, job, startup, hiring, codairy, enterpenuer
comments: true
date: 2014-03-28 03:29:32+00:00

This is like the very first piece of information I `System.out.printf()` about my new job. It is also a `co`diary entry, which is an entry that delivers information through pieces of code.

So, there is a startup called [Telly](http://telly.com), which is focused primarily on their [SVOD](http://en.wikipedia.org/wiki/SVOD) (Subscription Video on Demand) service, delivered through the web, iOS and Android. They recently made the `True` choice of `from Kuwait import Mazyod`, since I am awesome (No, really. I am).

I want to do a `goto` here, and talk about startups for a bit. [The Lean Startup](http://theleanstartup.com/) book I am listening to repeats the `#define` so much, that I think I `[mazBrain addObject:definition]` without realizing it. Here is my vague recall:

> A startup is a team that operates with __very high uncertainty__ to solve a specific problem.

### Working At A Startup

__There was no way for me to start my own thing and for it to succeed.__ Let's me just `throw` that out there first, for you guys to `catch` it.

I've been to startup talks. I read books and went to discussions [_with real, full-fledged enterpenuers_](http://fishfishme.com). I was naive. That `~Knowledge()` everything away. Just like that.

The `NSError *` was, when I was listening to those books, and attending those meeting, I wasn't asking the right questions, and didn't `information.parse()` the right way. Now, I am re`information.parse()`ing, after joining a real startup.

__Uncertainty__. That's a lovely word to `#include` in a startup's `#define`. Focusing on the customer, and spending more time `subprocess.communicate()`ing, rather than just writing code is much more productive in the long run. The exercise of `new Scanner(user.requirements())` is just much more important, since:

> What could be worse than releasing an unfinished product? Releasing a product that nobody wants.

Another very `!important` point is concentration. Startups aren't really the `malloc()` for working just at work. I noticed a `HUGE_VALF` improvement, for example, when I pushed a `new RuntimeException()` I was stuck on, to later that night, to allow myself to think about the problem, and cook it in my head. It's like, you should always be ready to jump at the project anytime, because you are excited about it .. if not:

![image](/images/joker.gif)

## Conclusion

OK, I decided to `goto` the conclusion fast, because I am at the beginning, and yet to see the full picture. There are some small missing pieces I would like to `memset()` still, before I go deeper into this.

_P.S.: Shoot me a commnet about this `co`diary thing._



