title: About
layout: page
permalink: /about/
date: 2014-08-25 03:41

There once was a severely confused programmer who thought that he needs to write everything himself that the standard
language libraries did not provide. Not only that, but he also thought that everything there is to learn about a
programming language could be found in his Deitel textbook of crappiness.

![Java app](/images/reminiscence_of_the_java_1.gif)

That poor programmer grew very little in that confined mindset he had, and barely wrote extremely simple programs with
tons and tons of code. His main motivation back then were two things: His love for coding, and, encouraged by his
programming mentor, the skills he demonstrated in programming challenges.

![Smiley app](/images/reminiscence_of_the_java_2.gif)

A year or so later, still not knowing the importance of a VCS, he decided to take on iOS development, and that was back
in the dark ages of Xcode 3. The programmer easily wrapped his head around the manual reference counting memory
management and the awkward Objective-C syntax, since that is really the easy part of iOS development. Luckily, our
programmer used the power of stack overflow, borrowed some knowledge from a friend, and armed with the Apress Beginning
iPhone Development book, he somehow pulled it off...

![Kuwait Prayer Times](/images/Icon_BIG.png)

The first application he built was a tremendous success. It was insane how many people used the crappy first version of
the app out of pure need of the functionality it provided. That really motivated our friend and made him aim bigger. He
seemed to be really absorbed by the idea of gamemaking, and being a gamer himself only made it more appealing.

![Snake Java](/images/reminiscence_of_the_java_3.gif)

While struggling with full course loads, he set out to build a game this time. The idea of the game was a simple
checkers game, and without anyone there to help, he had to write the code, generate the assets, and luckily hire a
sound engineer to do the music. After 6 months or so, the long awaited release date was due, and the amount of traction
the game got was stunning.

![Dama Promo](/images/DamaPromo.png)

The game made our programmer able to afford a better laptop, and invest the rest because that's all he needs, anyway.

At that time, it was already time for the senior year at the Engineering school he was attending, so the capstone design
project was the main theme at that time. Inspired by his professor, he lead a team of 5 towards a very ambitious
project. The project was to be developed for Mac, Windows, iOS and Android... and a webapp. Yeah, that wasn't gonna end
well, and it didn't.

![Islamicaster](/images/Project_Facade.jpg)

The leader realized that not everyone in the team shared his vision, motivation, and goal. He realized that rather than
trying to accommodate everything and carry all the burden, he was suppose to serve as a source of inspiration and
motivation for the group. Little did he realize that he ended up being a source of intimidation most of the time
instead.

Well, that project taught him many lessons, and after 1.5 years of hard work, the app was successfully launched for both
iOS and Android, even though the team was mainly reduced to two people.

Working on that project for so long gave our typecast iOS developer a strong skill set he can penetrate from. That's
why after graduation, he set his eyes on the world beyond his home town and comfort zone. He set his eyes on Barcelona,
Turkey and Cambodia... But little did he know, with the help of a valuable friend, that he will end up in the largest
and most important tech hub in the world... San Francisco.

![Sourcebits](/images/Sourcebits_Logo_Web_Large.png)

The intern was now working in a prominent SF based company as part of a game team. He couldn't have been more lucky, it
was the jackpot of jackpots. His direct boss was both an extremely knowledgable and kind person. The boss welcomed the
intern with an open heart, and started teaching him the way of the industry. Most of the lessons were regarding game
design, but as you might be aware, game design is closely connected to other core values and emotions, since that's
what game designers must understand to build their games around.

![never ever](/images/peasant_conceptColor.jpg)

For almost two months, our pupil completely fed from the knowledge of his boss. By that time, he was itching to start
looking into this game their making, and *maybe* be able to contribute something... *anything*, he thought. The only
problem was, there were no engineers in the SF office. They were all working from remote places.

The eager intern brought up the idea of contributing to the game, just as a thought. This put him in touch with the
technical lead, and it all started from there.

![never ever](/images/UI-10-defeat-popup_modal-cut-ready-1.png)

As the technical lead worked on designing a network component, he was also thinking about the best way to implement this
design. With our intern in the picture, using Game Center was now a viable and quick way to prototype the design and get
something up and running in very little time. That's how the domino effect started.

![meta](/images/meta.png)

From implementing the Game Center functionality, the intern passed the test in the proving grounds. This increased his
credibility in the team, and slowly, but surely, increased the responsibilities.

From the network component, to developing the UI of the game, to developing scripts for the art team, all the way to
developing the tools necessary for artists and designers to add their contributions to the game. Step by step, he
continuously took on more daunting challenges, that ultimately accelerated his growth by order of magnitude.

Alas, that journey came to a saddening end; that is when he realized how this game is never going to make it to the
market. Approached by another company with what seemed like a dream job, he decided to take the bold step forward and
leave the game team, along with their full-time offer, and endeavor onto the next step in life.

Being hired to do something he was already so proficient at, our iOS developer found the time to develop his skills
further using other means that work. Reading books, contributing to open source, and even working on side projects
started to have a large impact on a different level than before. He realized more about his passion. He found vibrant
online communities he can be part of. He is set to do anything but the sane and logical.

![telly logo](/images/telly.png)

... To be continued
