import React from 'react';

import { Icon } from '@chakra-ui/icons';

export const TocklerLogoText = props => (
    <Icon viewBox="0 0 84 25" width="84px" height="25px" {...props}>
        <title>Tockler</title>
        <g id="Symbols" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
            <g
                id="Header"
                transform="translate(-57.000000, -15.000000)"
                fill="currentColor"
                fillRule="nonzero"
            >
                <g id="Tockler">
                    <path d="M67.128418,35.203125 C67.8308919,35.203125 68.3513997,35.055013 68.6899414,34.7587891 C69.0284831,34.4625651 69.1977539,33.9886068 69.1977539,33.3369141 L69.1977539,33.3369141 L69.1977539,17.1884766 C69.9256185,17.2138672 70.5455729,17.2646484 71.0576172,17.3408203 C71.5696615,17.4169922 72.0013021,17.5016276 72.3525391,17.5947266 C72.703776,17.6878255 72.9873047,17.789388 73.203125,17.8994141 C73.4189453,18.0094401 73.590332,18.1067708 73.7172852,18.1914062 C73.8442383,18.2760417 73.9436849,18.3479818 74.015625,18.4072266 C74.0875651,18.4664714 74.1573893,18.4960938 74.2250977,18.4960938 C74.3351237,18.4960938 74.4282227,18.4580078 74.5043945,18.3818359 C74.5805664,18.3056641 74.644043,18.2125651 74.6948242,18.1025391 C74.7456055,17.992513 74.7836914,17.8761393 74.809082,17.753418 C74.8344727,17.6306966 74.847168,17.5227865 74.847168,17.4296875 C74.847168,17.3111979 74.8387044,17.1948242 74.8217773,17.0805664 C74.8048503,16.9663086 74.7709961,16.8583984 74.7202148,16.7568359 C74.6694336,16.6552734 74.5932617,16.5642904 74.4916992,16.4838867 C74.3901367,16.4034831 74.2547201,16.3421224 74.0854492,16.2998047 C73.9077148,16.257487 73.6241862,16.219401 73.2348633,16.1855469 C72.8455404,16.1516927 72.3821615,16.1220703 71.8447266,16.0966797 C71.3072917,16.0712891 70.7127279,16.0522461 70.0610352,16.0395508 C69.4093424,16.0268555 68.7407227,16.0205078 68.0551758,16.0205078 C66.6163737,16.0205078 65.2664388,16.1347656 64.0053711,16.3632812 C62.7443034,16.5917969 61.6398112,16.9451497 60.6918945,17.4233398 C59.7439779,17.9015299 58.9970703,18.5024414 58.4511719,19.2260742 C57.9052734,19.949707 57.6323242,20.8066406 57.6323242,21.796875 C57.6323242,22.1692708 57.691569,22.5205078 57.8100586,22.8505859 C57.9285482,23.1806641 58.1020508,23.4684245 58.3305664,23.7138672 C58.559082,23.9593099 58.836263,24.1518555 59.1621094,24.2915039 C59.4879557,24.4311523 59.8540039,24.5009766 60.2602539,24.5009766 C60.5226237,24.5009766 60.7871094,24.4607747 61.0537109,24.3803711 C61.3203125,24.2999674 61.5572917,24.1772461 61.7646484,24.012207 C61.9720052,23.847168 62.141276,23.6419271 62.2724609,23.3964844 C62.4036458,23.1510417 62.4692383,22.8590495 62.4692383,22.5205078 C62.4692383,22.2835286 62.4353841,22.0825195 62.3676758,21.9174805 C62.2999674,21.7524414 62.2174479,21.6191406 62.1201172,21.5175781 C62.0227865,21.4160156 61.9169922,21.3419596 61.8027344,21.2954102 C61.6884766,21.2488607 61.5805664,21.2255859 61.4790039,21.2255859 C61.3520508,21.2255859 61.2399089,21.261556 61.1425781,21.3334961 C61.0452474,21.4054362 60.941569,21.4816081 60.831543,21.5620117 C60.7215169,21.6424154 60.5987956,21.7185872 60.4633789,21.7905273 C60.3279622,21.8624674 60.1544596,21.8984375 59.9428711,21.8984375 C59.9005534,21.8984375 59.8307292,21.8878581 59.7333984,21.8666992 C59.6360677,21.8455404 59.5408529,21.7947591 59.4477539,21.7143555 C59.3546549,21.6339518 59.2721354,21.5133464 59.2001953,21.3525391 C59.1282552,21.1917318 59.0922852,20.9759115 59.0922852,20.7050781 C59.0922852,20.3242188 59.2023112,19.9772135 59.4223633,19.6640625 C59.6424154,19.3509115 59.925944,19.0694987 60.2729492,18.8198242 C60.6199544,18.5701497 61.0135091,18.3500977 61.4536133,18.159668 C61.8937174,17.9692383 62.3338216,17.8063151 62.7739258,17.6708984 C63.2140299,17.5354818 63.6350911,17.4318034 64.0371094,17.3598633 C64.4391276,17.2879232 64.7755534,17.2392578 65.0463867,17.2138672 L65.0463867,17.2138672 L65.0463867,33.3369141 C65.0463867,33.9886068 65.2156576,34.4625651 65.5541992,34.7587891 C65.8927409,35.055013 66.4174805,35.203125 67.128418,35.203125 Z M78.6430664,35.203125 C79.4217122,35.203125 80.1665039,35.0528971 80.8774414,34.7524414 C81.5883789,34.4519857 82.2125651,34.0097656 82.75,33.4257812 C83.2874349,32.8417969 83.7169596,32.1223958 84.0385742,31.2675781 C84.3601888,30.4127604 84.5209961,29.4309896 84.5209961,28.3222656 C84.5209961,27.2050781 84.3601888,26.2381185 84.0385742,25.4213867 C83.7169596,24.6046549 83.2874349,23.9296875 82.75,23.3964844 C82.2125651,22.8632812 81.5883789,22.4676107 80.8774414,22.2094727 C80.1665039,21.9513346 79.4217122,21.8222656 78.6430664,21.8222656 C77.8644206,21.8222656 77.1196289,21.9619141 76.4086914,22.2412109 C75.6977539,22.5205078 75.0735677,22.9394531 74.5361328,23.4980469 C73.9986979,24.0566406 73.5691732,24.7527669 73.2475586,25.5864258 C72.925944,26.4200846 72.7651367,27.391276 72.7651367,28.5 C72.7651367,29.608724 72.925944,30.5820312 73.2475586,31.4199219 C73.5691732,32.2578125 73.9986979,32.9560547 74.5361328,33.5146484 C75.0735677,34.0732422 75.6977539,34.4943034 76.4086914,34.777832 C77.1196289,35.0613607 77.8644206,35.203125 78.6430664,35.203125 Z M78.6430664,33.9082031 C78.2283529,33.9082031 77.894043,33.7537435 77.6401367,33.4448242 C77.3862305,33.1359049 77.191569,32.7275391 77.0561523,32.2197266 C76.9207357,31.7119141 76.8318685,31.1342773 76.7895508,30.4868164 C76.7472331,29.8393555 76.7260742,29.1770833 76.7260742,28.5 C76.7260742,27.8229167 76.7472331,27.1627604 76.7895508,26.5195312 C76.8318685,25.8763021 76.9207357,25.3028971 77.0561523,24.7993164 C77.191569,24.2957357 77.3862305,23.8894857 77.6401367,23.5805664 C77.894043,23.2716471 78.2283529,23.1171875 78.6430664,23.1171875 C79.0577799,23.1171875 79.3920898,23.2631836 79.6459961,23.5551758 C79.8999023,23.847168 80.0945638,24.2386068 80.2299805,24.7294922 C80.3653971,25.2203776 80.4563802,25.7810872 80.5029297,26.4116211 C80.5494792,27.0421549 80.5727539,27.6959635 80.5727539,28.3730469 C80.5727539,29.0501302 80.5494792,29.71875 80.5029297,30.3789062 C80.4563802,31.0390625 80.3653971,31.6315104 80.2299805,32.15625 C80.0945638,32.6809896 79.8999023,33.1041667 79.6459961,33.4257812 C79.3920898,33.7473958 79.0577799,33.9082031 78.6430664,33.9082031 Z M91.8842773,35.1777344 C92.6206055,35.1777344 93.2765299,35.0867513 93.8520508,34.9047852 C94.4275716,34.722819 94.9311523,34.4943034 95.362793,34.2192383 C95.7944336,33.9441732 96.1625977,33.6500651 96.4672852,33.3369141 C96.7719727,33.023763 97.0216471,32.7360026 97.2163086,32.4736328 L97.2163086,32.4736328 L96.8989258,32.1689453 C96.6958008,32.3466797 96.4863281,32.5138346 96.2705078,32.6704102 C96.0546875,32.8269857 95.8282878,32.9645182 95.5913086,33.0830078 C95.3543294,33.2014974 95.1025391,33.2945964 94.8359375,33.3623047 C94.5693359,33.430013 94.2879232,33.4638672 93.9916992,33.4638672 C93.331543,33.4638672 92.7560221,33.3221029 92.2651367,33.0385742 C91.7742513,32.7550456 91.3637695,32.3551432 91.0336914,31.8388672 C90.7036133,31.3225911 90.4560547,30.6984049 90.2910156,29.9663086 C90.1259766,29.2342122 90.043457,28.4238281 90.043457,27.5351562 C90.043457,26.7311198 90.1323242,26.043457 90.3100586,25.472168 C90.487793,24.9008789 90.7120768,24.4332682 90.9829102,24.0693359 C91.2537435,23.7054036 91.5541992,23.4388021 91.8842773,23.2695312 C92.2143555,23.1002604 92.5275065,23.015625 92.8237305,23.015625 C93.1030273,23.015625 93.2976888,23.0664062 93.4077148,23.1679688 C93.5177409,23.2695312 93.5833333,23.4049479 93.6044922,23.5742188 C93.625651,23.7434896 93.6214193,23.9339193 93.5917969,24.1455078 C93.5621745,24.3570964 93.5473633,24.5771484 93.5473633,24.8056641 C93.5473633,24.9833984 93.5727539,25.1547852 93.6235352,25.3198242 C93.6743164,25.4848633 93.7547201,25.6350911 93.8647461,25.7705078 C93.9747721,25.9059245 94.1186523,26.0138346 94.2963867,26.0942383 C94.4741211,26.1746419 94.6941732,26.2148438 94.956543,26.2148438 C95.2019857,26.2148438 95.417806,26.1661784 95.6040039,26.0688477 C95.7902018,25.9715169 95.9446615,25.840332 96.0673828,25.675293 C96.1901042,25.5102539 96.2832031,25.3155924 96.3466797,25.0913086 C96.4101562,24.8670247 96.4418945,24.6321615 96.4418945,24.3867188 C96.4418945,24.0566406 96.3657227,23.7371419 96.2133789,23.4282227 C96.0610352,23.1193034 95.8304036,22.8463542 95.5214844,22.609375 C95.2125651,22.3723958 94.8253581,22.1819661 94.3598633,22.0380859 C93.8943685,21.8942057 93.3484701,21.8222656 92.722168,21.8222656 C92.2482096,21.8222656 91.7552083,21.889974 91.2431641,22.0253906 C90.7311198,22.1608073 90.2296549,22.3618164 89.7387695,22.628418 C89.2478841,22.8950195 88.7802734,23.2272135 88.3359375,23.625 C87.8916016,24.0227865 87.5022786,24.4840495 87.1679688,25.0087891 C86.8336589,25.5335286 86.5691732,26.1196289 86.3745117,26.7670898 C86.1798503,27.4145508 86.0825195,28.1233724 86.0825195,28.8935547 C86.0825195,29.8837891 86.2454427,30.7661133 86.5712891,31.5405273 C86.8971354,32.3149414 87.3308919,32.9729818 87.8725586,33.5146484 C88.4142253,34.0563151 89.0341797,34.4689128 89.7324219,34.7524414 C90.4306641,35.0359701 91.1479492,35.1777344 91.8842773,35.1777344 Z M112.374512,39.6337891 C112.924642,39.6337891 113.3986,39.6083984 113.796387,39.5576172 C114.194173,39.5068359 114.54541,39.4391276 114.850098,39.3544922 C115.154785,39.2698568 115.425618,39.1704102 115.662598,39.0561523 C115.899577,38.9418945 116.132324,38.8212891 116.36084,38.6943359 L116.36084,38.6943359 L116.119629,38.25 C116.018066,38.3007812 115.920736,38.343099 115.827637,38.3769531 C115.743001,38.4108073 115.649902,38.4404297 115.54834,38.4658203 C115.446777,38.4912109 115.345215,38.5039062 115.243652,38.5039062 C114.659668,38.5039062 114.046061,38.3177083 113.402832,37.9453125 C112.759603,37.5729167 112.088867,36.9952799 111.390625,36.2124023 C110.692383,35.4295247 109.966634,34.4308268 109.213379,33.2163086 C108.460124,32.0017904 107.68571,30.5524089 106.890137,28.8681641 C107.482585,28.5634766 107.97347,28.2270508 108.362793,27.8588867 C108.752116,27.4907227 109.063151,27.1098633 109.295898,26.7163086 C109.528646,26.3227539 109.693685,25.9249674 109.791016,25.5229492 C109.888346,25.120931 109.937012,24.733724 109.937012,24.3613281 C109.937012,24.1582031 109.89681,23.9127604 109.816406,23.625 C109.736003,23.3372396 109.596354,23.0600586 109.397461,22.793457 C109.198568,22.5268555 108.938314,22.2983398 108.616699,22.1079102 C108.295085,21.9174805 107.893066,21.8222656 107.410645,21.8222656 C106.868978,21.8222656 106.369629,21.9280599 105.912598,22.1396484 C105.455566,22.351237 105.032389,22.6220703 104.643066,22.9521484 C104.253743,23.2822266 103.889811,23.6525065 103.55127,24.0629883 C103.212728,24.4734701 102.895345,24.8776042 102.599121,25.2753906 L102.599121,25.2753906 L102.599121,17.3408203 C102.599121,17.1546224 102.58431,16.940918 102.554688,16.699707 C102.525065,16.4584961 102.438314,16.2299805 102.294434,16.0141602 C102.150553,15.7983398 101.92627,15.6163737 101.621582,15.4682617 C101.316895,15.3201497 100.889486,15.2460938 100.339355,15.2460938 C99.9838867,15.2460938 99.6453451,15.2841797 99.3237305,15.3603516 C99.0021159,15.4365234 98.6995443,15.5338542 98.4160156,15.6523438 C98.132487,15.7708333 97.8722331,15.9083659 97.6352539,16.0649414 C97.3982747,16.2215169 97.1824544,16.3802083 96.987793,16.5410156 L96.987793,16.5410156 L97.2416992,16.8457031 C97.3601888,16.7526042 97.4723307,16.6827799 97.578125,16.6362305 C97.6839193,16.589681 97.8087565,16.5664062 97.9526367,16.5664062 C98.2234701,16.5664062 98.4160156,16.6573893 98.5302734,16.8393555 C98.6445312,17.0213216 98.7016602,17.235026 98.7016602,17.4804688 L98.7016602,17.4804688 L98.7016602,33.8574219 C98.7016602,33.9505208 98.7164714,34.0732422 98.7460938,34.2255859 C98.7757161,34.3779297 98.851888,34.5260417 98.9746094,34.6699219 C99.0973307,34.8138021 99.2856445,34.9386393 99.5395508,35.0444336 C99.793457,35.1502279 100.144694,35.203125 100.593262,35.203125 C101.041829,35.203125 101.399414,35.1544596 101.666016,35.0571289 C101.932617,34.9597982 102.135742,34.8434245 102.275391,34.7080078 C102.415039,34.5725911 102.503906,34.4287109 102.541992,34.2763672 C102.580078,34.1240234 102.599121,33.9928385 102.599121,33.8828125 L102.599121,33.8828125 L102.599121,27.3320312 C102.751465,26.9596354 102.946126,26.5470378 103.183105,26.0942383 C103.420085,25.6414388 103.68457,25.2182617 103.976562,24.824707 C104.268555,24.4311523 104.575358,24.1010742 104.896973,23.8344727 C105.218587,23.5678711 105.53597,23.4345703 105.849121,23.4345703 C106.009928,23.4345703 106.134766,23.4641927 106.223633,23.5234375 C106.3125,23.5826823 106.380208,23.6503906 106.426758,23.7265625 C106.473307,23.8027344 106.500814,23.8810221 106.509277,23.9614258 C106.517741,24.0418294 106.521973,24.0989583 106.521973,24.1328125 C106.521973,24.3613281 106.49235,24.6363932 106.433105,24.9580078 C106.373861,25.2796224 106.225749,25.6477865 105.98877,26.0625 C105.75179,26.4772135 105.400553,26.9405924 104.935059,27.4526367 C104.469564,27.964681 103.830566,28.5211589 103.018066,29.1220703 C103.618978,30.5608724 104.19873,31.8177083 104.757324,32.8925781 C105.315918,33.9674479 105.859701,34.8942057 106.388672,35.6728516 C106.917643,36.4514974 107.433919,37.0947266 107.9375,37.6025391 C108.441081,38.1103516 108.938314,38.5166016 109.429199,38.8212891 C109.920085,39.1259766 110.408854,39.3375651 110.895508,39.4560547 C111.382161,39.5745443 111.875163,39.6337891 112.374512,39.6337891 Z M114.393066,35.203125 C114.841634,35.203125 115.199219,35.1544596 115.46582,35.0571289 C115.732422,34.9597982 115.935547,34.8434245 116.075195,34.7080078 C116.214844,34.5725911 116.303711,34.4287109 116.341797,34.2763672 C116.379883,34.1240234 116.398926,33.9928385 116.398926,33.8828125 L116.398926,33.8828125 L116.398926,17.3408203 C116.398926,17.1546224 116.384115,16.940918 116.354492,16.699707 C116.32487,16.4584961 116.238118,16.2299805 116.094238,16.0141602 C115.950358,15.7983398 115.726074,15.6163737 115.421387,15.4682617 C115.116699,15.3201497 114.68929,15.2460938 114.13916,15.2460938 C113.783691,15.2460938 113.44515,15.2841797 113.123535,15.3603516 C112.801921,15.4365234 112.499349,15.5338542 112.21582,15.6523438 C111.932292,15.7708333 111.672038,15.9083659 111.435059,16.0649414 C111.198079,16.2215169 110.982259,16.3802083 110.787598,16.5410156 L110.787598,16.5410156 L111.041504,16.8457031 C111.159993,16.7526042 111.272135,16.6827799 111.37793,16.6362305 C111.483724,16.589681 111.608561,16.5664062 111.752441,16.5664062 C112.023275,16.5664062 112.21582,16.6573893 112.330078,16.8393555 C112.444336,17.0213216 112.501465,17.235026 112.501465,17.4804688 L112.501465,17.4804688 L112.501465,33.8574219 C112.501465,33.9505208 112.516276,34.0732422 112.545898,34.2255859 C112.575521,34.3779297 112.651693,34.5260417 112.774414,34.6699219 C112.897135,34.8138021 113.085449,34.9386393 113.339355,35.0444336 C113.593262,35.1502279 113.944499,35.203125 114.393066,35.203125 Z M124.587402,35.1777344 C125.32373,35.1777344 125.979655,35.0867513 126.555176,34.9047852 C127.130697,34.722819 127.634277,34.4943034 128.065918,34.2192383 C128.497559,33.9441732 128.865723,33.6500651 129.17041,33.3369141 C129.475098,33.023763 129.724772,32.7360026 129.919434,32.4736328 L129.919434,32.4736328 L129.602051,32.1689453 C129.398926,32.3466797 129.195801,32.5138346 128.992676,32.6704102 C128.789551,32.8269857 128.577962,32.9645182 128.35791,33.0830078 C128.137858,33.2014974 127.900879,33.2945964 127.646973,33.3623047 C127.393066,33.430013 127.118001,33.4638672 126.821777,33.4638672 C126.3986,33.4638672 126.009277,33.3961589 125.653809,33.2607422 C125.29834,33.1253255 124.974609,32.9433594 124.682617,32.7148438 C124.390625,32.4863281 124.132487,32.2260742 123.908203,31.934082 C123.683919,31.6420898 123.495605,31.3352865 123.343262,31.0136719 C123.190918,30.6920573 123.074544,30.3725586 122.994141,30.0551758 C122.913737,29.737793 122.873535,29.4436849 122.873535,29.1728516 L122.873535,29.1728516 L127.888184,26.2148438 C128.269043,25.9778646 128.57373,25.7006836 128.802246,25.3833008 C129.030762,25.065918 129.14502,24.7083333 129.14502,24.3105469 C129.14502,23.9804688 129.068848,23.6652018 128.916504,23.3647461 C128.76416,23.0642904 128.533529,22.7998047 128.224609,22.5712891 C127.91569,22.3427734 127.528483,22.1608073 127.062988,22.0253906 C126.597493,21.889974 126.051595,21.8222656 125.425293,21.8222656 C124.951335,21.8222656 124.458333,21.8878581 123.946289,22.019043 C123.434245,22.1502279 122.93278,22.3448893 122.441895,22.6030273 C121.951009,22.8611654 121.483398,23.1848958 121.039062,23.5742188 C120.594727,23.9635417 120.205404,24.4163411 119.871094,24.9326172 C119.536784,25.4488932 119.272298,26.0286458 119.077637,26.671875 C118.882975,27.3151042 118.785645,28.0218099 118.785645,28.7919922 C118.785645,29.8583984 118.948568,30.789388 119.274414,31.5849609 C119.60026,32.3805339 120.034017,33.0449219 120.575684,33.578125 C121.11735,34.1113281 121.737305,34.5112305 122.435547,34.777832 C123.133789,35.0444336 123.851074,35.1777344 124.587402,35.1777344 Z M122.746582,28.1318359 C122.746582,27.8948568 122.750814,27.6049805 122.759277,27.262207 C122.767741,26.9194336 122.793132,26.561849 122.835449,26.1894531 C122.877767,25.8170573 122.939128,25.4467773 123.019531,25.0786133 C123.099935,24.7104492 123.209961,24.382487 123.349609,24.0947266 C123.489258,23.8069661 123.666992,23.5721029 123.882812,23.3901367 C124.098633,23.2081706 124.358887,23.1171875 124.663574,23.1171875 C124.900553,23.1171875 125.103678,23.1933594 125.272949,23.3457031 C125.44222,23.4980469 125.581868,23.6884766 125.691895,23.9169922 C125.801921,24.1455078 125.880208,24.3888346 125.926758,24.6469727 C125.973307,24.9051107 125.996582,25.139974 125.996582,25.3515625 C125.996582,25.546224 125.986003,25.7091471 125.964844,25.840332 C125.943685,25.9715169 125.911947,26.081543 125.869629,26.1704102 C125.827311,26.2592773 125.770182,26.3354492 125.698242,26.3989258 C125.626302,26.4624023 125.535319,26.5279948 125.425293,26.5957031 L125.425293,26.5957031 L122.746582,28.1318359 Z M133.740723,35.203125 C134.18929,35.203125 134.542643,35.1544596 134.800781,35.0571289 C135.058919,34.9597982 135.253581,34.8434245 135.384766,34.7080078 C135.515951,34.5725911 135.59847,34.4287109 135.632324,34.2763672 C135.666178,34.1240234 135.683105,33.9928385 135.683105,33.8828125 L135.683105,33.8828125 L135.683105,25.6435547 C135.86084,25.4912109 136.057617,25.3304036 136.273438,25.1611328 C136.489258,24.991862 136.717773,24.8352865 136.958984,24.6914062 C137.200195,24.547526 137.447754,24.4269206 137.70166,24.3295898 C137.955566,24.2322591 138.213704,24.1835938 138.476074,24.1835938 C138.831543,24.1835938 139.102376,24.2703451 139.288574,24.4438477 C139.474772,24.6173503 139.593262,24.8352865 139.644043,25.0976562 L139.644043,25.0976562 L139.999512,25.0976562 C140.134928,24.7167969 140.225911,24.3930664 140.272461,24.1264648 C140.31901,23.8598633 140.342285,23.5826823 140.342285,23.2949219 C140.342285,22.8294271 140.219564,22.4676107 139.974121,22.2094727 C139.728678,21.9513346 139.390137,21.8222656 138.958496,21.8222656 C138.755371,21.8222656 138.552246,21.8603516 138.349121,21.9365234 C138.145996,22.0126953 137.949219,22.1142578 137.758789,22.2412109 C137.568359,22.3681641 137.384277,22.5120443 137.206543,22.6728516 C137.028809,22.8336589 136.86377,22.9986979 136.711426,23.1679688 C136.347493,23.5657552 136.00472,24.0100911 135.683105,24.5009766 C135.683105,24.3740234 135.678874,24.2195638 135.67041,24.0375977 C135.661947,23.8556315 135.63444,23.6652018 135.587891,23.4663086 C135.541341,23.2674154 135.471517,23.070638 135.378418,22.8759766 C135.285319,22.6813151 135.15625,22.5056966 134.991211,22.3491211 C134.826172,22.1925456 134.614583,22.0655924 134.356445,21.9682617 C134.098307,21.870931 133.787272,21.8222656 133.42334,21.8222656 C133.067871,21.8222656 132.729329,21.8603516 132.407715,21.9365234 C132.0861,22.0126953 131.785645,22.110026 131.506348,22.2285156 C131.227051,22.3470052 130.966797,22.4845378 130.725586,22.6411133 C130.484375,22.7976888 130.266439,22.9563802 130.071777,23.1171875 L130.071777,23.1171875 L130.338379,23.4345703 C130.456868,23.3414714 130.566895,23.2695312 130.668457,23.21875 C130.77002,23.1679688 130.892741,23.1425781 131.036621,23.1425781 C131.307454,23.1425781 131.5,23.2335612 131.614258,23.4155273 C131.728516,23.5974935 131.785645,23.8111979 131.785645,24.0566406 L131.785645,24.0566406 L131.785645,33.8574219 C131.785645,33.9505208 131.802572,34.0732422 131.836426,34.2255859 C131.87028,34.3779297 131.954915,34.5260417 132.090332,34.6699219 C132.225749,34.8138021 132.422526,34.9386393 132.680664,35.0444336 C132.938802,35.1502279 133.292155,35.203125 133.740723,35.203125 Z"></path>
                </g>
            </g>
        </g>
    </Icon>
);
