/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.demos.enhancedItems;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageProducer;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.ui.VButton;

public class RolloverButton
extends VButton {
    public static final ID IMAGE_NAME_ON = ID.registerProperty((String)"IMAGE_NAME_ON");
    public static final ID IMAGE_NAME_OFF = ID.registerProperty((String)"IMAGE_NAME_OFF");
    private static final ID DEBUGMESSAGES = ID.registerProperty((String)"DEBUGMESSAGES");
    private static final ID DEBUGMESSAGES_ALL = ID.registerProperty((String)"DEBUGMESSAGES_ALL");
    private final int ON = 1;
    private final int OFF = 0;
    private final String CLASSNAME = this.getDefaultName();
    private final String JARBUTTONSDIR = "/oracle/forms/demos/images/";
    private final String JARBUTTONSEXT = ".gif";
    private String m_imageNameOn;
    private String m_imageNameOff;
    private IHandler m_handler;
    private URL m_codeBase;
    private int m_state = 0;
    private Image[] m_images = new Image[]{null, null};
    private boolean m_isRollover = false;
    private boolean m_debug = false;
    private static boolean m_debugAll = false;

    public RolloverButton() {
        this.log("Debugging on: Creating Button Instance");
        this.setLeftmost(false);
        this.setRightmost(false);
    }

    public void init(IHandler iHandler) {
        this.m_handler = iHandler;
        this.m_codeBase = iHandler.getCodeBase();
        super.init(iHandler);
    }

    public boolean setProperty(ID iD, Object object) {
        if (iD == ID.LABEL) {
            this.log("Setting Label to " + object.toString());
            String string = object.toString().trim();
            if (string.equals("")) {
                this.enableRollover();
                return true;
            }
            if (string.startsWith("[ROLLOVER]")) {
                this.enableRollover();
                string = string.substring(10);
                int n = string.indexOf(",");
                if (n > 0) {
                    this.m_imageNameOn = string.substring(0, n);
                    this.m_imageNameOff = string.substring(n + 1);
                } else {
                    this.m_imageNameOn = "/oracle/forms/demos/images/" + string + "_on" + ".gif";
                    this.m_imageNameOff = "/oracle/forms/demos/images/" + string + "_off" + ".gif";
                }
                this.log("Detected Image Names + ON='" + this.m_imageNameOn + "', OFF= '" + this.m_imageNameOff + "'");
                this.loadImage(1, this.m_imageNameOn);
                this.loadImage(0, this.m_imageNameOff);
                this.setImage(0);
                return true;
            }
            if (string.startsWith("(")) {
                this.log("Rounding left edge of " + string);
                this.setLeftmost(true);
                string = string.substring(1);
            }
            if (string.endsWith(")")) {
                this.log("Rounding right edge of " + string);
                this.setRightmost(true);
                string = string.substring(0, string.length() - 1);
            }
            return super.setProperty(iD, (Object)string);
        }
        if (iD == IMAGE_NAME_ON) {
            this.enableRollover();
            this.log("setProperty - IMAGE_NAME_ON value=" + object.toString());
            this.m_imageNameOn = (String)object;
            this.loadImage(1, this.m_imageNameOn);
            this.setImage(1, this.m_state);
            return true;
        }
        if (iD == IMAGE_NAME_OFF) {
            this.enableRollover();
            this.log("setProperty - IMAGE_NAME_OFF value=" + object.toString());
            this.m_imageNameOff = (String)object;
            this.loadImage(0, this.m_imageNameOff);
            this.setImage(0, this.m_state);
            return true;
        }
        if (iD == DEBUGMESSAGES) {
            this.m_debug = object.toString().equalsIgnoreCase("true");
            this.log("Debugging " + this.m_debug);
            return true;
        }
        if (iD == DEBUGMESSAGES_ALL) {
            m_debugAll = object.toString().equalsIgnoreCase("true");
            this.log("Debugging " + m_debugAll);
            return true;
        }
        return super.setProperty(iD, object);
    }

    public Object getProperty(ID iD) {
        if (iD == IMAGE_NAME_OFF) {
            return this.m_imageNameOff;
        }
        if (iD == IMAGE_NAME_ON) {
            return this.m_imageNameOn;
        }
        return super.getProperty(iD);
    }

    private void loadImage(int n, String string) {
        URL uRL = null;
        boolean bl = false;
        this.log("Searching JAR for " + string);
        uRL = ((Object)((Object)this)).getClass().getResource(string);
        if (uRL != null) {
            this.log("URL: " + uRL.toString());
            try {
                this.m_images[n] = Toolkit.getDefaultToolkit().getImage(uRL);
                bl = true;
                this.log("Image found: " + uRL.toString());
            }
            catch (Exception exception) {
                this.log("Error loading image from JAR: " + exception.toString());
            }
        } else {
            this.log("Unable to find " + string + " in JAR");
        }
        if (!bl) {
            this.log("Searching docbase for " + string);
            try {
                uRL = string.toLowerCase().startsWith("http://") || string.toLowerCase().startsWith("https://") ? new URL(string) : new URL(this.m_codeBase.getProtocol() + "://" + this.m_codeBase.getHost() + ":" + this.m_codeBase.getPort() + string);
                this.log("Constructed URL: " + uRL.toString());
                try {
                    this.m_images[n] = ((Component)((Object)this)).createImage((ImageProducer)uRL.getContent());
                    bl = true;
                    this.log("Image found: " + uRL.toString());
                }
                catch (Exception exception) {
                    this.log("Error reading image - " + exception.toString());
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.log("Error creating URL - " + malformedURLException.toString());
            }
        }
        if (!bl) {
            this.log("Searching codebase for " + string);
            try {
                uRL = new URL(this.m_codeBase, string);
                this.log("Constructed URL: " + uRL.toString());
                try {
                    this.m_images[n] = ((Component)((Object)this)).createImage((ImageProducer)uRL.getContent());
                    bl = true;
                    this.log("Image found: " + uRL.toString());
                }
                catch (Exception exception) {
                    this.log("Error reading image - " + exception.toString());
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.log("Error creating URL - " + malformedURLException.toString());
            }
        }
        if (!bl) {
            this.log("Error image " + string + " could not be located");
        }
    }

    private void setImage(int n, int n2) {
        if (n == n2) {
            this.setImage(n);
        }
    }

    private void setImage(int n) {
        this.m_state = n;
        if (n == 1) {
            this.log("setImage ON");
        } else {
            this.log("setImage OFF");
        }
        this.setImage(this.m_images[n]);
    }

    private void enableRollover() {
        if (!this.m_isRollover) {
            this.log("Enabling Rollover");
            ((Component)((Object)this)).addMouseListener(new RolloverButtonMouseAdapter());
            this.setLeftmost(true);
            this.setRightmost(true);
            this.m_isRollover = true;
        }
    }

    public void log(String string) {
        if (this.m_debug || m_debugAll) {
            System.out.println(this.CLASSNAME + ": " + string);
        }
    }

    class RolloverButtonMouseAdapter
    extends MouseAdapter {
        RolloverButtonMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            RolloverButton.this.setImage(1);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            RolloverButton.this.setImage(0);
        }
    }
}

