/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.session;

import java.applet.AppletContext;
import java.net.URL;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.session.DispatcherWatch;

public class SessionFunctions
extends VBeanCommon {
    private static final ID WUS_MONITOR_DISPATCHER = ID.registerProperty((String)"WUS_MONITOR_DISPATCHER");
    static DispatcherWatch s_dispatcherWatch;
    static int s_instanceCount;
    static int s_monitorInterval;

    public void setBeanInfo() {
        this.setBeanName("WebUtil Session Monitoring Facilities");
        this.setBeanShortName("WUS");
    }

    public void init(IHandler handler) {
        super.init(handler);
        if (s_monitorInterval == -1) {
            s_monitorInterval = 0;
            String paramDispInt = handler.getApplet().getParameter("WebUtilDispatchMonitorInterval");
            try {
                if (paramDispInt != null && !paramDispInt.equalsIgnoreCase("")) {
                    s_monitorInterval = Integer.parseInt(paramDispInt);
                    this.log((byte)1, "SessionFunctions.init()", "Dispatcher Monitoring interval set to " + s_monitorInterval);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ++s_instanceCount;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUS_MONITOR_DISPATCHER) {
            this.setPropertyLogBefore(propName, value);
            this.monitorDispatcher(this.defaultNullPropertyValue(value, null));
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    public void destroy() {
        if (!this.m_destroyed) {
            --s_instanceCount;
        }
        super.destroy();
    }

    public static boolean isRunning() {
        return s_instanceCount > 0;
    }

    private void monitorDispatcher(String redirectURL) {
        block6: {
            try {
                if (s_dispatcherWatch != null) {
                    s_dispatcherWatch.stopDispatcherWatch();
                    s_dispatcherWatch = null;
                    this.log((byte)1, "SessionFunctions.monitorDispatcher()", "Existing dispatcher monitor removed");
                }
                if (redirectURL == null) break block6;
                Runform dispatcher = ((ComponentItem)this.getHandler()).getDispatcher();
                AppletContext appletCTX = this.getHandler().getApplet().getAppletContext();
                URL url = null;
                try {
                    url = new URL(redirectURL);
                }
                catch (Exception ex) {
                    this.error(500, "SessionFunctions.monitorDispatcher()", this.getTranslatedMessage("ERROR500", ex.toString(), null, null));
                }
                if (url != null) {
                    s_dispatcherWatch = new DispatcherWatch(dispatcher, appletCTX, url, s_monitorInterval);
                    s_dispatcherWatch.start();
                    this.log((byte)1, "SessionFunctions.monitorDispatcher()", "Dispatcher monitor started");
                }
            }
            catch (Exception lastResort) {
                this.error(17, "SessionFunctions.monitorDispatcher()", this.getTranslatedMessage("ERROR017", lastResort.toString(), null, null));
            }
        }
    }

    static {
        s_monitorInterval = -1;
    }
}

