/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.session;

import java.applet.AppletContext;
import java.net.URL;
import oracle.forms.engine.Runform;
import oracle.forms.webutil.session.SessionFunctions;

public class DispatcherWatch
extends Thread {
    Runform m_dispatcher = null;
    AppletContext m_appletCTX = null;
    URL m_targetURL = null;
    int m_interval = 5000;
    boolean m_isAlive = false;

    public DispatcherWatch(Runform dispatcher, AppletContext appletCTX, URL target, int interval) {
        this.m_dispatcher = dispatcher;
        this.m_appletCTX = appletCTX;
        this.m_targetURL = target;
        if (interval > 0) {
            this.m_interval = interval * 1000;
        }
    }

    public void run() {
        this.m_isAlive = true;
        this.setName("WebUtil - Dispatcher Monitor");
        while (this.m_isAlive) {
            try {
                if (!this.m_dispatcher.isRunning() || !SessionFunctions.isRunning()) {
                    this.m_isAlive = false;
                    this.m_appletCTX.showDocument(this.m_targetURL);
                    continue;
                }
                try {
                    DispatcherWatch.sleep(this.m_interval);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception crashed) {
                this.m_isAlive = false;
                this.m_appletCTX.showDocument(this.m_targetURL);
            }
        }
    }

    public void stopDispatcherWatch() {
        this.m_isAlive = false;
    }
}

