/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.ole;

import com.jacob.activeX.ActiveXComponent;
import com.jacob.com.ComFailException;
import com.jacob.com.Dispatch;
import com.jacob.com.JacobObject;
import com.jacob.com.Variant;
import java.util.Vector;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;

public class OleFunctions
extends VBeanCommon {
    private static final ID WU0_OLE2_CREATE_OBJ = ID.registerProperty((String)"WUO_OLE2_CREATE_OBJ");
    private static final ID WU0_OLE2_CREATE_ARGLIST = ID.registerProperty((String)"WUO_OLE2_CREATE_ARGLIST");
    private static final ID WU0_OLE2_HANDLE = ID.registerProperty((String)"WUO_OLE2_HANDLE");
    private static final ID WU0_OLE2_OBJNAME = ID.registerProperty((String)"WUO_OLE2_OBJNAME");
    private static final ID WU0_OLE2_PROPNAME = ID.registerProperty((String)"WUO_OLE2_PROPNAME");
    private static final ID WU0_OLE2_GET_OBJ_PROPERTY = ID.registerProperty((String)"WUO_OLE2_GET_OBJ_PROPERTY");
    private static final ID WU0_OLE2_GET_OBJ_PROPERTY_ARGS = ID.registerProperty((String)"WUO_OLE2_GET_OBJ_PROPERTY_ARGS");
    private static final ID WU0_OLE2_GET_PROPERTY = ID.registerProperty((String)"WUO_OLE2_GET_PROPERTY");
    private static final ID WU0_OLE2_GET_PROPERTY_ARGS = ID.registerProperty((String)"WUO_OLE2_GET_PROPERTY_ARGS");
    private static final ID WU0_OLE2_SET_PROPERTY = ID.registerProperty((String)"WUO_OLE2_SET_PROPERTY");
    private static final ID WU0_OLE2_SET_PROPERTY_ARGS = ID.registerProperty((String)"WUO_OLE2_SET_PROPERTY_ARGS");
    private static final ID WU0_OLE2_RELEASE_OBJ = ID.registerProperty((String)"WUO_OLE2_RELEASE_OBJ");
    private static final ID WU0_OLE2_DESTROY_ARGLIST = ID.registerProperty((String)"WUO_OLE2_DESTROY_ARGLIST");
    private static final ID WU0_OLE2_ADD_ARG = ID.registerProperty((String)"WUO_OLE2_ADD_ARG");
    private static final ID WU0_OLE2_INVOKE_OBJ = ID.registerProperty((String)"WUO_OLE2_INVOKE_OBJ");
    private static final ID WU0_OLE2_INVOKE_STR = ID.registerProperty((String)"WUO_OLE2_INVOKE_STR");
    private static final ID WU0_OLE2_INVOKE = ID.registerProperty((String)"WUO_OLE2_INVOKE");
    private static final ID WU0_OLE2_ERROR = ID.registerProperty((String)"WUO_OLE2_ERROR");
    private String m_objName = null;
    private int m_oleID = -1;
    private int m_argID = -1;
    private String m_propName = null;
    private String m_oleerrstr = null;
    private String m_oleerrsource = null;
    private String m_olehelpfile = null;
    private int m_oleerrnum = -1;
    private String m_oleerrdesc = null;
    private int m_olehelpID = -1;

    public void setBeanInfo() {
        this.setBeanName("WebUtil Client Side Ole Functions");
        this.setBeanShortName("WUO");
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WU0_OLE2_CREATE_OBJ) {
            this.getPropertyLogBefore(propName);
            result = this.create_obj(this.m_objName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_CREATE_ARGLIST) {
            this.getPropertyLogBefore(propName);
            result = this.create_arg_list();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_GET_OBJ_PROPERTY) {
            this.getPropertyLogBefore(propName);
            result = this.get_obj_property(this.m_propName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_GET_OBJ_PROPERTY_ARGS) {
            this.getPropertyLogBefore(propName);
            result = this.get_obj_property_args(this.m_propName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_GET_PROPERTY) {
            this.getPropertyLogBefore(propName);
            result = this.get_str_property(this.m_propName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_GET_PROPERTY_ARGS) {
            this.getPropertyLogBefore(propName);
            result = this.get_str_property_args(this.m_propName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_INVOKE_OBJ) {
            this.getPropertyLogBefore(propName);
            result = this.invoke_ret_obj(this.m_propName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_INVOKE_STR) {
            this.getPropertyLogBefore(propName);
            result = this.invoke_ret_str(this.m_propName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WU0_OLE2_ERROR) {
            this.getPropertyLogBefore(propName);
            result = "" + this.m_oleerrnum + "," + this.m_oleerrdesc + "," + this.m_oleerrsource + "," + this.m_olehelpfile + "," + this.m_olehelpID;
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = false;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WU0_OLE2_OBJNAME) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            this.m_objName = this.defaultNullPropertyValue(value, null);
            result = true;
        } else if (id == WU0_OLE2_HANDLE) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.setHandle(this.defaultNullPropertyValue(value, null));
        } else if (id == WU0_OLE2_PROPNAME) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            this.m_propName = this.defaultNullPropertyValue(value, null);
            result = true;
        } else if (id == WU0_OLE2_SET_PROPERTY) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.set_obj_property(this.m_propName, this.defaultNullPropertyValue(value, null));
        } else if (id == WU0_OLE2_SET_PROPERTY_ARGS) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.set_obj_property_args(this.m_propName, this.defaultNullPropertyValue(value, null));
        } else if (id == WU0_OLE2_ADD_ARG) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.add_arg(this.defaultNullPropertyValue(value, null));
        } else if (id == WU0_OLE2_INVOKE) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.invoke_obj(this.m_propName);
        } else if (id == WU0_OLE2_RELEASE_OBJ) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.release_obj(this.defaultNullPropertyValue(value, null));
        } else if (id == WU0_OLE2_DESTROY_ARGLIST) {
            this.setPropertyLogBefore(propName, this.defaultNullPropertyValue(value, null));
            result = this.destroy_arg_list(this.defaultNullPropertyValue(value, null));
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    private Object create_obj(String appName) {
        String result = null;
        try {
            result = "" + this.storeInObjectCache(new ActiveXComponent(appName));
        }
        catch (ComFailException e) {
            this.setExceptionValues(e);
            this.error(700, "OleFunctions.create_obj()", this.getTranslatedMessage("ERROR700", this.m_objName, e.toString(), null));
            result = "";
        }
        return result;
    }

    private Object create_arg_list() {
        String result = null;
        try {
            result = "" + this.storeInObjectCache(new Vector());
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.create_arg_list()", lastResort);
            result = "";
        }
        return result;
    }

    private boolean release_obj(String handle) {
        boolean result = false;
        try {
            if (this.setHandle(handle)) {
                Object oleh = this.getFromObjectCache(this.m_oleID);
                if (oleh instanceof JacobObject) {
                    try {
                        ((JacobObject)oleh).release();
                        oleh = null;
                        this.eraseFromObjectCache(this.m_oleID);
                        this.m_oleID = -1;
                        result = true;
                    }
                    catch (Exception e) {
                        this.error(701, "OleFunctions.release_obj()", this.getTranslatedMessage("ERROR701", e.toString(), null, null));
                        result = false;
                    }
                } else {
                    this.error(12, "OleFunctions.release_obj()", this.getTranslatedMessage("ERROR012", "JacobObject", null, null));
                    result = false;
                }
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.release_obj()", lastResort);
            result = false;
        }
        return result;
    }

    private boolean destroy_arg_list(String handle) {
        boolean result = false;
        try {
            if (this.setHandle(handle)) {
                Object oleh = this.getFromObjectCache(this.m_argID);
                if (oleh instanceof Vector) {
                    try {
                        this.eraseFromObjectCache(this.m_argID);
                        this.m_argID = -1;
                        result = true;
                    }
                    catch (ComFailException e) {
                        this.setExceptionValues(e);
                        this.error(702, "OleFunctions.destroy_arg_list()", this.getTranslatedMessage("ERROR702", e.toString(), null, null));
                        result = false;
                    }
                } else {
                    this.error(12, "OleFunctions.destroy_arg_list()", this.getTranslatedMessage("ERROR012", "Vector", null, null));
                    result = false;
                }
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.destroy_arg_list()", lastResort);
            result = false;
        }
        return result;
    }

    private boolean add_arg(String argName) {
        boolean result;
        block16: {
            result = false;
            int vector_size = -1;
            String argtype = null;
            if (argName == null) {
                argtype = "S";
            } else {
                argtype = argName.substring(0, 1);
                argName = argName.substring(1);
            }
            try {
                Object argh = this.getFromObjectCache(this.m_argID);
                if (argh instanceof Vector) {
                    Vector argvect = (Vector)argh;
                    vector_size = argvect.isEmpty() ? 0 : argvect.size();
                    try {
                        block15: {
                            if (argtype.equals("N")) {
                                argvect.add(vector_size, new Double(argName));
                            } else if (argtype.equals("O")) {
                                try {
                                    int handle_id = Integer.parseInt(argName);
                                    if (handle_id < 0) {
                                        throw new NumberFormatException();
                                    }
                                    Object oleh = this.getFromObjectCache(handle_id);
                                    if (oleh instanceof JacobObject) {
                                        argvect.add(vector_size, oleh);
                                        break block15;
                                    }
                                    this.error(12, "OleFunctions.add_arg()", this.getTranslatedMessage("ERROR012", "JacobObject", null, null));
                                    result = false;
                                }
                                catch (NumberFormatException nfe) {
                                    this.error(703, "OleFunctions.add_arg()", this.getTranslatedMessage("ERROR703", nfe.toString(), null, null));
                                }
                            } else {
                                argvect.add(vector_size, argName);
                            }
                        }
                        result = true;
                    }
                    catch (Exception e) {
                        this.error(704, "OleFunctions.add_arg()", this.getTranslatedMessage("ERROR704", e.toString(), null, null));
                        result = false;
                    }
                    break block16;
                }
                this.error(12, "OleFunctions.add_arg()", this.getTranslatedMessage("ERROR012", "Vector", null, null));
                result = false;
            }
            catch (Exception lastResort) {
                this.unexpectedError("OleFunctions.add_arg()", lastResort);
                result = false;
            }
        }
        return result;
    }

    private Object invoke_ret_obj(String methodName) {
        String result = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            Object argh = this.getFromObjectCache(this.m_argID);
            if (oleh instanceof JacobObject && argh instanceof Vector) {
                try {
                    Vector argvect = (Vector)argh;
                    Object[] vectarr = argvect.toArray();
                    Variant toStoreVar = Dispatch.callN((Object)oleh, (String)methodName, (Object[])vectarr);
                    result = "" + this.storeInObjectCache(toStoreVar.toDispatch());
                    toStoreVar.release();
                    toStoreVar = null;
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(705, "OleFunctions.invoke_ret_obj()", this.getTranslatedMessage("ERROR705", methodName, e.toString(), null));
                    result = "";
                }
            } else {
                this.error(12, "OleFunctions.invoke_ret_obj()", this.getTranslatedMessage("ERROR012", "JacobObject", null, null));
                result = "";
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.invoke_ret_obj()", lastResort);
            result = "";
        }
        return result;
    }

    private String invoke_ret_str(String methodName) {
        String result = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            Object argh = this.getFromObjectCache(this.m_argID);
            if (oleh instanceof JacobObject && argh instanceof Vector) {
                try {
                    Vector argvect = (Vector)argh;
                    Object[] vectarr = argvect.toArray();
                    result = "" + Dispatch.callN((Object)oleh, (String)methodName, (Object[])vectarr);
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(706, "OleFunctions.invoke_ret_str()", this.getTranslatedMessage("ERROR706", methodName, e.toString(), null));
                    result = "";
                }
            } else {
                this.error(12, "OleFunctions.invoke_ret_str()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = "";
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.invoke_ret_str()", lastResort);
            result = "";
        }
        return result;
    }

    private boolean invoke_obj(String methodName) {
        boolean result = false;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            Object argh = this.getFromObjectCache(this.m_argID);
            if (oleh instanceof JacobObject && argh instanceof Vector) {
                try {
                    Vector argvect = (Vector)argh;
                    Object[] vectarr = argvect.toArray();
                    Dispatch.callSubN((Object)oleh, (String)methodName, (Object[])vectarr);
                    result = true;
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(707, "OleFunctions.invoke_obj()", this.getTranslatedMessage("ERROR707", methodName, e.toString(), null));
                    result = false;
                }
            } else {
                this.error(12, "OleFunctions.invoke_obj()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = false;
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.invoke_obj()", lastResort);
        }
        return result;
    }

    private Object get_obj_property(String propertyName) {
        String result = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            if (oleh instanceof JacobObject) {
                try {
                    Variant toStoreVar = Dispatch.get((Object)oleh, (String)propertyName);
                    result = "" + this.storeInObjectCache(toStoreVar.toDispatch());
                    toStoreVar.release();
                    toStoreVar = null;
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(708, "OleFunctions.get_obj_property()", this.getTranslatedMessage("ERROR708", propertyName, e.toString(), null));
                    result = "";
                }
            } else {
                this.error(12, "OleFunctions.get_obj_property()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = "";
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.get_obj_property()", lastResort);
            result = "";
        }
        return result;
    }

    private Object get_obj_property_args(String propertyName) {
        String result = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            Object argh = this.getFromObjectCache(this.m_argID);
            if (oleh instanceof JacobObject && argh instanceof Vector) {
                try {
                    Vector argvect = (Vector)argh;
                    Object[] vectarr = argvect.toArray();
                    Variant toStoreVar = Dispatch.invoke((Object)oleh, (String)propertyName, (int)2, (Object[])vectarr, (int[])new int[vectarr.length]);
                    result = "" + this.storeInObjectCache(toStoreVar.toDispatch());
                    toStoreVar.release();
                    toStoreVar = null;
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(709, "OleFunctions.get_obj_property_args()", this.getTranslatedMessage("ERROR709", propertyName, e.toString(), null));
                    result = "";
                }
            } else {
                this.error(12, "OleFunctions.get_obj_property_args()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = "";
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.get_obj_property_args()", lastResort);
            result = "";
        }
        return result;
    }

    private String get_str_property(String propertyName) {
        String result = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            if (oleh instanceof JacobObject) {
                try {
                    result = "" + Dispatch.get((Object)oleh, (String)propertyName);
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(710, "OleFunctions.get_str_property()", this.getTranslatedMessage("ERROR710", propertyName, e.toString(), null));
                    result = "";
                }
            } else {
                this.error(12, "OleFunctions.get_str_property()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = "";
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.get_str_property()", lastResort);
            result = "";
        }
        return result;
    }

    private Object get_str_property_args(String propertyName) {
        String result = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            Object argh = this.getFromObjectCache(this.m_argID);
            if (oleh instanceof JacobObject && argh instanceof Vector) {
                try {
                    Vector argvect = (Vector)argh;
                    Object[] vectarr = argvect.toArray();
                    result = "" + Dispatch.invoke((Object)oleh, (String)propertyName, (int)2, (Object[])vectarr, (int[])new int[vectarr.length]);
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(711, "OleFunctions.get_str_property_args()", this.getTranslatedMessage("ERROR711", propertyName, e.toString(), null));
                    result = "";
                }
            } else {
                this.error(12, "OleFunctions.get_str_property_args()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = "";
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.get_str_property_args()", lastResort);
            result = "";
        }
        return result;
    }

    private boolean set_obj_property(String propertyName, String propertyValue) {
        boolean result = false;
        String valtype = null;
        if (propertyValue == null) {
            valtype = "S";
        } else {
            valtype = propertyValue.substring(0, 1);
            propertyValue = propertyValue.substring(1);
        }
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            if (oleh instanceof JacobObject) {
                try {
                    if (valtype.equals("N")) {
                        Dispatch.put((Object)oleh, (String)propertyName, (Object)new Double(propertyValue));
                    } else {
                        Dispatch.put((Object)oleh, (String)propertyName, (Object)propertyValue);
                    }
                    result = true;
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(712, "OleFunctions.set_obj_property()", this.getTranslatedMessage("ERROR712", propertyName, e.toString(), null));
                    result = false;
                }
            } else {
                this.error(12, "OleFunctions.set_obj_property()", this.getTranslatedMessage("ERROR012", "JacobObject", null, null));
                result = false;
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.set_obj_property()", lastResort);
            result = false;
        }
        return result;
    }

    private boolean set_obj_property_args(String propertyName, String propertyValue) {
        boolean result = false;
        String valtype = null;
        try {
            Object oleh = this.getFromObjectCache(this.m_oleID);
            Object argh = this.getFromObjectCache(this.m_argID);
            if (oleh instanceof JacobObject && argh instanceof Vector) {
                try {
                    Vector argvect = (Vector)argh;
                    if (propertyValue == null) {
                        valtype = "S";
                    } else {
                        valtype = propertyValue.substring(0, 1);
                        propertyValue = propertyValue.substring(1);
                    }
                    if (valtype.equals("N")) {
                        argvect.insertElementAt(new Double(propertyValue), 0);
                    } else {
                        argvect.insertElementAt(propertyValue, 0);
                    }
                    Object[] vectarr = argvect.toArray();
                    Dispatch.invokeSub((Object)oleh, (String)propertyName, (int)4, (Object[])vectarr, (int[])new int[vectarr.length]);
                    result = true;
                }
                catch (ComFailException e) {
                    this.setExceptionValues(e);
                    this.error(713, "OleFunctions.set_obj_property_args()", this.getTranslatedMessage("ERROR713", propertyName, e.toString(), null));
                    result = false;
                }
            } else {
                this.error(12, "OleFunctions.set_obj_property_args()", this.getTranslatedMessage("ERROR012", "JacobObject,Vector", null, null));
                result = false;
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.set_obj_property_args()", lastResort);
            result = false;
        }
        return result;
    }

    private boolean setExceptionValues(ComFailException ce) {
        boolean result = false;
        try {
            this.m_oleerrnum = ce.getHResult();
            this.m_oleerrstr = ce.getMessage();
            this.m_oleerrsource = this.m_oleerrstr.substring(this.m_oleerrstr.indexOf("Source:"), this.m_oleerrstr.indexOf("Description:"));
            this.m_oleerrdesc = this.m_oleerrstr.substring(this.m_oleerrstr.indexOf("Description:"));
            this.m_olehelpfile = ce.getHelpFile();
            this.m_olehelpID = ce.getHelpContext();
            result = true;
        }
        catch (Exception e) {
            this.error(714, "OleFunctions.setExceptionValues()", this.getTranslatedMessage("ERROR714", e.toString(), null, null));
            result = false;
        }
        return result;
    }

    private boolean setHandle(String handle) {
        boolean result = false;
        int handle_id = -1;
        try {
            handle_id = Integer.parseInt(handle);
            if (handle_id < 0) {
                throw new NumberFormatException();
            }
            Object oleh = this.getFromObjectCache(handle_id);
            if (oleh instanceof JacobObject) {
                this.m_oleID = handle_id;
            } else if (oleh instanceof Vector) {
                this.m_argID = handle_id;
            } else {
                this.m_oleID = handle_id;
                this.m_argID = handle_id;
            }
            result = true;
        }
        catch (NumberFormatException nfe) {
            this.error(715, "OleFunctions.setHandle()", this.getTranslatedMessage("ERROR715", handle, null, null));
            result = false;
        }
        catch (NullPointerException npe) {
            this.error(716, "OleFunctions.setHandle()", this.getTranslatedMessage("ERROR716", null, null, null));
            result = false;
        }
        catch (Exception lastResort) {
            this.unexpectedError("OleFunctions.setHandle()", lastResort);
            result = false;
        }
        return result;
    }
}

