/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.host;

import java.io.IOException;
import java.util.StringTokenizer;
import oracle.forms.webutil.common.LoggingEngine;
import oracle.forms.webutil.host.Host;
import oracle.forms.webutil.host.OutputSink;

public class HostCommand
extends Thread {
    Host m_pjc = null;
    LoggingEngine m_logger = null;
    OutputSink m_stdOut = null;
    OutputSink m_stdErr = null;
    Process m_proc = null;
    String m_cmd = null;
    int m_rc = -1;
    boolean m_callback = false;
    int m_processHandle = -1;

    public HostCommand(String cmd, boolean callback, Host pjc) {
        this.m_cmd = cmd;
        this.m_callback = callback;
        this.m_pjc = pjc;
        this.m_logger = pjc.getLogger();
    }

    public void execute() {
        try {
            this.m_logger.log((byte)1, "HostCommand.execute()", this.m_cmd);
            Runtime rt = Runtime.getRuntime();
            this.m_proc = rt.exec(this.m_cmd);
            this.m_stdOut = new OutputSink(this.m_proc.getInputStream(), this.m_logger);
            this.m_stdErr = new OutputSink(this.m_proc.getErrorStream(), this.m_logger);
            this.m_stdOut.start();
            this.m_stdErr.start();
            this.m_rc = this.m_proc.waitFor();
            this.m_logger.log((byte)1, "HostCommand.execute()", "Return Code = " + this.m_rc);
        }
        catch (IOException ioe) {
            this.m_logger.log((byte)1, "HostCommand.execute()", "IOException: " + ioe.getMessage());
            StringTokenizer st = new StringTokenizer(ioe.getMessage(), "=");
            st.nextToken();
            if (st.hasMoreTokens()) {
                try {
                    this.m_rc = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException nfe) {
                    this.m_rc = -1;
                }
            }
        }
        catch (Exception ex) {
            this.m_pjc.unexpectedError("HostCommand.execute()", ex);
        }
    }

    public void run() {
        this.execute();
        if (this.m_callback) {
            this.m_pjc.dispatchMessage(Host.WUH_CALLBACK_EVENT, "" + this.m_processHandle);
        }
    }

    public int getRC() {
        return this.m_rc;
    }

    public OutputSink getStdOut() {
        return this.m_stdOut;
    }

    public OutputSink getStdErr() {
        return this.m_stdErr;
    }

    public Process getProcess() {
        return this.m_proc;
    }

    public void setProcessHandle(int processHandle) {
        this.m_processHandle = processHandle;
    }
}

