/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.host;

import java.util.Iterator;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.host.HostCommand;
import oracle.forms.webutil.host.OutputSink;

public class Host
extends VBeanCommon {
    private static final ID WUH_EXECUTE = ID.registerProperty((String)"WUH_EXECUTE");
    private static final ID WUH_PROC_ID = ID.registerProperty((String)"WUH_PROC_ID");
    private static final ID WUH_EXECUTION_MODE = ID.registerProperty((String)"WUH_EXECUTION_MODE");
    private static final int BLOCKING_MODE = 0;
    private static final int NON_BLOCKING_MODE = 1;
    private static final int CALLBACK_MODE = 2;
    protected static final ID WUH_CALLBACK_EVENT = ID.registerProperty((String)"WUH_CALLBACK_EVENT");
    private static final ID WUH_STDOUT = ID.registerProperty((String)"WUH_STDOUT");
    private static final ID WUH_STDERR = ID.registerProperty((String)"WUH_STDERR");
    private static final ID WUH_RC = ID.registerProperty((String)"WUH_RC");
    private static final ID WUH_TERMINATE_PROC = ID.registerProperty((String)"WUH_TERMINATE_PROC");
    private static final ID WUH_CLEAR_PROC = ID.registerProperty((String)"WUH_CLEAR_PROC");
    private int m_mode;
    private int m_process;
    private String m_cmd = null;
    private Iterator m_outputIterator = null;

    public void setBeanInfo() {
        this.setBeanName("WebUtil Client Side Host Commands");
        this.setBeanShortName("WUH");
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUH_EXECUTE) {
            this.getPropertyLogBefore(propName);
            result = this.executeHost(this.m_cmd, this.m_mode);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUH_RC) {
            this.getPropertyLogBefore(propName);
            result = this.getProcessRC(this.m_process);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUH_STDOUT) {
            this.getPropertyLogBefore(propName);
            result = this.getProcessOutput(this.m_process, false);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUH_STDERR) {
            this.getPropertyLogBefore(propName);
            result = this.getProcessOutput(this.m_process, true);
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUH_PROC_ID) {
            this.setPropertyLogBefore(propName, value);
            this.setProcessHandle(this.defaultNullPropertyValue(value, null));
        } else if (id == WUH_EXECUTION_MODE) {
            this.setPropertyLogBefore(propName, value);
            this.setExecMode(this.defaultNullPropertyValue(value, null));
        } else if (id == WUH_EXECUTE) {
            this.setPropertyLogBefore(propName, value);
            this.setExecCmd(this.defaultNullPropertyValue(value, null));
        } else if (id == WUH_CLEAR_PROC) {
            this.setPropertyLogBefore(propName, value);
            this.cleanupProcess(this.defaultNullPropertyValue(value, null));
        } else if (id == WUH_TERMINATE_PROC) {
            this.setPropertyLogBefore(propName, value);
            this.terminateProcess(this.defaultNullPropertyValue(value, null));
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    private void setProcessHandle(String processId) {
        try {
            this.m_process = Integer.parseInt(processId);
            if (this.m_process < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.error(401, "Host.setProcessHandle()", this.getTranslatedMessage("ERROR401", processId, null, null));
        }
        catch (NullPointerException npe) {
            this.error(402, "Host.setProcessHandle()", this.getTranslatedMessage("ERROR402", null, null, null));
        }
        catch (Exception lastResort) {
            this.unexpectedError("Host.setProcessHandle()", lastResort);
        }
    }

    private void setExecMode(String mode) {
        try {
            this.m_mode = Integer.parseInt(mode);
            if (this.m_mode < 0 && this.m_mode > 2) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.error(403, "Host.setExecMode()", this.getTranslatedMessage("ERROR403", mode, null, null));
        }
        catch (NullPointerException npe) {
            this.error(404, "Host.setExecMode()", this.getTranslatedMessage("ERROR404", null, null, null));
        }
        catch (Exception lastResort) {
            this.unexpectedError("Host.setProcessHandle()", lastResort);
        }
    }

    private void setExecCmd(String cmd) {
        if (cmd != null) {
            this.m_cmd = cmd;
        } else {
            this.error(405, "Host.setExecCmd()", this.getTranslatedMessage("ERROR405", null, null, null));
        }
    }

    private String executeHost(String cmd, int mode) {
        int procId = -1;
        this.log((byte)1, "Host.executeHost()", cmd);
        HostCommand hc = new HostCommand(cmd, mode == 2, this);
        procId = this.storeInObjectCache(hc);
        hc.setProcessHandle(procId);
        hc.start();
        if (mode == 0) {
            try {
                hc.join();
            }
            catch (Exception ex) {
                this.error(406, "Host.executeHost()", this.getTranslatedMessage("ERROR406", ex.toString(), null, null));
            }
        }
        return "" + procId;
    }

    private String getProcessRC(int process) {
        int rc = -1;
        Object hc = this.getFromObjectCache(process);
        if (hc instanceof HostCommand) {
            rc = ((HostCommand)hc).getRC();
        } else {
            this.error(12, "Host.getProcessRC()", this.getTranslatedMessage("ERROR012", "HostCommand", null, null));
        }
        return "" + rc;
    }

    private String getProcessOutput(int process, boolean stderror) {
        StringBuffer sb = new StringBuffer();
        try {
            if (this.m_outputIterator == null) {
                OutputSink sink = null;
                Object hc = this.getFromObjectCache(process);
                if (hc instanceof HostCommand) {
                    sink = stderror ? ((HostCommand)hc).getStdErr() : ((HostCommand)hc).getStdOut();
                } else {
                    this.error(12, "Host.getProcessOutput()", this.getTranslatedMessage("ERROR012", "HostCommand", null, null));
                }
                if (sink != null) {
                    this.m_outputIterator = sink.dumpOutput();
                    this.log((byte)1, "Host.getProcessOutput()", "Got Output Iterator for " + (stderror ? "STDERR" : "STDOUT"));
                } else {
                    this.error(407, "Host.getProcessOutput()", this.getTranslatedMessage("ERROR407", null, null, null));
                }
            }
            if (this.m_outputIterator == null || !this.m_outputIterator.hasNext()) {
                this.log((byte)1, "Host.getProcessOutput()", "Output Iterator is empty");
                sb.append("X");
                this.m_outputIterator = null;
            } else {
                String line = (String)this.m_outputIterator.next();
                if (line.length() > 256) {
                    line = line.substring(0, 256);
                }
                sb.append(this.m_outputIterator.hasNext() ? "Y" : "N");
                sb.append(line);
                if (!this.m_outputIterator.hasNext()) {
                    this.m_outputIterator = null;
                }
            }
        }
        catch (Exception ex) {
            this.unexpectedError("Host.getProcessOutput()", ex);
            sb.append("X");
            this.m_outputIterator = null;
        }
        return sb.toString();
    }

    private void cleanupProcess(String processId) {
        try {
            int process = Integer.parseInt(processId);
            if (process < 0) {
                throw new NumberFormatException();
            }
            this.m_process = -1;
            this.m_outputIterator = null;
            this.eraseFromObjectCache(process);
        }
        catch (NumberFormatException nfe) {
            this.error(401, "Host.cleanupProcess()", this.getTranslatedMessage("ERROR401", processId, null, null));
        }
        catch (NullPointerException npe) {
            this.error(402, "Host.cleanupProcess()", this.getTranslatedMessage("ERROR402", null, null, null));
        }
        catch (Exception lastResort) {
            this.unexpectedError("Host.cleanupProcess()", lastResort);
        }
    }

    private void terminateProcess(String processId) {
        try {
            int process = Integer.parseInt(processId);
            if (process < 0) {
                throw new NumberFormatException();
            }
            Object hc = this.getFromObjectCache(process);
            if (hc instanceof HostCommand) {
                Process proc = ((HostCommand)hc).getProcess();
                if (proc != null) {
                    try {
                        int n = proc.exitValue();
                    }
                    catch (IllegalThreadStateException itse) {
                        proc.destroy();
                    }
                }
            } else {
                this.error(12, "Host.terminateProcess()", this.getTranslatedMessage("ERROR012", "HostCommand", null, null));
            }
        }
        catch (NumberFormatException nfe) {
            this.error(401, "Host.terminateProcess()", this.getTranslatedMessage("ERROR401", processId, null, null));
        }
        catch (NullPointerException npe) {
            this.error(402, "Host.terminateProcess()", this.getTranslatedMessage("ERROR402", null, null, null));
        }
        catch (Exception lastResort) {
            this.unexpectedError("Host.terminateProcess()", lastResort);
        }
    }
}

