/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import oracle.forms.webutil.common.ProgressThread;
import oracle.forms.webutil.fileTransfer.FileTransfer;
import oracle.forms.webutil.fileTransfer.TransferAgent;
import sun.misc.BASE64Encoder;

public class UploadAgent
extends TransferAgent {
    FileInputStream m_input = null;
    BASE64Encoder m_encoder = null;

    public UploadAgent(FileTransfer bean, File clientFile, int fileSize, int maxBytes, boolean asyncMode, boolean withProgress, String title, String subTitle) {
        super(bean, clientFile, fileSize, maxBytes, asyncMode, withProgress);
        String fn = null;
        try {
            fn = clientFile.getPath();
            this.m_fileSize = (int)clientFile.length();
            if (this.m_fileSize == 0) {
                throw new FileNotFoundException();
            }
            this.m_chunks = this.m_fileSize / this.m_maxBytes;
            if (this.m_fileSize % this.m_maxBytes > 0) {
                ++this.m_chunks;
            }
            this.m_input = new FileInputStream(clientFile);
            bean.log((byte)1, "UploadAgent()", "File Opened:" + fn);
            this.m_encoder = new BASE64Encoder();
            this.m_operable = true;
            if (withProgress) {
                this.m_progress = new ProgressThread(this.m_bean.getFrame(), this.m_fileSize, title, subTitle, fn);
                this.m_progress.start();
            }
        }
        catch (FileNotFoundException fnfe) {
            bean.error(106, "UploadAgent()", bean.getTranslatedMessage("ERROR106", fn, null, null));
        }
    }

    public void run() {
        try {
            if (this.m_operable) {
                for (int counter = 0; counter < this.m_chunks; ++counter) {
                    String base64Data = this.getDataInt();
                    if (base64Data == null) {
                        base64Data = "";
                    }
                    UploadAgent uploadAgent = this;
                    synchronized (uploadAgent) {
                        Object var6_6;
                        try {
                            this.m_bean.dispatchMessage(FileTransfer.WUT_TRANSFER_EVENT, base64Data);
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            var6_6 = null;
                            continue;
                        }
                        catch (Throwable throwable) {
                            var6_6 = null;
                            throw throwable;
                        }
                    }
                }
            }
            this.m_bean.reset();
            if (this.m_withProgress && this.m_progress != null) {
                this.m_progress.dispose();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getData() {
        if (this.m_operable) {
            if (this.m_async) {
                return null;
            }
            return this.getDataInt();
        }
        return null;
    }

    private String getDataInt() {
        String result = null;
        try {
            byte[] byteBuffer = new byte[this.m_maxBytes];
            int read = this.m_input.read(byteBuffer);
            this.m_bytesTransferred = this.m_bytesTransferred + read;
            if (read > 0) {
                if (read == this.m_maxBytes) {
                    result = this.m_encoder.encode(byteBuffer);
                } else {
                    byte[] subBuffer = new byte[read];
                    System.arraycopy(byteBuffer, 0, subBuffer, 0, read);
                    result = this.m_encoder.encode(subBuffer);
                }
                if (this.m_withProgress) {
                    this.m_progress.setProgress(this.m_bytesTransferred);
                }
            } else {
                this.m_bean.error(102, "UploadAgent.getData()", this.m_bean.getTranslatedMessage("ERROR102"));
                this.m_operable = false;
            }
            if (this.isFinished()) {
                this.m_input.close();
                this.m_bean.log((byte)1, "UploadAgent.getDataInt()", "File Closed");
            }
        }
        catch (Exception ex) {
            this.m_bean.error(109, "UploadAgent.getData()", this.m_bean.getTranslatedMessage("ERROR109", this.m_clientFile.getName(), ex.toString(), null));
            this.m_operable = false;
        }
        return result;
    }
}

