/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.util.StringTokenizer;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.fileTransfer.DownloadAgent;
import oracle.forms.webutil.fileTransfer.TransferAgent;
import oracle.forms.webutil.fileTransfer.TransferAgentBusy;
import oracle.forms.webutil.fileTransfer.UploadAgent;

public class FileTransfer
extends VBeanCommon {
    private static final ID WUT_FILE_INFO = ID.registerProperty((String)"WUT_FILE_INFO");
    protected static final ID WUT_TRANSFER = ID.registerProperty((String)"WUT_TRANSFER");
    protected static final ID WUT_TRANSFER_EVENT = ID.registerProperty((String)"WUT_TRANSFER_EVENT");
    protected static final ID WUT_STATUS = ID.registerProperty((String)"WUT_STATUS");
    protected static final ID WUT_MAX_BYTES = ID.registerProperty((String)"WUT_MAX_BYTES");
    int m_fileSize = 0;
    File m_file = null;
    boolean m_withProgress = false;
    String m_progressTitle = null;
    String m_progressSubTitle = null;
    boolean m_asyncMode = false;
    static TransferAgent m_agent;
    boolean m_upload = true;
    static boolean s_locked;
    static int s_transferMaxBytes;

    public void setBeanInfo() {
        this.setBeanName("WebUtil File Transfer Bean");
        this.setBeanShortName("WUT");
    }

    public void init(IHandler handler) {
        super.init(handler);
        if (s_transferMaxBytes == -1) {
            s_transferMaxBytes = 16384;
            String paramMB = handler.getApplet().getParameter("WebUtilMaxTransferSize");
            try {
                if (paramMB != null && !paramMB.equalsIgnoreCase("")) {
                    s_transferMaxBytes = Integer.parseInt(paramMB);
                    if (s_transferMaxBytes > 16384) {
                        s_transferMaxBytes = 16384;
                    }
                    this.log((byte)1, "SessionFunctions.init()", "Max Transfer chunk size set to " + s_transferMaxBytes);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUT_FILE_INFO) {
            this.getPropertyLogBefore(propName);
            int chunks = this.m_fileSize / s_transferMaxBytes;
            if (this.m_fileSize % s_transferMaxBytes > 0) {
                ++chunks;
            }
            result = "" + this.m_fileSize + "|" + chunks;
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUT_TRANSFER) {
            result = this.getFileChunk();
            if (result == null) {
                result = "";
            }
        } else if (id == WUT_STATUS) {
            this.getPropertyLogBefore(propName);
            result = s_locked ? "BUSY" : "FREE";
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUT_MAX_BYTES) {
            this.getPropertyLogBefore(propName);
            result = "" + s_transferMaxBytes;
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUT_FILE_INFO) {
            this.setPropertyLogBefore(propName, value);
            this.defineFile(this.defaultNullPropertyValue(value, null));
        } else if (id == WUT_TRANSFER) {
            this.setFileChunk(this.defaultNullPropertyValue(value, null));
        } else if (id == WUT_TRANSFER_EVENT) {
            if (m_agent != null) {
                TransferAgent transferAgent = m_agent;
                synchronized (transferAgent) {
                    try {
                        m_agent.notify();
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        throw throwable;
                    }
                }
            }
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    private String getFileChunk() {
        String result = null;
        UploadAgent ua = null;
        try {
            if (m_agent == null) {
                if (s_locked) {
                    throw new TransferAgentBusy();
                }
                ua = new UploadAgent(this, this.m_file, -1, s_transferMaxBytes, this.m_asyncMode, this.m_withProgress, this.m_progressTitle, this.m_progressSubTitle);
                m_agent = ua;
                s_locked = true;
            } else {
                ua = (UploadAgent)m_agent;
            }
            if (ua.isOperable()) {
                result = ua.getData();
                if (!this.m_asyncMode) {
                    if (ua.isFinished()) {
                        m_agent = null;
                        s_locked = false;
                    }
                } else {
                    ua.start();
                }
            } else {
                this.reset();
            }
        }
        catch (TransferAgentBusy tab) {
            this.error(103, "FileTransfer.getFileChunk()", this.getTranslatedMessage("ERROR103", this.m_file.getName(), null, null));
        }
        return result;
    }

    private void setFileChunk(String data) {
        DownloadAgent da = null;
        try {
            if (m_agent == null) {
                if (s_locked) {
                    throw new TransferAgentBusy();
                }
                da = new DownloadAgent(this, this.m_file, this.m_fileSize, s_transferMaxBytes, false, this.m_withProgress, this.m_progressTitle, this.m_progressSubTitle);
                m_agent = da;
                s_locked = true;
            } else {
                da = (DownloadAgent)m_agent;
            }
            if (da.isOperable()) {
                da.setData(data);
                if (da.isFinished()) {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
        catch (TransferAgentBusy tab) {
            this.error(104, "FileTransfer.getFileChunk()", this.getTranslatedMessage("ERROR104", this.m_file.getName(), null, null));
        }
    }

    private void defineFile(String fileInfo) {
        if (fileInfo != null) {
            try {
                StringTokenizer tok = new StringTokenizer(fileInfo, "|");
                this.m_file = new File(tok.nextToken());
                int len = Integer.parseInt(tok.nextToken());
                this.m_fileSize = len == 0 && this.m_file.exists() ? (int)this.m_file.length() : len;
                this.m_asyncMode = tok.nextToken().equalsIgnoreCase("A");
                this.m_withProgress = tok.nextToken().equalsIgnoreCase("Y");
                if (this.m_withProgress) {
                    this.m_progressTitle = tok.nextToken();
                    this.m_progressSubTitle = tok.nextToken();
                }
            }
            catch (Exception ex) {
                this.error(100, "FileTransfer.defineFile()", this.getTranslatedMessage("ERROR100", fileInfo, null, null));
                this.log((byte)1, "FileTransfer.defineFile()", ex.toString());
            }
        } else {
            this.error(100, "FileTransfer.defineFile()", this.getTranslatedMessage("ERROR100", "<null>", null, null));
        }
    }

    public void reset() {
        m_agent = null;
        s_locked = false;
    }

    public static synchronized TransferAgent getAgent() {
        return m_agent;
    }

    static {
        s_transferMaxBytes = -1;
    }
}

