/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.forms.webutil.common.ProgressThread;
import oracle.forms.webutil.fileTransfer.FileTransfer;
import oracle.forms.webutil.fileTransfer.TransferAgent;
import sun.misc.BASE64Decoder;

public class DownloadAgent
extends TransferAgent {
    BASE64Decoder m_decoder = null;
    FileOutputStream m_output = null;

    public DownloadAgent(FileTransfer bean, File clientFile, int fileSize, int maxBytes, boolean asyncMode, boolean withProgress, String title, String subTitle) {
        super(bean, clientFile, fileSize, maxBytes, asyncMode, withProgress);
        String fn = null;
        try {
            fn = clientFile.getPath();
            this.m_fileSize = fileSize;
            this.m_chunks = this.m_fileSize / this.m_maxBytes;
            if (this.m_fileSize % this.m_maxBytes > 0) {
                ++this.m_chunks;
            }
            this.m_output = new FileOutputStream(clientFile);
            bean.log((byte)1, "DownloadAgent()", "File Opened:" + fn);
            this.m_decoder = new BASE64Decoder();
            this.m_operable = true;
            if (withProgress) {
                this.m_progress = new ProgressThread(this.m_bean.getFrame(), this.m_fileSize, title, subTitle, fn);
                this.m_progress.start();
            }
        }
        catch (FileNotFoundException fnfe) {
            bean.error(105, "DownloadAgent()", bean.getTranslatedMessage("ERROR105", fn, null, null));
        }
    }

    public void run() {
    }

    public void setData(String base64data) {
        byte[] byteBuffer = null;
        if (base64data == null || base64data.length() == 0) {
            this.m_bean.error(107, "DownloadAgent.setData()", this.m_bean.getTranslatedMessage("ERROR107"));
        } else {
            try {
                byteBuffer = this.m_decoder.decodeBuffer(base64data);
                this.m_bytesTransferred = this.m_bytesTransferred + byteBuffer.length;
                this.m_output.write(byteBuffer);
                if (this.m_withProgress) {
                    this.m_progress.setProgress(this.m_bytesTransferred);
                }
                if (this.isFinished()) {
                    this.m_output.close();
                    this.m_bean.log((byte)1, "DownloadAgent.setData()", "File Closed");
                    if (this.m_withProgress) {
                        this.m_progress = null;
                    }
                }
            }
            catch (IOException ioe) {
                this.m_bean.error(108, "DownloadAgent.setData()", this.m_bean.getTranslatedMessage("ERROR108"));
            }
        }
    }
}

