/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import sun.misc.BASE64Decoder;

public class AppServerFileWriter {
    int m_lastError = 0;
    String m_lastErrorArgs = null;
    File m_file = null;
    FileOutputStream m_output = null;
    BASE64Decoder m_decoder = null;
    int m_MAX_READ_BUFF_LEN = 32768;

    public boolean openFile(String serverFile) {
        boolean result = false;
        try {
            if (serverFile != null) {
                this.m_file = new File(serverFile);
                this.m_output = new FileOutputStream(this.m_file);
                this.m_decoder = new BASE64Decoder();
                result = true;
            } else {
                this.m_lastError = 117;
                this.m_lastErrorArgs = null;
            }
        }
        catch (FileNotFoundException fnfe) {
            this.m_lastError = 132;
            this.m_lastErrorArgs = serverFile;
        }
        catch (Exception ex) {
            this.m_lastError = 123;
            this.m_lastErrorArgs = serverFile;
        }
        return result;
    }

    public boolean WriteData(String base64Data) {
        boolean result = false;
        byte[] byteBuffer = null;
        try {
            byteBuffer = this.m_decoder.decodeBuffer(base64Data);
            this.m_output.write(byteBuffer);
            result = true;
        }
        catch (Exception ex) {
            this.m_lastError = 124;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return result;
    }

    public boolean closeFile(int checkSumFileSize) {
        boolean result = false;
        try {
            this.m_output.close();
            this.m_output = null;
            if ((long)checkSumFileSize == this.m_file.length()) {
                result = true;
            } else {
                this.m_lastError = 125;
                this.m_lastErrorArgs = String.valueOf(this.m_file.getPath()) + "|" + checkSumFileSize + "|" + this.m_file.length();
            }
        }
        catch (Exception ex) {
            this.m_lastError = 126;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return result;
    }

    public int getLastError() {
        return this.m_lastError;
    }

    public String getLastErrorArgs() {
        if (this.m_lastErrorArgs == null) {
            return new String("");
        }
        return this.m_lastErrorArgs;
    }

    public boolean decodeBASE64File(String infile) {
        boolean result = false;
        try {
            FileInputStream in = new FileInputStream(infile);
            this.decodeBuffer(infile, in, this.m_output);
            in.close();
            result = true;
        }
        catch (FileNotFoundException fnfe) {
            this.m_lastError = 118;
            this.m_lastErrorArgs = String.valueOf(infile) + " (a temporary BASE64 file)";
        }
        catch (IOException ioe) {
            this.m_lastError = 126;
            this.m_lastErrorArgs = String.valueOf(infile) + " (a temporary BASE64 file)";
        }
        return result;
    }

    private void decodeBuffer(String infile, FileInputStream in, FileOutputStream out) {
        int j;
        int triplet;
        int total_read;
        byte[] inbuff = new byte[this.m_MAX_READ_BUFF_LEN + 3];
        byte[] outbuff = new byte[this.m_MAX_READ_BUFF_LEN / 4 * 3 + 2];
        boolean indicator = true;
        int read = 0;
        int i = 0;
        int loop = 0;
        try {
            total_read = in.read(inbuff, i, this.m_MAX_READ_BUFF_LEN);
        }
        catch (IOException ioe) {
            this.m_lastError = 119;
            this.m_lastErrorArgs = String.valueOf(infile) + " (a temporary BASE64 file)";
            return;
        }
        while (total_read != -1) {
            read = this.removeBadBytes(inbuff, i, total_read + i);
            loop = read / 4 * 4;
            triplet = 0;
            j = 0;
            i = 0;
            while (i < loop) {
                triplet = this.uByteToInt(inbuff[i++]) << 18;
                triplet |= this.uByteToInt(inbuff[i++]) << 12;
                triplet |= this.uByteToInt(inbuff[i++]) << 6;
                outbuff[j + 2] = (byte)((triplet |= this.uByteToInt(inbuff[i++])) & 0xFF);
                outbuff[j + 1] = (byte)((triplet >>= 8) & 0xFF);
                outbuff[j] = (byte)(triplet >> 8);
                j += 3;
            }
            for (int k = 0; k < read - loop; ++k) {
                inbuff[k] = inbuff[i++];
            }
            i = read - loop;
            try {
                total_read = in.read(inbuff, i, this.m_MAX_READ_BUFF_LEN);
            }
            catch (IOException ioe) {
                this.m_lastError = 119;
                this.m_lastErrorArgs = String.valueOf(infile) + " (a temporary BASE64 file)";
                total_read = -1;
            }
            if (j <= 0) continue;
            try {
                out.write(outbuff, 0, j);
            }
            catch (IOException ioe) {
                this.m_lastError = 124;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        }
        i = 0;
        j = 0;
        if (read - loop == 2) {
            outbuff[j] = (byte)(this.uByteToInt(inbuff[i++]) << 2);
            int n = j++;
            outbuff[n] = (byte)(outbuff[n] | (byte)(this.uByteToInt(inbuff[i++]) >> 4));
            try {
                out.write(outbuff, 0, j);
            }
            catch (IOException ioe) {
                this.m_lastError = 124;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        } else if (read - loop == 3) {
            triplet = this.uByteToInt(inbuff[i++]) << 10;
            triplet |= this.uByteToInt(inbuff[i++]) << 4;
            outbuff[j + 1] = (byte)((triplet |= this.uByteToInt(inbuff[i++]) >> 2) & 0xFF);
            outbuff[j] = (byte)(triplet >> 8);
            j += 2;
            try {
                out.write(outbuff, 0, j);
            }
            catch (IOException ioe) {
                this.m_lastError = 124;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        }
    }

    private int uByteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    private int charToInt(byte b) {
        if (b >= 65 && b <= 90) {
            return b - 65;
        }
        if (b >= 97 && b <= 122) {
            return b - 71;
        }
        if (b >= 48 && b <= 57) {
            return b + 4;
        }
        if (b == 43) {
            return 62;
        }
        if (b == 47) {
            return 63;
        }
        return -1;
    }

    private int removeBadBytes(byte[] buff, int off, int num) {
        int i = 0;
        int j = off;
        for (i = off; i < num; ++i) {
            int val = this.charToInt(buff[i]);
            if (val == -1) continue;
            buff[j++] = (byte)val;
        }
        return j;
    }
}

