/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import sun.misc.BASE64Encoder;

public class AppServerFileReader {
    File m_file = null;
    int m_maxBytes = 16384;
    int m_fileSize = 0;
    int m_bytesRead = 0;
    int m_chunks = 0;
    int m_lastError = 0;
    String m_lastErrorArgs = null;
    FileInputStream m_input = null;
    BASE64Encoder m_encoder = null;

    public boolean openFile(String serverFile, int chunkSize) {
        boolean result = false;
        try {
            if (chunkSize > 0 && chunkSize <= 16384) {
                this.m_maxBytes = chunkSize;
            }
            if (serverFile != null) {
                this.m_file = new File(serverFile);
                this.m_fileSize = (int)this.m_file.length();
                if (this.m_fileSize == 0) {
                    throw new FileNotFoundException();
                }
                this.m_chunks = this.m_fileSize / this.m_maxBytes;
                if (this.m_fileSize % this.m_maxBytes > 0) {
                    ++this.m_chunks;
                }
                this.m_input = new FileInputStream(this.m_file);
                this.m_encoder = new BASE64Encoder();
                result = true;
            } else {
                this.m_lastError = 117;
                this.m_lastErrorArgs = null;
            }
        }
        catch (FileNotFoundException fnfe) {
            this.m_lastError = 118;
            this.m_lastErrorArgs = serverFile;
        }
        return result;
    }

    public String readData() {
        String result = null;
        try {
            byte[] byteBuffer = new byte[this.m_maxBytes];
            int read = this.m_input.read(byteBuffer);
            this.m_bytesRead += read;
            if (read > 0) {
                if (read == this.m_maxBytes) {
                    result = this.m_encoder.encode(byteBuffer);
                } else {
                    byte[] subBuffer = new byte[read];
                    System.arraycopy(byteBuffer, 0, subBuffer, 0, read);
                    result = this.m_encoder.encode(subBuffer);
                }
            } else {
                this.m_lastError = 120;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        }
        catch (Exception ex) {
            this.m_lastError = 119;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return result;
    }

    public boolean closeFile() {
        boolean result = false;
        try {
            this.m_input.close();
            this.m_input = null;
            result = true;
        }
        catch (IOException ex) {
            this.m_lastError = 126;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return result;
    }

    public int getSourceLength() {
        return this.m_fileSize;
    }

    public int getSourceChunks() {
        return this.m_chunks;
    }

    public int getLastError() {
        return this.m_lastError;
    }

    public String getLastErrorArgs() {
        if (this.m_lastErrorArgs == null) {
            return new String("");
        }
        return this.m_lastErrorArgs;
    }

    public static String getSeparator() {
        return File.separator;
    }

    public boolean encodeBASE64File(String tempFileName) {
        boolean bl;
        byte[] result;
        block8: {
            result = null;
            try {
                byte[] byteBuffer = new byte[this.m_maxBytes];
                int read = this.m_input.read(byteBuffer);
                this.m_bytesRead += read;
                if (read > 0) {
                    if (read == this.m_maxBytes) {
                        result = this.encodeToBASE64(byteBuffer);
                    } else {
                        byte[] subBuffer = new byte[read];
                        System.arraycopy(byteBuffer, 0, subBuffer, 0, read);
                        result = this.encodeToBASE64(subBuffer);
                    }
                    break block8;
                }
                this.m_lastError = 120;
                this.m_lastErrorArgs = this.m_file.getPath();
                boolean bl2 = false;
                return bl2;
            }
            catch (Exception ex) {
                this.m_lastError = 119;
                this.m_lastErrorArgs = this.m_file.getPath();
                boolean bl3 = false;
                return bl3;
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(tempFileName);
            out.write(result);
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            this.m_lastError = 120;
            this.m_lastErrorArgs = String.valueOf(tempFileName) + " (a temporary BASE64 file)";
            bl = false;
            return bl;
        }
        catch (IOException ioe) {
            this.m_lastError = 119;
            this.m_lastErrorArgs = String.valueOf(tempFileName) + " (a temporary BASE64 file)";
            bl = false;
            return bl;
        }
        return true;
    }

    private byte[] encodeToBASE64(byte[] buff) {
        if (buff.length <= 0) {
            return null;
        }
        byte[] outbuff = new byte[(buff.length + 2) / 3 * 4];
        int i = 0;
        int j = 0;
        int length = buff.length;
        while (i + 2 < length) {
            outbuff[j++] = this.intToChar(this.uByteToInt(buff[i]) >> 2 & 0x3F);
            outbuff[j++] = this.intToChar((this.uByteToInt(buff[i]) << 4 | this.uByteToInt(buff[i + 1]) >> 4) & 0x3F);
            outbuff[j++] = this.intToChar((this.uByteToInt(buff[i + 1]) << 2 | this.uByteToInt(buff[i + 2]) >> 6) & 0x3F);
            outbuff[j++] = this.intToChar(this.uByteToInt(buff[i + 2]) & 0x3F);
            i += 3;
        }
        if (i + 1 < length) {
            outbuff[j++] = this.intToChar(this.uByteToInt(buff[i]) >> 2 & 0x3F);
            outbuff[j++] = this.intToChar((this.uByteToInt(buff[i]) << 4 | this.uByteToInt(buff[i + 1]) >> 4) & 0x3F);
            outbuff[j++] = this.intToChar(this.uByteToInt(buff[i + 1]) << 2 & 0x3F);
            outbuff[j++] = 61;
        } else if (i < length) {
            outbuff[j++] = this.intToChar(this.uByteToInt(buff[i]) >> 2 & 0x3F);
            outbuff[j++] = this.intToChar(this.uByteToInt(buff[i]) << 4 & 0x3F);
            outbuff[j++] = 61;
            outbuff[j++] = 61;
        }
        return outbuff;
    }

    private int uByteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    private byte intToChar(int b) {
        if (b < 26) {
            return (byte)(b + 65);
        }
        if (b < 52) {
            return (byte)(b + 97 - 26);
        }
        if (b < 62) {
            return (byte)(b + 48 - 52);
        }
        if (b == 62) {
            return 43;
        }
        return 47;
    }
}

