/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.File;
import java.io.FileFilter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class WebUtilFileListFilter
implements FileFilter {
    RE m_pattern = null;
    boolean m_matchAll = false;

    public WebUtilFileListFilter(String filterMask) {
        StringBuffer finalMask = new StringBuffer("");
        try {
            if (filterMask == null || filterMask.equals("*") || filterMask.equals("*.*")) {
                this.m_matchAll = true;
            } else {
                String mask = filterMask.toLowerCase();
                char firstChar = mask.charAt(0);
                char lastChar = mask.charAt(mask.length() - 1);
                block7: for (int i = 0; i < mask.length(); ++i) {
                    char thisChar = mask.charAt(i);
                    switch (thisChar) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            finalMask.append("\\");
                            finalMask.append(thisChar);
                            continue block7;
                        }
                        case '?': {
                            finalMask.append('.');
                            continue block7;
                        }
                        case '*': {
                            finalMask.append('.');
                            finalMask.append('*');
                            continue block7;
                        }
                        default: {
                            finalMask.append(thisChar);
                        }
                    }
                }
                if (firstChar != '*') {
                    finalMask.insert(0, '^');
                }
                if (lastChar != '*') {
                    finalMask.append('$');
                }
                this.m_pattern = new RE(finalMask.toString());
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("FileFilter: Invalid Regular Expression supplied " + finalMask + "(Source=" + filterMask + ")");
            this.m_matchAll = true;
        }
    }

    public boolean accept(File pathname) {
        boolean valid = false;
        String fn = pathname.getName().toLowerCase();
        if (pathname.isDirectory()) {
            valid = true;
        } else if (this.m_matchAll || this.m_pattern.match(fn)) {
            valid = true;
        }
        return valid;
    }
}

