/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class WebUtilFileFilter
extends FileFilter {
    String m_mask = null;
    String m_description = null;
    RE m_pattern = null;
    boolean m_matchAll = false;

    public WebUtilFileFilter(String filterMask, String filterDesc) {
        this.m_mask = filterMask;
        StringBuffer finalMask = new StringBuffer("");
        try {
            if (filterMask == null || filterMask.equals("*") || filterMask.equals("*.*")) {
                this.m_matchAll = true;
            } else {
                String mask = filterMask.toLowerCase();
                char firstChar = mask.charAt(0);
                char lastChar = mask.charAt(mask.length() - 1);
                block7: for (int i = 0; i < mask.length(); ++i) {
                    char thisChar = mask.charAt(i);
                    switch (thisChar) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            finalMask.append("\\");
                            finalMask.append(thisChar);
                            continue block7;
                        }
                        case '?': {
                            finalMask.append('.');
                            continue block7;
                        }
                        case '*': {
                            finalMask.append('.');
                            finalMask.append('*');
                            continue block7;
                        }
                        default: {
                            finalMask.append(thisChar);
                        }
                    }
                }
                if (firstChar != '*') {
                    finalMask.insert(0, '^');
                }
                if (lastChar != '*') {
                    finalMask.append('$');
                }
                this.m_pattern = new RE(finalMask.toString());
            }
        }
        catch (RESyntaxException rese) {
            System.out.println("FileFilter: Invalid Regular Expression supplied " + finalMask + "(Source=" + filterMask + ")");
            this.m_matchAll = true;
        }
        this.m_description = filterDesc != null ? filterDesc : "All Files (*.*)";
    }

    public boolean accept(File f) {
        boolean valid = false;
        String fn = f.getName().toLowerCase();
        if (f.isDirectory()) {
            valid = true;
        } else if (this.m_matchAll || this.m_pattern.match(fn)) {
            valid = true;
        }
        return valid;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getMask() {
        return this.m_mask;
    }
}

