/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.file.FFileChooser;
import oracle.forms.webutil.file.WebUtilFileFilter;
import oracle.forms.webutil.file.WebUtilFileListFilter;
import oracle.gss.util.NLSLocale;

public class FileFunctions
extends VBeanCommon {
    private static final ID WUF_TEXTIO_FILEMODE = ID.registerProperty((String)"WUF_TEXTIO_FILEMODE");
    private static final ID WUF_TEXTIO_CHARSET = ID.registerProperty((String)"WUF_TEXTIO_CHARSET");
    private static final ID WUF_TEXTIO_OPEN = ID.registerProperty((String)"WUF_TEXTIO_OPEN");
    private static final ID WUF_TEXTIO_CLOSE = ID.registerProperty((String)"WUF_TEXTIO_CLOSE");
    private static final ID WUF_TEXTIO_HANDLE = ID.registerProperty((String)"WUF_TEXTIO_HANDLE");
    private static final ID WUF_TEXTIO_GETLINE = ID.registerProperty((String)"WUF_TEXTIO_GETLINE");
    private static final ID WUF_TEXTIO_PUT = ID.registerProperty((String)"WUF_TEXTIO_PUT");
    private static final ID WUF_TEXTIO_NEWLINE = ID.registerProperty((String)"WUF_TEXTIO_NEWLINE");
    private static final ID WUF_TEXTIO_ARG = ID.registerProperty((String)"WUF_TEXTIO_ARG");
    private static final ID WUF_TEXTIO_PUTF = ID.registerProperty((String)"WUF_TEXTIO_PUTF");
    private static final ID WUF_GFN_DIRNAME = ID.registerProperty((String)"WUF_GFN_DIRNAME");
    private static final ID WUF_GFN_MESSAGE = ID.registerProperty((String)"WUF_GFN_MESSAGE");
    private static final ID WUF_GFN_SAVEFILE = ID.registerProperty((String)"WUF_GFN_SAVEFILE");
    private static final ID WUF_GFN_OPENFILE = ID.registerProperty((String)"WUF_GFN_OPENFILE");
    private static final ID WUF_GFN_OPENDIR = ID.registerProperty((String)"WUF_GFN_OPENDIR");
    private static final ID WUF_FILENAME = ID.registerProperty((String)"WUF_FILENAME");
    private static final ID WUF_FILTER = ID.registerProperty((String)"WUF_FILTER");
    private static final ID WUF_GFN_SELECTION_MADE = ID.registerProperty((String)"WUF_GFN_SELECTION_MADE");
    private static final ID WUF_GFN_MULTISELECT = ID.registerProperty((String)"WUF_GFN_MULTISELECT");
    private static final ID WUF_FILE_ATTRIBUTE = ID.registerProperty((String)"WUF_FILE_ATTRIBUTE");
    private static final ID WUF_CREATE_DIRECTORY = ID.registerProperty((String)"WUF_CREATE_DIRECTORY");
    private static final ID WUF_RENAME_FILE = ID.registerProperty((String)"WUF_RENAME_FILE");
    private static final ID WUF_DELETE_FILE = ID.registerProperty((String)"WUF_DELETE_FILE");
    private static final ID WUF_COPY_FILE = ID.registerProperty((String)"WUF_COPY_FILE");
    private static final ID WUF_DIRECTORY_LIST = ID.registerProperty((String)"WUF_DIRECTORY_LIST");
    private static final ID WUF_DIRECTORY_ROOT_LIST = ID.registerProperty((String)"WUF_DIRECTORY_ROOT_LIST");
    private static final ID WUF_NO_DIRECTORIES = ID.registerProperty((String)"WUF_NO_DIRECTORIES");
    private static final char SEP = '\n';
    private static final int ATTR_EXISTS = 1;
    private static final int ATTR_READABLE = 2;
    private static final int ATTR_WRITABLE = 3;
    private static final int ATTR_IS_DIRECTORY = 4;
    private static final int ATTR_IS_HIDDEN = 5;
    private static final int ATTR_SIZE = 6;
    private static final int WRITE_TO_CONSOLE = -2;
    private String m_fileName = null;
    private String m_fileMode = null;
    private String m_charSet = null;
    private int m_fileID = -1;
    private String[] m_putfArgs = new String[5];
    private int m_putfArgCount = -1;
    private String m_gfnDirname = null;
    private String m_gfnMessage = null;
    private boolean m_gfnSelectionMade = false;
    private boolean m_gfnMultiSelect = false;
    private static String m_gfnLastDir;
    private int m_attr = 0;
    private String m_newFileName = null;
    private String m_filterString = null;
    private boolean m_incDirs = true;

    public void setBeanInfo() {
        this.setBeanName("WebUtil Client Side File Functions");
        this.setBeanShortName("WUF");
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUF_TEXTIO_OPEN) {
            this.getPropertyLogBefore(propName);
            result = this.fopen();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_TEXTIO_GETLINE) {
            this.getPropertyLogBefore(propName);
            result = this.getLine();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_GFN_OPENDIR) {
            this.getPropertyLogBefore(propName);
            result = this.gfnDialog(false, true);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_GFN_OPENFILE) {
            this.getPropertyLogBefore(propName);
            result = this.gfnDialog(true, false);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_GFN_SAVEFILE) {
            this.getPropertyLogBefore(propName);
            result = this.gfnDialog(false, false);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_GFN_SELECTION_MADE) {
            this.getPropertyLogBefore(propName);
            result = this.m_gfnSelectionMade ? "TRUE" : "FALSE";
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_FILE_ATTRIBUTE) {
            this.getPropertyLogBefore(propName);
            result = this.checkFileAttribute(this.m_fileName, this.m_attr);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_CREATE_DIRECTORY) {
            this.getPropertyLogBefore(propName);
            result = this.createDir(this.m_fileName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_RENAME_FILE) {
            this.getPropertyLogBefore(propName);
            result = this.renameFile(this.m_fileName, this.m_newFileName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_DELETE_FILE) {
            this.getPropertyLogBefore(propName);
            result = this.deleteFile(this.m_fileName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_COPY_FILE) {
            this.getPropertyLogBefore(propName);
            result = this.copyFile(this.m_fileName, this.m_newFileName);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_DIRECTORY_LIST) {
            this.getPropertyLogBefore(propName);
            result = this.listDir(this.m_fileName, this.m_filterString, this.m_incDirs);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUF_DIRECTORY_ROOT_LIST) {
            this.getPropertyLogBefore(propName);
            result = this.listDir(null, null, true);
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUF_FILENAME) {
            this.setPropertyLogBefore(propName, value);
            this.m_fileName = this.defaultNullPropertyValue(value, null);
        } else if (id == WUF_TEXTIO_FILEMODE) {
            this.setPropertyLogBefore(propName, value);
            this.m_fileMode = this.defaultNullPropertyValue(value, "r").toLowerCase();
        } else if (id == WUF_TEXTIO_CHARSET) {
            this.setPropertyLogBefore(propName, value);
            this.setFileEncoding(this.defaultNullPropertyValue(value, "(null)"));
        } else if (id == WUF_TEXTIO_CLOSE) {
            this.setPropertyLogBefore(propName, value);
            this.fclose(this.defaultNullPropertyValue(value, null));
        } else if (id == WUF_TEXTIO_HANDLE) {
            this.setPropertyLogBefore(propName, value);
            this.setHandle(this.defaultNullPropertyValue(value, null));
        } else if (id == WUF_TEXTIO_PUT) {
            this.setPropertyLogBefore(propName, value);
            this.put(this.defaultNullPropertyValue(value, ""));
        } else if (id == WUF_TEXTIO_NEWLINE) {
            this.setPropertyLogBefore(propName, value);
            this.newLine(this.defaultNullPropertyValue(value, "1"));
        } else if (id == WUF_TEXTIO_ARG) {
            this.setPropertyLogBefore(propName, value);
            this.putfArgs(this.defaultNullPropertyValue(value, null));
        } else if (id == WUF_TEXTIO_PUTF) {
            this.setPropertyLogBefore(propName, value);
            this.putf(this.defaultNullPropertyValue(value, ""));
        } else if (id == WUF_GFN_DIRNAME) {
            this.setPropertyLogBefore(propName, value);
            if (m_gfnLastDir == null) {
                m_gfnLastDir = System.getProperty("user.home");
            }
            this.m_gfnDirname = this.defaultNullPropertyValue(value, m_gfnLastDir);
        } else if (id == WUF_GFN_MESSAGE) {
            this.setPropertyLogBefore(propName, value);
            this.m_gfnMessage = this.defaultNullPropertyValue(value, null);
        } else if (id == WUF_FILTER) {
            this.setPropertyLogBefore(propName, value);
            this.m_filterString = this.defaultNullPropertyValue(value, null);
        } else if (id == WUF_GFN_MULTISELECT) {
            this.setPropertyLogBefore(propName, value);
            this.m_gfnMultiSelect = this.defaultNullPropertyValue(value, "FALSE").equalsIgnoreCase("true");
        } else if (id == WUF_FILE_ATTRIBUTE) {
            this.setPropertyLogBefore(propName, value);
            this.m_attr = Integer.parseInt(this.defaultNullPropertyValue(value, "0"));
        } else if (id == WUF_RENAME_FILE || id == WUF_COPY_FILE) {
            this.setPropertyLogBefore(propName, value);
            this.m_newFileName = this.defaultNullPropertyValue(value, null);
        } else if (id == WUF_NO_DIRECTORIES) {
            this.setPropertyLogBefore(propName, value);
            this.m_incDirs = value.toString().equalsIgnoreCase("Y");
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    private Object fopen() {
        String result = null;
        try {
            if (this.m_fileMode.equals("r")) {
                try {
                    this.log((byte)1, "FileFunctions.fopen()", "Opening in Read Mode");
                    result = "" + this.storeInObjectCache(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_fileName), this.m_charSet)));
                }
                catch (IOException ioer) {
                    this.error(200, "FileFunctions.fopen()", this.getTranslatedMessage("ERROR200", this.m_fileName, null, null));
                    result = "";
                }
            } else {
                try {
                    this.log((byte)1, "FileFunctions.fopen()", "Opening in Write/Append Mode");
                    result = "" + this.storeInObjectCache(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_fileName, this.m_fileMode.equals("a")), this.m_charSet)));
                }
                catch (IOException ioew) {
                    this.error(201, "FileFunctions.fopen()", this.getTranslatedMessage("ERROR201", this.m_fileName, this.m_fileMode, ioew.toString()));
                    result = "";
                }
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.fopen()", lastResort);
        }
        return result;
    }

    private Object getLine() {
        String result;
        block6: {
            result = null;
            try {
                Object fh = this.getFromObjectCache(this.m_fileID);
                if (fh instanceof BufferedReader) {
                    try {
                        result = ((BufferedReader)fh).readLine();
                        if (result == null) {
                            result = "\n";
                        }
                        break block6;
                    }
                    catch (IOException ioe) {
                        this.error(203, "FileFunctions.get_line()", this.getTranslatedMessage("ERROR203", ioe.toString(), null, null));
                        result = "\n";
                    }
                    break block6;
                }
                this.error(12, "FileFunctions.get_line()", this.getTranslatedMessage("ERROR012", "BufferedReader", null, null));
                result = "";
            }
            catch (Exception lastResort) {
                this.unexpectedError("FileFunctions.getLine()", lastResort);
            }
        }
        return result;
    }

    private void fclose(String handle) {
        try {
            if (this.setHandle(handle)) {
                Object fh = this.getFromObjectCache(this.m_fileID);
                if (fh instanceof BufferedWriter) {
                    try {
                        ((BufferedWriter)fh).flush();
                        ((BufferedWriter)fh).close();
                    }
                    catch (IOException ioew) {
                        this.error(204, "FileFunctions.fclose()", this.getTranslatedMessage("ERROR204", ioew.toString(), null, null));
                    }
                } else if (fh instanceof BufferedReader) {
                    try {
                        ((BufferedReader)fh).close();
                    }
                    catch (IOException ioer) {
                        this.error(204, "FileFunctions.fclose()", this.getTranslatedMessage("ERROR204", ioer.toString(), null, null));
                    }
                } else {
                    this.error(12, "FileFunctions.fclose()", this.getTranslatedMessage("ERROR012", "BufferedWriter/BufferedReader", null, null));
                }
                this.eraseFromObjectCache(this.m_fileID);
                this.m_fileID = -1;
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.fclose()", lastResort);
        }
    }

    private boolean setHandle(String handle) {
        boolean result = false;
        try {
            this.m_fileID = Integer.parseInt(handle);
            if (this.m_fileID < 0 && this.m_fileID != -2) {
                throw new NumberFormatException();
            }
            if (this.m_putfArgCount >= 0) {
                for (int i = 0; i <= this.m_putfArgCount; ++i) {
                    this.m_putfArgs[i] = null;
                }
                this.m_putfArgCount = -1;
            }
            result = true;
        }
        catch (NumberFormatException nfe) {
            this.error(206, "FileFunctions.setHandle()", this.getTranslatedMessage("ERROR206", handle, null, null));
        }
        catch (NullPointerException npe) {
            this.error(207, "FileFunctions.setHandle()", this.getTranslatedMessage("ERROR207", null, null, null));
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.setHandle()", lastResort);
        }
        return result;
    }

    private void put(String data) {
        try {
            if (this.m_fileID == -2) {
                System.out.print(data);
            } else {
                Object fh = this.getFromObjectCache(this.m_fileID);
                if (fh instanceof BufferedWriter) {
                    BufferedWriter bw = (BufferedWriter)fh;
                    try {
                        bw.write(data);
                    }
                    catch (IOException ioe) {
                        this.error(202, "FileFunctions.put()", this.getTranslatedMessage("ERROR202", ioe.toString(), null, null));
                    }
                } else {
                    this.error(12, "FileFunctions.put()", this.getTranslatedMessage("ERROR012", "BufferedWriter", null, null));
                }
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.put()", lastResort);
        }
    }

    private void newLine(String lineCount) {
        block10: {
            try {
                int count = 0;
                try {
                    count = Integer.parseInt(lineCount);
                }
                catch (NumberFormatException nfe) {
                    this.error(205, "FileFunctions.newLine()", this.getTranslatedMessage("ERROR205", lineCount, null, null));
                }
                if (this.m_fileID == -2) {
                    for (int i = 1; i <= count; ++i) {
                        System.out.println();
                    }
                    break block10;
                }
                Object fh = this.getFromObjectCache(this.m_fileID);
                if (fh instanceof BufferedWriter) {
                    BufferedWriter bw = (BufferedWriter)fh;
                    try {
                        for (int i = 1; i <= count; ++i) {
                            bw.newLine();
                        }
                        break block10;
                    }
                    catch (IOException ioe) {
                        this.error(202, "FileFunctions.newLine()", this.getTranslatedMessage("ERROR202", ioe.toString(), null, null));
                        break block10;
                    }
                }
                this.error(12, "FileFunctions.newLine()", this.getTranslatedMessage("ERROR012", "BufferedWriter", null, null));
            }
            catch (Exception lastResort) {
                this.unexpectedError("FileFunctions.newLine()", lastResort);
            }
        }
    }

    private void putfArgs(String argValue) {
        try {
            if (this.m_putfArgCount < 4) {
                this.m_putfArgs[++this.m_putfArgCount] = argValue;
            } else {
                this.error(208, "FileFunctions.putfArgs()", this.getTranslatedMessage("ERROR208"));
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.putfArgs()", lastResort);
        }
    }

    private void putf(String format) {
        block12: {
            boolean result = false;
            StringBuffer sb = new StringBuffer("");
            Object fh = null;
            BufferedWriter bw = null;
            int start = 0;
            int arg = -1;
            try {
                if (this.m_fileID != -2) {
                    fh = this.getFromObjectCache(this.m_fileID);
                }
                if ((fh instanceof BufferedWriter || this.m_fileID == -2) && format != null) {
                    bw = (BufferedWriter)fh;
                    int loc = format.indexOf("%s");
                    while (loc != -1) {
                        sb.append(format.substring(start, loc));
                        sb.append(this.m_putfArgs[++arg]);
                        start = loc + 2;
                        loc = format.indexOf("%s", start);
                    }
                    sb.append(format.substring(start));
                    try {
                        String formatted = sb.toString();
                        loc = formatted.indexOf("\\n");
                        start = 0;
                        while (loc != -1) {
                            if (this.m_fileID == -2) {
                                System.out.println(formatted.substring(start, loc));
                            } else {
                                bw.write(formatted.substring(start, loc));
                                bw.newLine();
                            }
                            start = loc + 2;
                            loc = formatted.indexOf("\\n", start);
                        }
                        if (this.m_fileID == -2) {
                            System.out.println(formatted.substring(start));
                        } else {
                            bw.write(formatted.substring(start));
                        }
                        result = true;
                    }
                    catch (IOException ioe) {
                        this.error(202, "putf()", this.getTranslatedMessage("ERROR202", ioe.toString(), null, null));
                    }
                    break block12;
                }
                this.error(12, "FileFunctions.putf()", this.getTranslatedMessage("ERROR012", "BufferedWriter", null, null));
            }
            catch (Exception lastResort) {
                this.unexpectedError("FileFunctions.putf()", lastResort);
            }
        }
    }

    private String gfnDialog(boolean openFile, boolean directoryList) {
        String result;
        block19: {
            Object selectButtonLabel = null;
            String selectedFileName = null;
            String selectedFileDir = null;
            result = null;
            try {
                int returnVal;
                this.m_gfnSelectionMade = false;
                File f = new File(String.valueOf(this.m_gfnDirname) + File.separator + this.m_fileName);
                FFileChooser fc = new FFileChooser(f);
                if (this.m_gfnMessage != null) {
                    fc.setDialogTitle(this.m_gfnMessage);
                }
                if (this.m_fileName != null) {
                    fc.setSelectedFile(f);
                }
                if (this.m_filterString != null) {
                    fc.setAcceptAllFileFilterUsed(false);
                    WebUtilFileFilter firstFilter = null;
                    String filterLabel = null;
                    String filterMask = null;
                    StringTokenizer tok = new StringTokenizer(this.m_filterString, "|");
                    while (tok.hasMoreTokens()) {
                        filterLabel = tok.nextToken();
                        if (tok.hasMoreTokens()) {
                            filterMask = tok.nextToken();
                        } else {
                            filterLabel = new String("All Files (*.*)");
                            filterMask = new String("*.*");
                        }
                        if (filterLabel == null || filterMask == null) continue;
                        this.log((byte)1, "gfnDialog()", "Creating Custom File Filter : Mask=" + filterMask + ", Label=" + filterLabel);
                        WebUtilFileFilter ff = new WebUtilFileFilter(filterMask, filterLabel);
                        fc.addChoosableFileFilter(ff);
                        if (firstFilter != null) continue;
                        firstFilter = ff;
                    }
                    fc.setFileFilter(firstFilter);
                } else {
                    fc.setAcceptAllFileFilterUsed(true);
                }
                if (openFile) {
                    this.log((byte)1, "gfnDialog()", "Open File mode");
                    fc.setDialogType(0);
                    fc.setMultiSelectionEnabled(this.m_gfnMultiSelect);
                    returnVal = fc.showOpenDialog(this.getFrame());
                } else if (!directoryList) {
                    this.log((byte)1, "gfnDialog()", "Save File mode");
                    fc.setDialogType(1);
                    returnVal = fc.showSaveDialog(this.getFrame());
                } else {
                    this.log((byte)1, "gfnDialog()", "Directory selection mode");
                    fc.setFileSelectionMode(1);
                    if (this.m_gfnMessage == null) {
                        fc.setDialogTitle(this.getTranslatedMessage("SELDIR_TITLE"));
                    }
                    fc.setApproveButtonMnemonic(this.getTranslatedMessage("OK_MNEMONIC").charAt(0));
                    returnVal = fc.showDialog(this.getFrame(), this.getTranslatedMessage("OK"));
                }
                if (returnVal == 0) {
                    this.m_gfnSelectionMade = true;
                    m_gfnLastDir = fc.getSelectedFile().getParent();
                    if (m_gfnLastDir == null) {
                        m_gfnLastDir = "";
                    }
                    if (!this.m_gfnMultiSelect) {
                        selectedFileName = fc.getSelectedFile().getName();
                        selectedFileDir = String.valueOf(m_gfnLastDir) + File.separator;
                        this.log((byte)1, "gfnDialog()", "Selected Directory: " + selectedFileDir + " Selected File: " + selectedFileName);
                        result = String.valueOf(selectedFileDir) + selectedFileName;
                    } else {
                        StringBuffer sb = new StringBuffer(m_gfnLastDir);
                        sb.append(File.separator);
                        sb.append('\n');
                        File[] files = fc.getSelectedFiles();
                        for (int i = 0; i < files.length; ++i) {
                            sb.append(files[i].getName());
                            sb.append('\n');
                        }
                        this.log((byte)1, "gfnDialog()", "Multiple selection result: " + sb.toString());
                        result = sb.toString();
                    }
                    break block19;
                }
                this.m_gfnSelectionMade = false;
                result = "";
            }
            catch (Exception lastResort) {
                this.unexpectedError("FileFunctions.gfnDialog()", lastResort);
            }
        }
        return result;
    }

    private String checkFileAttribute(String fileName, int attr) {
        String result = null;
        try {
            if (fileName != null) {
                File f = new File(fileName);
                switch (attr) {
                    case 1: {
                        result = this.boolAsString(f.exists());
                        break;
                    }
                    case 2: {
                        if (f.isDirectory()) {
                            result = this.boolAsString(f.canRead());
                            break;
                        }
                        try {
                            FileInputStream fin = new FileInputStream(f);
                            if (fin != null) {
                                fin.close();
                                result = new String("TRUE");
                                break;
                            }
                            result = new String("FALSE");
                        }
                        catch (Exception ex) {
                            result = new String("FALSE");
                        }
                        break;
                    }
                    case 3: {
                        result = this.boolAsString(f.canWrite());
                        break;
                    }
                    case 4: {
                        result = this.boolAsString(f.isDirectory());
                        break;
                    }
                    case 5: {
                        result = this.boolAsString(f.isHidden());
                        break;
                    }
                    case 6: {
                        if (f.isDirectory()) {
                            result = "";
                            break;
                        }
                        result = "" + f.length();
                        break;
                    }
                    default: {
                        result = "FALSE";
                        break;
                    }
                }
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.checkFileAttribute()", lastResort);
        }
        return result;
    }

    private String createDir(String dirName) {
        boolean result = false;
        try {
            if (dirName != null) {
                File dir = new File(dirName);
                result = dir.mkdirs();
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.createDir()", lastResort);
        }
        return result ? "TRUE" : "FALSE";
    }

    private String renameFile(String fileName, String newFileName) {
        boolean result = false;
        try {
            if (fileName != null && newFileName != null) {
                this.log((byte)1, "FileFunctions.renameFile()", "Renaming " + fileName + " to " + newFileName);
                File f = new File(fileName);
                if (f.exists()) {
                    result = f.renameTo(new File(newFileName));
                } else {
                    this.log((byte)1, "FileFunctions.renameFile()", "File " + fileName + " does not exist - cannot rename");
                }
            } else {
                this.log((byte)1, "FileFunctions.renameFile()", "File name is empty - cannot rename");
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.renameFile()", lastResort);
        }
        return result ? "TRUE" : "FALSE";
    }

    private String deleteFile(String fileName) {
        boolean result = false;
        try {
            if (fileName != null) {
                this.log((byte)1, "FileFunctions.deleteFile()", "Deleting " + fileName);
                File f = new File(fileName);
                if (f.exists()) {
                    result = f.delete();
                } else {
                    this.log((byte)1, "FileFunctions.deleteFile()", "File does not exist to delete");
                }
            } else {
                this.log((byte)1, "FileFunctions.deleteFile()", "File name is empty - cannot delete");
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.deleteFile()", lastResort);
        }
        return result ? "TRUE" : "FALSE";
    }

    private String copyFile(String fileName, String newFileName) {
        boolean result;
        block10: {
            result = false;
            try {
                if (fileName != null && newFileName != null) {
                    int c;
                    this.log((byte)1, "FileFunctions.copyFile()", "Copying " + fileName + " to " + newFileName);
                    File inFile = new File(fileName);
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(inFile);
                    }
                    catch (FileNotFoundException fnfe) {
                        this.error(106, "FileFunctions.copyFile()", this.getTranslatedMessage("ERROR106", fileName, null, null));
                        String string = "FALSE";
                        return string;
                    }
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(newFileName, false);
                    }
                    catch (FileNotFoundException fnfe) {
                        this.error(105, "FileFunctions.copyFile()", this.getTranslatedMessage("ERROR105", newFileName, null, null));
                        in.close();
                        String string = "FALSE";
                        return string;
                    }
                    while ((c = in.read()) != -1) {
                        out.write(c);
                    }
                    in.close();
                    out.close();
                    File outFile = new File(newFileName);
                    if (inFile.length() == outFile.length()) {
                        this.log((byte)1, "FileFunctions.copyFile()", "Copy successful");
                        result = true;
                    } else {
                        this.error(209, "FileFunctions.copyFile()", this.getTranslatedMessage("ERROR209"));
                    }
                    break block10;
                }
                this.log((byte)1, "FileFunctions.copyFile()", "File name is empty - cannot copy");
            }
            catch (Exception lastResort) {
                this.unexpectedError("FileFunctions.copyFile()", lastResort);
            }
        }
        return result ? "TRUE" : "FALSE";
    }

    private String listDir(String root, String filter, boolean includeDirs) {
        StringBuffer sb = new StringBuffer();
        try {
            File[] flist = null;
            if (root == null) {
                flist = File.listRoots();
            } else {
                File dir = new File(root);
                if (filter == null) {
                    flist = dir.listFiles();
                } else {
                    WebUtilFileListFilter dirFilter = new WebUtilFileListFilter(filter);
                    flist = dir.listFiles(dirFilter);
                }
            }
            for (int i = 0; i < flist.length; ++i) {
                if (!includeDirs && flist[i].isDirectory()) continue;
                if (root == null) {
                    sb.append(flist[i].getPath());
                } else {
                    sb.append(flist[i].getName());
                }
                sb.append('\n');
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("FileFunctions.listDir()", lastResort);
        }
        return sb.toString();
    }

    private void setFileEncoding(String charSet) {
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        String def_charSet = osw.getEncoding();
        if (charSet.equalsIgnoreCase("(null)")) {
            this.m_charSet = def_charSet;
        } else {
            this.m_charSet = charSet.toUpperCase();
            NLSLocale nlsloc = NLSLocale.getInstance();
            if (nlsloc.getJavaCharset(this.m_charSet) != null) {
                this.m_charSet = nlsloc.getJavaCharset(this.m_charSet);
            }
            try {
                osw = new OutputStreamWriter((OutputStream)System.out, this.m_charSet);
                this.m_charSet = osw.getEncoding();
            }
            catch (UnsupportedEncodingException uee) {
                this.log((byte)0, "FileFunctions.setFileEncoding()", "Given java character set " + this.m_charSet + " is not supported. Using default " + def_charSet);
                this.m_charSet = def_charSet;
            }
        }
    }
}

