/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import oracle.forms.webutil.file.WebUtilFileFilter;

public class FFileChooser
extends JFileChooser {
    public FFileChooser(File f) {
        super(f);
    }

    public void setSelectedFile(File f) {
        if (f != null && (f.isDirectory() && this.getFileSelectionMode() == 0 || f.getName() == null)) {
            return;
        }
        super.setSelectedFile(f);
    }

    public void approveSelection() {
        File f = this.getSelectedFile();
        if (f == null || f.getName() == null) {
            super.approveSelection();
            return;
        }
        String fName = f.getName();
        if (fName.indexOf(42) != -1 || fName.indexOf(63) != -1) {
            FileFilter[] filters = this.getChoosableFileFilters();
            int i = 0;
            for (i = 0; i < filters.length; ++i) {
                FileFilter fFilter = filters[i];
                if (!(fFilter instanceof WebUtilFileFilter) || !fName.equalsIgnoreCase(((WebUtilFileFilter)fFilter).getMask())) continue;
                this.setCurrentDirectory(f.getParentFile());
                this.setFileFilter(fFilter);
                return;
            }
            WebUtilFileFilter filter = new WebUtilFileFilter(fName, fName);
            this.setCurrentDirectory(f.getParentFile());
            this.addChoosableFileFilter(filter);
        } else {
            super.approveSelection();
        }
    }
}

