/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import oracle.forms.engine.Main;
import oracle.forms.engine.Runform;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageManager;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.VBean;
import oracle.forms.webutil.common.Alert;
import oracle.forms.webutil.common.LoggingEngine;
import oracle.forms.webutil.common.ProgressDialog;
import oracle.forms.webutil.common.URLDownload;
import oracle.forms.webutil.common.Version;
import oracle.forms.webutil.fileTransfer.FileTransfer;
import oracle.forms.webutil.fileTransfer.TransferAgent;
import org.apache.regexp.RE;

public class VBeanCommon
extends VBean {
    static /* synthetic */ Class class$oracle$forms$webutil$common$VBeanCommon;
    public static final ID WUC_LOGMODE = ID.registerProperty((String)"WUC_LOGMODE");
    public static final ID WUC_LOGMODE_LEVEL = ID.registerProperty((String)"WUC_LOGMODE_LEVEL");
    public static final ID WUC_ERRORMODE = ID.registerProperty((String)"WUC_ERRORMODE");
    public static final ID WUC_ERROR_MSG = ID.registerProperty((String)"WUC_ERROR_MSG");
    public static final ID WUC_TRANS_MSG = ID.registerProperty((String)"WUC_TRANS_MSG");
    public static final ID WUC_SRV_LOGGING = ID.registerProperty((String)"WUC_SRV_LOGGING");
    public static final ID WUC_BEAN_VERSION = ID.registerProperty((String)"WUC_BEAN_VERSION");
    public static final ID WUC_CHECK_ERROR = ID.registerProperty((String)"WUC_CHECK_ERROR");
    public static final ID WUC_URL_DOWNLOAD = ID.registerProperty((String)"WUC_URL_DOWNLOAD");
    public static final ID WUC_SET_LOCAL_PROPERTY = ID.registerProperty((String)"WUC_SET_LOCAL_PROPERTY");
    public static final ID WUC_GET_LOCAL_PROPERTY = ID.registerProperty((String)"WUC_GET_LOCAL_PROPERTY");
    public static final ID WUC_GLOBAL_REFERENCE = ID.registerProperty((String)"WUC_GLOBAL_REFERENCE");
    public static final ID WUC_LOG_EVENT = ID.registerProperty((String)"WUC_LOG_EVENT");
    public static final ID WUC_ERROR_EVENT = ID.registerProperty((String)"WUC_ERROR_EVENT");
    public static final ID WUC_ERROR_NUMBER = ID.registerProperty((String)"WUC_ERROR_NUMBER");
    public static final ID WUC_DATA = ID.registerProperty((String)"WUC_DATA");
    public static final ID WUC_DATA_MULTIPART = ID.registerProperty((String)"WUC_DATA_MULTIPART");
    public static final ID WUC_REGISTER = ID.registerProperty((String)"WUC_REGISTER");
    public static int MAX_MESSAGE_LENGTH_CHARS = 32000;
    public static int MAX_MESSAGE_LENGTH_BYTES = 2500;
    public static final String WEBUTIL_PROPERTIES = "webutil.properties";
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static String JRE_HOME_ROOT = String.valueOf(System.getProperty("java.home")) + FILE_SEP;
    private String m_beanName = null;
    private String m_beanShortName = null;
    private InetAddress m_localhost = null;
    private LoggingEngine m_logger = null;
    private static MessageManager s_msgMgr = new MessageManager("oracle.forms.webutil.common.WebUtilBundle");
    private static String msgKey;
    private JLabel m_beanLabel = null;
    private Frame m_frame = null;
    private boolean m_isDispatchAllowed = false;
    public boolean m_destroyed = false;
    public int m_lastError = 0;
    private static Vector s_objectCache;
    private static int s_cacheIndex;
    private static Vector s_objectOwners;
    private static int s_global;
    private int m_objCount;
    private static boolean m_propertiesChanged;
    private static Properties m_settings;
    private String m_propertyValue = null;
    private String m_downloadInfo = null;
    private boolean m_trustInternal = true;

    static /* synthetic */ Class class$(String a) {
        try {
            Class<?> clazz = Class.forName(a);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    public VBeanCommon() {
        this.setBeanInfo();
        this.m_logger = new LoggingEngine(this.m_beanShortName, this);
        this.m_logger.setLogDetail((byte)0);
        this.m_logger.setLogMode((byte)0);
    }

    public void setBeanInfo() {
        this.setBeanName("WebUtil Common Superclass");
        this.setBeanShortName("WUC");
    }

    public void init(IHandler handler) {
        String trustInternal;
        String jreRoot;
        String paramLAF;
        String paramErrMode;
        String paramLogDetail;
        this.m_beanLabel = new JLabel(String.valueOf(this.m_beanName) + " - " + Version.getString());
        this.add(this.m_beanLabel);
        String paramLogMode = handler.getApplet().getParameter("WebUtilLogging");
        if (paramLogMode != null && !paramLogMode.equals("")) {
            this.getLogger().setLogMode(paramLogMode);
        }
        if ((paramLogDetail = handler.getApplet().getParameter("WebUtilLoggingDetail")) != null && !paramLogDetail.equals("")) {
            this.getLogger().setLogDetail(paramLogDetail);
        }
        if ((paramErrMode = handler.getApplet().getParameter("WebUtilErrorMode")) != null && !paramErrMode.equals("")) {
            this.getLogger().setErrorMode(paramErrMode);
        }
        if ((paramLAF = handler.getApplet().getParameter("lookAndFeel")) == null || !paramLAF.equals("")) {
            // empty if block
        }
        if ((jreRoot = handler.getApplet().getParameter("WebUtilDebugJRE")) != null && !jreRoot.equals("")) {
            JRE_HOME_ROOT = String.valueOf(jreRoot) + FILE_SEP;
        }
        if (!((trustInternal = handler.getApplet().getParameter("WebUtilTrustInternal")) == null || trustInternal.equalsIgnoreCase("") || trustInternal.equalsIgnoreCase("true") || trustInternal.equalsIgnoreCase("yes"))) {
            this.m_trustInternal = false;
        }
        this.findLocalHost();
        super.init(handler);
        if (!this.isDomainTrusted(handler)) {
            String msg = "WUC-27: " + this.getTranslatedMessage("ERROR027", handler.getApplet().getDocumentBase().getHost(), null, null);
            SecurityException se = new SecurityException(msg);
            se.printStackTrace();
            Runform dispatcher = ((UICommon)handler).getDispatcher();
            dispatcher.showAlert(msg, dispatcher.exceptionToString((Exception)se));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDomainTrusted(IHandler handler) {
        serverDomain = handler.getApplet().getDocumentBase().getHost();
        if (serverDomain.equalsIgnoreCase("") != false) return true;
        if (serverDomain.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (this.m_trustInternal && serverDomain.indexOf(46) == -1) {
            return true;
        }
        domainString = null;
        domainIP = null;
        try {
            domainAddress = InetAddress.getByName(serverDomain);
            domainString = domainAddress.getHostName();
            domainIP = domainAddress.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            domainString = serverDomain;
            domainIP = serverDomain;
        }
        resURL = (VBeanCommon.class$oracle$forms$webutil$common$VBeanCommon == null ? (VBeanCommon.class$oracle$forms$webutil$common$VBeanCommon = VBeanCommon.class$("oracle.forms.webutil.common.VBeanCommon")) : VBeanCommon.class$oracle$forms$webutil$common$VBeanCommon).getResource("TrustedDomains.txt");
        in = (VBeanCommon.class$oracle$forms$webutil$common$VBeanCommon == null ? (VBeanCommon.class$oracle$forms$webutil$common$VBeanCommon = VBeanCommon.class$("oracle.forms.webutil.common.VBeanCommon")) : VBeanCommon.class$oracle$forms$webutil$common$VBeanCommon).getResourceAsStream("TrustedDomains.txt");
        if (in == null) {
            return true;
        }
        br = new BufferedReader(new InputStreamReader(in));
        trustedDomain = null;
        try {
            try {}
            catch (Exception e) {
                this.error(28, "VBeanCommon.isDomainTrusted()", this.getTranslatedMessage("ERROR028"));
                var10_13 = false;
                var12_16 = null;
                try {
                    br.close();
                    return var10_13;
                }
                catch (IOException var13_20) {
                    // empty catch block
                }
                return var10_13;
            }
        }
        catch (Throwable var11_22) {
            var12_17 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 301->309)] { 
lbl41:
            // 1 sources

            br.close();
            throw var11_22;
lbl43:
            // 1 sources

            catch (IOException var13_21) {
                // empty catch block
            }
            throw var11_22;
        }
        while ((trustedDomain = br.readLine()) != null) {
            if (trustedDomain.equalsIgnoreCase("") || trustedDomain.charAt(0) == '/' || !(hostPattern = new RE(VBeanCommon.populateStarForRE(trustedDomain), 1)).match(domainString) && !hostPattern.match(domainIP)) continue;
            br.close();
            var10_12 = true;
            var12_14 = null;
            ** try [egrp 3[TRYBLOCK] [3 : 301->309)] { 
lbl54:
            // 1 sources

            br.close();
            return var10_12;
lbl56:
            // 1 sources

            catch (IOException var13_18) {
                // empty catch block
            }
            return var10_12;
        }
        var12_15 = null;
        try {}
        catch (IOException var13_19) {
            return false;
        }
        br.close();
        return false;
    }

    public static String populateStarForRE(String original) {
        StringBuffer result = new StringBuffer("");
        if (original == null || original.equals("")) {
            return original;
        }
        String str = original.toLowerCase();
        char firstChar = str.charAt(0);
        char lastChar = str.charAt(str.length() - 1);
        block4: for (int i = 0; i < str.length(); ++i) {
            char thisChar = str.charAt(i);
            switch (thisChar) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append("\\");
                    result.append(thisChar);
                    continue block4;
                }
                case '*': {
                    result.append('.');
                    result.append('*');
                    continue block4;
                }
                default: {
                    result.append(thisChar);
                }
            }
        }
        if (firstChar != '*') {
            result.insert(0, '^');
        }
        if (lastChar != '*') {
            result.append('$');
        }
        return result.toString();
    }

    public void destroy() {
        if (!this.m_destroyed) {
            this.m_isDispatchAllowed = false;
            this.log((byte)0, "VBeanCommon.destroy()", String.valueOf(this.m_beanName) + " being removed..");
            if (s_objectCache != null) {
                int cleanedObjCount = 0;
                int allocatedCount = this.m_objCount;
                int objRef = s_objectOwners.lastIndexOf((Object)this);
                while (objRef >= 0) {
                    this.eraseFromObjectCache(objRef + 1);
                    ++cleanedObjCount;
                    objRef = s_objectOwners.lastIndexOf((Object)this);
                }
                this.log((byte)0, "VBeanCommon.destroy()", String.valueOf(cleanedObjCount) + " out of " + allocatedCount + " object references removed, " + s_global + " (total) global references outstanding");
            }
            this.m_destroyed = true;
            this.saveSettings();
        }
        super.destroy();
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUC_CHECK_ERROR) {
            if (this.m_lastError == 0) {
                result = "0,";
            } else {
                String sError = this.m_lastError < 10 ? "ERROR00" + this.m_lastError : (this.m_lastError < 100 ? "ERROR0" + this.m_lastError : "ERROR" + this.m_lastError);
                result = "" + this.m_lastError + "," + this.getTranslatedMessage(sError);
            }
            this.m_lastError = 0;
        } else if (id == WUC_TRANS_MSG) {
            this.getPropertyLogBefore(propName);
            if (msgKey != null) {
                result = this.getTranslatedMessage(msgKey);
            }
            msgKey = null;
        } else if (id == WUC_BEAN_VERSION) {
            this.getPropertyLogBefore(propName);
            result = Version.getString();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUC_GET_LOCAL_PROPERTY) {
            this.getPropertyLogBefore(propName);
            result = this.getWebutilProperty(this.m_propertyValue);
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUC_URL_DOWNLOAD) {
            this.getPropertyLogBefore(propName);
            result = this.downloadFromURL(this.m_downloadInfo);
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == ID.FOREGROUND) {
            this.m_beanLabel.setForeground((Color)value);
        } else if (id == ID.FONT) {
            this.m_beanLabel.setFont((Font)value);
        } else if (id == WUC_LOGMODE) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            if (value != null) {
                this.getLogger().setLogMode((String)value);
            }
        } else if (id == WUC_LOGMODE_LEVEL) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.getLogger().setLogDetail((String)value);
        } else if (id == WUC_ERRORMODE) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.getLogger().setErrorMode((String)value);
        } else if (id == WUC_ERROR_MSG) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.errorMsg((String)value);
        } else if (id == WUC_TRANS_MSG) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            msgKey = (String)value;
        } else if (id == WUC_SRV_LOGGING) {
            this.getLogger().setSrvLoggingOptions(Integer.parseInt((String)value));
            this.setPropertyLogBefore(propName, this.safePrint(value));
        } else if (id == WUC_SET_LOCAL_PROPERTY) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.setWebutilProperty(this.defaultNullPropertyValue(value, null));
        } else if (id == WUC_GET_LOCAL_PROPERTY) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.m_propertyValue = this.defaultNullPropertyValue(value, null);
        } else if (id == WUC_URL_DOWNLOAD) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.m_downloadInfo = this.defaultNullPropertyValue(value, null);
        } else if (id == WUC_GLOBAL_REFERENCE) {
            this.setPropertyLogBefore(propName, this.safePrint(value));
            this.handleGlobalRef(this.defaultNullPropertyValue(value, null));
        } else if (id == ID.VISIBLE) {
            this.m_isDispatchAllowed = true;
            result = super.setProperty(id, value);
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(this.m_beanShortName);
                sb.append("|");
                sb.append(this.getIPAddress());
                sb.append("|");
                sb.append(System.getProperty("os.name"));
                sb.append("|");
                sb.append(System.getProperty("user.name"));
                sb.append("|");
                sb.append(System.getProperty("path.separator"));
                sb.append("|");
                sb.append(FILE_SEP);
                sb.append("|");
                sb.append(System.getProperty("user.language"));
                this.dispatchMessage(WUC_REGISTER, sb.toString());
            }
            catch (AccessControlException ace) {
                this.error(11, "Registering", this.getTranslatedMessage("ERROR011"));
            }
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    public LoggingEngine getLogger() {
        return this.m_logger;
    }

    public final MessageManager getMessageManager() {
        return s_msgMgr;
    }

    public String getTranslatedMessage(String msg) {
        String sError;
        String arg3;
        String arg2;
        String arg1;
        block2: {
            arg1 = null;
            arg2 = null;
            arg3 = null;
            StringTokenizer tok = new StringTokenizer(msg, "|");
            sError = tok.nextToken();
            if (tok.hasMoreTokens()) {
                arg1 = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                arg2 = tok.nextToken();
            }
            if (!tok.hasMoreTokens()) break block2;
            arg3 = tok.nextToken();
        }
        return this.getTranslatedMessage(sError, arg1, arg2, arg3);
    }

    public String getTranslatedMessage(String msgName, Object value1, Object value2, Object value3) {
        return s_msgMgr.getMessage(msgName, ((UICommon)this.getHandler()).getDispatcher().getLocale(), value1, value2, value3);
    }

    public void setBeanName(String beanName) {
        this.m_beanName = beanName;
    }

    public String getBeanName() {
        return this.m_beanName;
    }

    public void setBeanShortName(String beanShortName) {
        this.m_beanShortName = beanShortName;
    }

    public String getBeanShortName() {
        return this.m_beanShortName;
    }

    public void setErrorCondition(int errorNo) {
        this.m_lastError = errorNo;
    }

    private void findLocalHost() {
        if (this.m_localhost == null) {
            try {
                this.log((byte)0, "VBeanCommon.findLocalHost()", "obtaining LocalHost info from InetAddress");
                this.m_localhost = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                this.error(9, "VBeanCommon.findLocalHost()", this.getTranslatedMessage("ERROR009", e.toString(), null, null));
            }
        }
    }

    public InetAddress getLocalHost() {
        return this.m_localhost;
    }

    public String getIPAddress() {
        String ip = null;
        try {
            this.findLocalHost();
            if (this.m_localhost != null) {
                ip = this.m_localhost.getHostAddress();
                this.log((byte)1, "VBeanCommon.getIPAddress()", ip);
            } else {
                this.error(10, "VBeanCommon.getIPAddress()", this.getTranslatedMessage("ERROR010"));
                ip = new String("");
            }
        }
        catch (Exception lastResort) {
            this.unexpectedError("VBeanCommon.getIPAddress()", lastResort);
        }
        return ip;
    }

    public void message(String msg) {
        if (this.isLogging()) {
            this.log((byte)1, "VBeanCommon.message()", "msg ==>" + msg);
        }
        this.getHandler().getApplet().showStatus(msg);
    }

    public void alert(String title, String msg) {
        block4: {
            TransferAgent agent = FileTransfer.getAgent();
            if (agent != null) {
                TransferAgent transferAgent = agent;
                synchronized (transferAgent) {
                    try {
                        Alert alert = new Alert(this.getFrame(), title, this.getTranslatedMessage("OK"), msg);
                        agent.notify();
                        Object var7_7 = null;
                        break block4;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        throw throwable;
                    }
                }
            }
            Alert alert = new Alert(this.getFrame(), title, this.getTranslatedMessage("OK"), msg);
        }
    }

    public Frame getFrame() {
        if (this.m_frame == null) {
            Applet formsMain = this.getHandler().getApplet();
            this.m_frame = ((Main)formsMain).getFrame();
            if (this.m_frame == null) {
                this.error(1, "VBeanCommon.getFrame()", this.getTranslatedMessage("ERROR001"));
            }
        }
        return this.m_frame;
    }

    public void dispatchLogMessage(String messageData) {
        this.dispatchMessage(WUC_LOG_EVENT, messageData);
    }

    public void dispatchErrorMessage(String messageData, int errorCode) {
        try {
            CustomEvent ce = new CustomEvent((Object)this.getHandler(), WUC_ERROR_EVENT);
            this.getHandler().setProperty(WUC_DATA, (Object)messageData);
            this.getHandler().setProperty(WUC_ERROR_NUMBER, (Object)new String("" + errorCode));
            this.getHandler().setProperty(WUC_DATA_MULTIPART, (Object)"1/1");
            super.dispatchCustomEvent(ce);
        }
        catch (Exception lastResort) {
            this.unexpectedError("VBeanCommon.lastResort()", lastResort);
        }
    }

    public void dispatchMessage(ID messageType, String messageData) {
        this.coreMessageDispatcher(messageType, messageData, 0, null, null, null);
    }

    public void dispatchMessageWithProgress(ID messageType, String messageData, int threshold, String dialogTitle, String dialogSubTitle, String dialogMessage) {
        new ProgressThread(this, messageType, messageData, threshold, dialogTitle, dialogSubTitle, dialogMessage).start();
    }

    private void coreMessageDispatcher(ID messageType, String messageData, int threshHold, String dialogTitle, String dialogSubTitle, String dialogMessage) {
        if (this.m_isDispatchAllowed) {
            String messageBuffer = null;
            boolean withProgress = false;
            ProgressDialog progress = null;
            boolean chunk = true;
            int dataLength = messageData.length();
            int numChunks = dataLength / MAX_MESSAGE_LENGTH_CHARS;
            if (dataLength % MAX_MESSAGE_LENGTH_CHARS > 0) {
                ++numChunks;
            }
            if (threshHold > 0 && numChunks >= threshHold) {
                withProgress = true;
                this.log((byte)0, "dispatchLongMessage()", "Using Progress Dialog");
                progress = new ProgressDialog(this.getFrame(), dialogTitle, dialogSubTitle, dialogMessage, numChunks);
                progress.setVisible(true);
            }
            try {
                for (int i = 0; i < numChunks; ++i) {
                    if (withProgress) {
                        progress.setValue(i);
                        Thread.sleep(1000L);
                    }
                    messageBuffer = i + 1 == numChunks ? messageData.substring(i * MAX_MESSAGE_LENGTH_CHARS) : messageData.substring(i * MAX_MESSAGE_LENGTH_CHARS, (i + 1) * MAX_MESSAGE_LENGTH_CHARS);
                    CustomEvent ce = new CustomEvent((Object)this.getHandler(), messageType);
                    this.getHandler().setProperty(WUC_DATA, (Object)messageBuffer);
                    this.getHandler().setProperty(WUC_DATA_MULTIPART, (Object)("" + (i + 1) + "/" + numChunks));
                    super.dispatchCustomEvent(ce);
                }
                if (withProgress) {
                    progress.setVisible(false);
                }
            }
            catch (Exception lastResort) {
                this.unexpectedError("VBeanCommon.coreMessageDispatcher()", lastResort);
            }
        }
    }

    public boolean isLogging() {
        return this.getLogger().isLogging();
    }

    public void log(byte detailLevel, String identifier, String msg) {
        this.getLogger().log(detailLevel, identifier, msg);
    }

    public void getPropertyLogBefore(String propName) {
        if (this.isLogging()) {
            this.getLogger().log((byte)0, "getProperty()", "Getting property " + propName);
        }
    }

    public void getPropertyLogAfter(String propName, Object result) {
        if (this.isLogging()) {
            this.getLogger().log((byte)1, "getProperty()", "Value of " + propName + "=" + this.safePrint(result));
        }
    }

    public void setPropertyLogBefore(String propName, Object value) {
        if (this.isLogging()) {
            this.getLogger().log((byte)0, "setProperty()", "Setting property " + propName + " to " + this.safePrint(value));
        }
    }

    public void errorMsg(String msg) {
        String arg1 = null;
        String arg2 = null;
        String arg3 = null;
        StringTokenizer tok = new StringTokenizer(msg, "|");
        String sError = tok.nextToken();
        int iError = Integer.parseInt(sError.substring(5, 8));
        String identifier = tok.nextToken();
        if (tok.hasMoreTokens()) {
            arg1 = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            arg2 = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            arg3 = tok.nextToken();
        }
        this.error(iError, identifier, this.getTranslatedMessage(sError, arg1, arg2, arg3));
    }

    public void error(int errNo, String identifier, String msg) {
        this.getLogger().error(errNo, identifier, msg);
    }

    public String safePrint(Object value) {
        String printString = null;
        try {
            printString = value.toString();
        }
        catch (NullPointerException npe) {
            printString = "{NULL}";
        }
        return printString;
    }

    public String boolAsString(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public boolean checkPLSQLString(Object value) {
        boolean result = false;
        if (value instanceof String && !((String)value).equals("") && value != null) {
            result = true;
        }
        return result;
    }

    public boolean checkPLSQLBoolean(Object value) {
        boolean result = false;
        if (value != null) {
            if (value instanceof String) {
                result = ((String)value).equalsIgnoreCase("true");
            } else if (value instanceof Boolean) {
                result = (Boolean)value;
            }
        }
        return result;
    }

    public int storeInObjectCache(Object obj) {
        if (s_objectCache == null) {
            s_objectCache = new Vector(10, 5);
            s_objectOwners = new Vector(10, 5);
            s_cacheIndex = 0;
        }
        s_objectCache.add(obj);
        s_objectOwners.add(this);
        ++this.m_objCount;
        return ++s_cacheIndex;
    }

    public Object getFromObjectCache(int objReference) {
        Object result = null;
        if (s_objectCache != null) {
            try {
                result = s_objectCache.get(objReference - 1);
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                this.error(14, "getFromObjectCache", this.getTranslatedMessage("ERROR014", "" + objReference, null, null));
            }
        } else {
            this.error(13, "getFromObjectCache", this.getTranslatedMessage("ERROR013"));
        }
        if (result == null) {
            this.error(14, "getFromObjectCache", this.getTranslatedMessage("ERROR014", "" + objReference, null, null));
        }
        return result;
    }

    public void eraseFromObjectCache(int objReference) {
        if (s_objectCache != null) {
            try {
                s_objectCache.setElementAt(null, objReference - 1);
                if (s_objectOwners.elementAt(objReference - 1) == this) {
                    --this.m_objCount;
                }
                if (s_objectOwners.elementAt(objReference - 1) == null) {
                    --s_global;
                } else {
                    s_objectOwners.setElementAt(null, objReference - 1);
                }
                this.log((byte)1, "VBeanCommon.eraseFromObjectCache()", "Removed cache reference to Object " + objReference);
            }
            catch (ArrayIndexOutOfBoundsException oob) {
                this.error(14, "eraseFromObjectCache", this.getTranslatedMessage("ERROR014", "" + objReference, null, null));
            }
        }
    }

    public String defaultNullPropertyValue(Object value, String defaultIfNull) {
        if (value instanceof String && value != null) {
            return (String)value;
        }
        return defaultIfNull;
    }

    public void unexpectedError(String context, Exception ex) {
        ex.printStackTrace();
        this.error(15, context, this.getTranslatedMessage("ERROR015", ex.toString(), null, null));
    }

    private void setWebutilProperty(String propString) {
        if (propString != null) {
            this.loadSettings();
            StringTokenizer st = new StringTokenizer(propString, "=");
            String propertyName = st.nextToken();
            String propertyValue = st.nextToken();
            m_settings.setProperty(propertyName, propertyValue);
            m_propertiesChanged = true;
        } else {
            this.error(16, "VBeanCommon.setWebutilProperty()", this.getTranslatedMessage("ERROR016", null, null, null));
        }
    }

    private String getWebutilProperty(String propName) {
        this.loadSettings();
        return "" + m_settings.getProperty(propName);
    }

    private void loadSettings() {
        if (m_settings == null) {
            m_settings = new Properties();
            try {
                String propFile = String.valueOf(JRE_HOME_ROOT) + WEBUTIL_PROPERTIES;
                m_settings.load(new FileInputStream(propFile));
                this.getLogger().log((byte)0, "loadSettings()", "Local properties file loaded");
            }
            catch (FileNotFoundException fnf) {
                this.getLogger().log((byte)0, "loadSettings()", "No local properties file to load");
            }
            catch (Exception lastResort) {
                this.unexpectedError("VBeanCommon.loadSettings()", lastResort);
            }
        }
    }

    private void saveSettings() {
        if (m_propertiesChanged) {
            try {
                String propFile = String.valueOf(JRE_HOME_ROOT) + WEBUTIL_PROPERTIES;
                FileOutputStream wu_properties = new FileOutputStream(propFile);
                m_settings.store(wu_properties, "WebUtil Properties File");
                wu_properties.close();
                m_propertiesChanged = false;
                this.getLogger().log((byte)0, "saveSettings()", "Local properties file saved");
            }
            catch (Exception lastResort) {
                this.unexpectedError("VBeanCommon.saveSettings()", lastResort);
            }
        }
    }

    private String downloadFromURL(String downloadInfo) {
        URL srcURL;
        boolean result = false;
        if (downloadInfo == null || downloadInfo.equalsIgnoreCase("")) {
            this.error(17, "VBeanCommon.downloadFromURL()", this.getTranslatedMessage("ERROR017", "(null)", null, null));
            return "FALSE";
        }
        StringTokenizer tok = new StringTokenizer(downloadInfo, "|");
        if (tok.countTokens() < 5) {
            this.error(17, "VBeanCommon.downloadFromURL()", this.getTranslatedMessage("ERROR017", downloadInfo, null, null));
            return "FALSE";
        }
        int special = Integer.parseInt(tok.nextToken());
        int size = Integer.parseInt(tok.nextToken());
        boolean progress = tok.nextToken().equals("Y");
        String src = tok.nextToken();
        String dest = tok.nextToken();
        if (src == null || src.equalsIgnoreCase("")) {
            this.error(25, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR025"));
            return "FALSE";
        }
        if (dest == null || dest.equalsIgnoreCase("")) {
            this.error(130, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR130"));
            return "FALSE";
        }
        String fullDest = null;
        switch (special) {
            case 0: {
                fullDest = dest;
                break;
            }
            case 1: {
                fullDest = String.valueOf(JRE_HOME_ROOT) + "bin" + FILE_SEP + dest;
                break;
            }
            case 2: {
                fullDest = String.valueOf(JRE_HOME_ROOT) + "lib" + FILE_SEP + dest;
            }
        }
        if (src.startsWith("/")) {
            src = src.substring(1);
        }
        try {
            srcURL = new URL(this.getHandler().getDocumentBase(), src);
        }
        catch (MalformedURLException mue) {
            this.error(18, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR018", src, null, null));
            String string = "FALSE";
            return string;
        }
        src = srcURL.toString();
        this.log((byte)1, "downloadFromURL()", "Source is " + src);
        URLDownload dl = new URLDownload(src, fullDest, size, this.m_logger);
        if (progress) {
            String title = tok.hasMoreTokens() ? tok.nextToken() : "Dowloading URL " + src;
            String subTitle = tok.hasMoreTokens() ? tok.nextToken() : "Downloading URL " + src + " in progress...";
            String message = tok.hasMoreTokens() ? tok.nextToken() : "URL download in progress...";
            dl.setProgressEnabled(this.getFrame(), title, subTitle, message);
        }
        result = dl.pullFile(special > 0);
        return result ? "TRUE" : "FALSE";
    }

    private void handleGlobalRef(String globalRefInfo) {
        block5: {
            try {
                if (globalRefInfo != null) {
                    StringTokenizer tok = new StringTokenizer(globalRefInfo, "|");
                    int ref = Integer.parseInt(tok.nextToken());
                    if (tok.nextToken().equalsIgnoreCase("Y")) {
                        this.persistRef(ref);
                    } else {
                        this.freeRef(ref);
                    }
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception ex) {
                this.error(22, "VBeanCommon.handleGlobalRef()", this.getTranslatedMessage("ERROR022", globalRefInfo, null, null));
            }
        }
    }

    private void persistRef(int ref) {
        s_objectOwners.setElementAt(null, ref - 1);
        ++s_global;
        this.log((byte)1, "VBeanCommon.persistRef()", "Object Reference " + ref + " persisted");
    }

    private void freeRef(int ref) {
        this.eraseFromObjectCache(ref - 1);
    }

    class ProgressThread
    extends Thread {
        VBeanCommon m_dispatcher = null;
        ID m_messageType = null;
        String m_messageData = null;
        int m_threshold = 0;
        String m_dialogTitle = null;
        String m_dialogSubTitle = null;
        String m_dialogMessage = null;

        ProgressThread(VBeanCommon bean, ID messageType, String messageData, int threshold, String dialogTitle, String dialogSubTitle, String dialogMessage) {
            this.m_dispatcher = bean;
            this.m_messageType = messageType;
            this.m_messageData = messageData;
            this.m_threshold = threshold;
            this.m_dialogTitle = dialogTitle;
            this.m_dialogSubTitle = dialogSubTitle;
            this.m_dialogMessage = dialogMessage;
        }

        public void run() {
            this.m_dispatcher.coreMessageDispatcher(this.m_messageType, this.m_messageData, this.m_threshold, this.m_dialogTitle, this.m_dialogSubTitle, this.m_dialogMessage);
        }
    }
}

