/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import oracle.forms.webutil.common.LoggingEngine;
import oracle.forms.webutil.common.ProgressThread;

public class URLDownload {
    String m_from = null;
    String m_to = null;
    int m_size = 0;
    LoggingEngine m_logger = null;
    boolean m_withProgress = false;
    String m_progressTitle = null;
    String m_progressSubTitle = null;
    String m_progressMessage = null;
    Frame m_owner = null;
    int m_progressCount = 0;

    public URLDownload(String from, String to, int size, LoggingEngine logger) {
        this.m_from = from;
        this.m_to = to;
        this.m_size = size;
        this.m_logger = logger;
    }

    public void setProgressEnabled(Frame owner, String title, String subTitle, String msg) {
        this.m_withProgress = true;
        this.m_owner = owner;
        this.m_progressTitle = title;
        this.m_progressSubTitle = subTitle;
        this.m_progressMessage = msg;
    }

    public boolean pullFile(boolean systemFile) {
        int c;
        boolean result = false;
        if (this.m_from == null || this.m_from.equalsIgnoreCase("")) {
            this.m_logger.error(25, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR025"));
            return false;
        }
        if (this.m_to == null || this.m_to.equalsIgnoreCase("")) {
            this.m_logger.error(130, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR130"));
            return false;
        }
        System.setProperty("proxySet", "true");
        URL src = null;
        try {
            src = new URL(this.m_from);
        }
        catch (MalformedURLException mue) {
            this.m_logger.error(18, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR018", this.m_from, null, null));
            boolean bl = false;
            return bl;
        }
        URLConnection url_connect = null;
        try {
            url_connect = src.openConnection();
        }
        catch (IOException ioe) {
            this.m_logger.error(24, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR024", this.m_from, null, null));
            boolean bl = false;
            return bl;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(url_connect.getInputStream());
        }
        catch (IOException ieo) {
            this.m_logger.error(24, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR024", this.m_from, null, null));
            boolean bl = false;
            return bl;
        }
        int url_length = url_connect.getContentLength();
        if (url_length > 0 && systemFile && url_length != this.m_size) {
            this.m_logger.error(21, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR021", this.m_from, null, null));
            return false;
        }
        if (this.m_size <= 0 && url_length > 0) {
            this.m_size = url_length;
        }
        if (url_length <= 0 && this.m_size > 0) {
            url_length = this.m_size;
        }
        try {
            c = in.read();
        }
        catch (IOException ioe) {
            this.m_logger.error(24, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR024", this.m_from, null, null));
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        if (c == -1) {
            this.m_logger.error(26, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR026", this.m_from, null, null));
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.m_to, false);
        }
        catch (IOException ioe) {
            this.m_logger.error(19, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR019", this.m_to, this.m_from, null));
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        ProgressThread pt = null;
        if (this.m_withProgress && url_length > 0) {
            pt = new ProgressThread(this.m_owner, url_length, this.m_progressTitle, this.m_progressSubTitle, this.m_progressMessage);
            pt.start();
        }
        int counter = 0;
        while (c != -1) {
            try {
                out.write(c);
            }
            catch (IOException ioe) {
                this.m_logger.error(19, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR019", this.m_to, this.m_from, null));
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (pt != null) {
                    pt.dispose();
                }
                boolean bl = false;
                return bl;
            }
            if (pt != null && ++counter % 1024 == 0) {
                pt.setProgress(counter);
            }
            try {
                c = in.read();
            }
            catch (IOException ioe) {
                this.m_logger.error(24, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR024", this.m_from, null, null));
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (pt != null) {
                    pt.dispose();
                }
                boolean bl = false;
                return bl;
            }
        }
        if (pt != null) {
            pt.setProgress(url_length);
        }
        try {
            in.close();
            out.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        File clientFile = new File(this.m_to);
        if (this.m_size > 0) {
            if (clientFile.length() == (long)this.m_size) {
                result = true;
            } else {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(this.m_to));
                    String line = br.readLine();
                    br.close();
                    if (line.startsWith("<HTML><HEAD><TITLE>404 Not Found")) {
                        if (systemFile) {
                            this.m_logger.error(23, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR023", this.m_from, null, null));
                        } else {
                            this.m_logger.error(24, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR024", this.m_from, null, null));
                        }
                        boolean bl = false;
                        return bl;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_logger.error(20, "URLDownload.pullFile()", this.m_logger.getTranslatedMessage("ERROR020", this.m_from, this.m_to, null));
                return true;
            }
        }
        return result;
    }

    public int getProgress() {
        return this.m_progressCount;
    }
}

