/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    private DefaultBoundedRangeModel m_model = null;
    private JLabel m_message = null;
    private JProgressBar m_progressBar = null;
    private JPanel m_titlePanel = null;
    private JPanel m_msgPanel = null;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 100;
    private static final Color DIALOG_COLOR = Color.decode("#002288");

    public ProgressDialog(Frame parent, String title, String subTitle, String message, int steps) {
        super(parent);
        this.setResizable(false);
        this.setTitle(title);
        this.setSize(400, 100);
        this.setModal(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_model = new DefaultBoundedRangeModel(0, 1, 0, steps);
        this.m_progressBar = new JProgressBar(this.m_model);
        this.m_progressBar.setStringPainted(true);
        this.m_titlePanel = new JPanel();
        this.m_titlePanel.setLayout(new GridLayout());
        JLabel titleLabel = new JLabel(subTitle);
        titleLabel.setFont(new Font("Helvetica", 1, 12));
        titleLabel.setForeground(DIALOG_COLOR);
        this.m_titlePanel.add(titleLabel);
        this.m_msgPanel = new JPanel();
        this.m_message = new JLabel(message);
        this.m_message.setFont(new Font("Helvetica", 1, 12));
        this.m_message.setForeground(DIALOG_COLOR);
        this.m_msgPanel.add(this.m_message);
        this.getContentPane().add((Component)this.m_titlePanel, "North");
        this.getContentPane().add((Component)this.m_msgPanel, "South");
        this.getContentPane().add((Component)this.m_progressBar, "Center");
        this.setLocation(this.getCenteredLocation(parent));
    }

    public void setValue(int val) {
        this.m_model.setValue(val);
        this.m_progressBar.paintImmediately(this.m_progressBar.getVisibleRect());
        this.m_titlePanel.paintImmediately(this.m_titlePanel.getVisibleRect());
        this.m_msgPanel.paintImmediately(this.m_msgPanel.getVisibleRect());
    }

    public int getValue() {
        return this.m_model.getValue();
    }

    public void setValue(int val, String newMessage) {
        this.m_message.setText(newMessage);
        this.m_model.setValue(val);
    }

    public void increment() {
        this.m_model.setValue(this.m_model.getValue() + 1);
    }

    public Point getCenteredLocation(Frame frame) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        int xoff = (screenSize.width - frameSize.width) / 3;
        int yoff = (screenSize.height - frameSize.height) / 3;
        return new Point(xoff, yoff);
    }

    public static void main(String[] args) {
        Frame frame = new Frame("Test ProgressBar");
        ProgressDialog bar = new ProgressDialog(frame, "A Title", "My Subtitle", "A Message", 20);
        bar.setVisible(true);
        for (int i = 0; i <= 20; ++i) {
            try {
                bar.setValue(i, "New Value = " + i);
                Thread.sleep(250L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        bar.setVisible(false);
        System.exit(0);
    }
}

