/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.forms.webutil.common.VBeanCommon;

public class LoggingEngine {
    public static final byte LOGMODE_NONE = 0;
    public static final byte LOGMODE_CONSOLE = 1;
    public static final byte LOGMODE_SERVER = 2;
    public static final byte LOGDETAIL_NORMAL = 0;
    public static final byte LOGDETAIL_DETAILED = 1;
    public static final byte ERRORMODE_CONSOLE = 0;
    public static final byte ERRORMODE_ALERT = 1;
    public static final byte ERRORMODE_SERVER = 2;
    private int m_logSettings = 0;
    public int srv_logging = 0;
    private static final int ERRORMODE_MASK = 768;
    private static final int ERRORMODE_RESTRICTED_MASK = 256;
    private static final int LOGDETAIL_MASK = 48;
    private static final int LOGMODE_MASK = 3;
    boolean m_logging = false;
    VBeanCommon m_bean = null;
    String m_source = null;
    SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyy-MMM-dd  HH:mm:ss.SS");

    public LoggingEngine(String source, VBeanCommon ownerBean) {
        this.m_bean = ownerBean;
        this.m_source = source;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    public void setLogMode(byte logMode) {
        if (logMode >= 0 && logMode <= 3) {
            this.m_logSettings = this.m_logSettings & 0xFFFFFFFC | logMode;
            this.m_logging = logMode > 0;
        }
    }

    public void setLogMode(String logMode) {
        int byteLogMode = -1;
        if (logMode != null) {
            byteLogMode = logMode.equalsIgnoreCase("console") || logMode.equalsIgnoreCase("on") ? 1 : (logMode.equalsIgnoreCase("server") ? 2 : (logMode.equalsIgnoreCase("all") ? 3 : 0));
            this.setLogMode((byte)byteLogMode);
        }
    }

    public void setLogDetail(byte logDetail) {
        if (logDetail >= 0 && logDetail <= 1) {
            this.m_logSettings = this.m_logSettings & 0xFFFFFFCF | logDetail << 4;
        }
    }

    public void setLogDetail(String logDetail) {
        byte byteLogDetail = -1;
        if (logDetail != null) {
            byteLogDetail = logDetail.equalsIgnoreCase("DETAILED") ? (byte)1 : 0;
            this.setLogDetail(byteLogDetail);
        }
    }

    public byte getLogDetail() {
        return (byte)((this.m_logSettings & 0x30) >> 4);
    }

    public boolean isLogging() {
        return this.m_logging;
    }

    public void setErrorMode(byte errorMode) {
        if (errorMode >= 0 && errorMode <= 3) {
            this.m_logSettings = this.m_logSettings & 0xFFFFFCFF | errorMode << 8;
        }
    }

    public void setErrorMode(String errMode) {
        int byteErrMode = -1;
        if (errMode != null) {
            byteErrMode = errMode.equalsIgnoreCase("server") ? 2 : (errMode.equalsIgnoreCase("alert") ? 1 : (errMode.equalsIgnoreCase("all") ? 3 : 0));
            this.setErrorMode((byte)byteErrMode);
        }
    }

    public void setErrorAlertMode(boolean errorMode) {
        this.m_logSettings = errorMode ? this.m_logSettings & 0xFFFFFEFF | 0x100 : (this.m_logSettings &= 0xFFFFFEFF);
    }

    public void log(byte detailLevel, String identifier, String msg) {
        if (this.m_logging) {
            String timeStamp = this.m_dateFormat.format(new Date());
            if ((this.m_logSettings & 0x10) == 16 || detailLevel == 0) {
                if ((this.m_logSettings & 1) == 1) {
                    System.out.println(String.valueOf(timeStamp) + " " + this.m_source + "[" + identifier + "] " + msg);
                }
                if ((this.m_logSettings & 2) == 2 && this.srv_logging == 2) {
                    this.m_bean.dispatchLogMessage(String.valueOf(timeStamp) + " " + this.m_source + "[" + identifier + "] " + msg);
                }
            }
        }
    }

    public void error(int wuError, String identifier, String msg) {
        String errorStr = new String(String.valueOf(LoggingEngine.createErrorIdent(this.m_source, wuError)) + " [" + identifier + "] " + msg);
        String timeStamp = this.m_dateFormat.format(new Date());
        System.out.println(String.valueOf(timeStamp) + " ERROR>" + errorStr);
        this.m_bean.setErrorCondition(wuError);
        if ((this.m_logSettings & 0x100) == 256) {
            this.m_bean.alert("Forms", String.valueOf(LoggingEngine.createErrorIdent(this.m_source, wuError)) + ": " + msg);
        }
        if ((this.m_logSettings & 0x200) == 512 && this.srv_logging > 0) {
            this.m_bean.dispatchErrorMessage(String.valueOf(timeStamp) + " " + errorStr, wuError);
        }
    }

    public String getTranslatedMessage(String msgName) {
        return this.m_bean.getMessageManager().getMessage(msgName, this.m_bean.getLocale());
    }

    public String getTranslatedMessage(String msgName, Object value1, Object value2, Object value3) {
        return this.m_bean.getMessageManager().getMessage(msgName, this.m_bean.getLocale(), value1, value2, value3);
    }

    public void setSrvLoggingOptions(int logOption) {
        this.srv_logging = logOption;
    }

    private static String createErrorIdent(String source, int wuError) {
        if (wuError < 100) {
            return "WUC-" + wuError;
        }
        return String.valueOf(source) + "-" + wuError;
    }
}

