/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;

public class Alert
extends JDialog
implements KeyListener {
    private JLabel m_icon = null;
    private JTextArea m_text = null;
    private JButton m_ok = null;
    private JPanel iconPanel = null;

    public Alert(Frame parent, String title, String okLabel, String msg) {
        super(parent, title, true);
        if (okLabel == null || okLabel.equalsIgnoreCase("")) {
            okLabel = "OK";
        }
        if (parent.getWidth() > 400 || parent.getWidth() < 150) {
            this.setSize(new Dimension(400, 120));
        } else {
            this.setSize(new Dimension(parent.getWidth(), 120));
        }
        this.setDefaultCloseOperation(2);
        UIDefaults defaults = UIManager.getDefaults();
        Container contents = this.getContentPane();
        contents.setBackground(defaults.getColor(LookAndFeel.DARK_LOOK));
        Color bgColor = contents.getBackground();
        this.setBackground(bgColor);
        contents.setLayout(new BorderLayout());
        this.setResizable(false);
        this.addKeyListener(this);
        this.m_icon = new JLabel(new ImageIcon(defaults.getImage((Object)"Alert.errorImage")));
        this.m_icon.setOpaque(false);
        this.m_icon.setEnabled(true);
        this.iconPanel = new JPanel();
        this.iconPanel.setBackground(bgColor);
        this.iconPanel.setLayout(new FlowLayout(1, 20, 10));
        this.iconPanel.add(this.m_icon);
        this.m_text = new JTextArea(msg);
        this.m_text.setBackground(bgColor);
        this.m_text.setMargin(new Insets(20, 10, 10, 10));
        this.m_text.setDisabledTextColor(new Color(0, 0, 0));
        this.m_text.setEnabled(false);
        this.m_text.setEditable(false);
        this.m_text.setLineWrap(true);
        this.m_text.setWrapStyleWord(true);
        this.m_text.setSize(this.getWidth() - 82, this.getHeight() - 50);
        this.setSize(this.getWidth(), (int)this.m_text.getPreferredSize().getHeight() + 70);
        this.centerIcon();
        this.m_ok = new JButton(okLabel);
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Alert.this.m_ok_actionPerformed(e);
            }
        });
        this.m_ok.addKeyListener(this);
        JPanel okPanel = new JPanel();
        okPanel.setBackground(bgColor);
        okPanel.setLayout(new FlowLayout());
        okPanel.add(this.m_ok);
        this.getContentPane().add("West", this.iconPanel);
        this.getContentPane().add("South", okPanel);
        this.getContentPane().add("Center", this.m_text);
        this.centerAlert(parent);
        this.setVisible(true);
    }

    private void m_ok_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void centerAlert(Window parent) {
        double loc_x = parent.getLocationOnScreen().getX() + (double)(parent.getWidth() / 2) - (double)(this.getWidth() / 2);
        double loc_y = parent.getLocationOnScreen().getY() + (double)(parent.getHeight() / 2) - (double)(this.getHeight() / 2);
        loc_x = loc_x > 0.0 ? loc_x : 0.0;
        loc_y = loc_y > 0.0 ? loc_y : 0.0;
        this.setLocation((int)loc_x, (int)loc_y);
    }

    private void centerIcon() {
        ((FlowLayout)this.iconPanel.getLayout()).setHgap(20);
        double iconHeight = this.m_icon.getPreferredSize().getHeight();
        int vgap = 10;
        if ((double)this.getHeight() > iconHeight + (double)80) {
            vgap = (this.getHeight() - (int)iconHeight - 60) / 2;
        }
        ((FlowLayout)this.iconPanel.getLayout()).setVgap(vgap);
    }

    public void dispose() {
        this.removeKeyListener(this);
        this.m_ok.removeKeyListener(this);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        } else if (e.getComponent().equals(this.m_ok) && e.getKeyCode() == 10) {
            this.setVisible(false);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }
}

