/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.clientInfo;

import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;

public class GetClientInfo
extends VBeanCommon {
    static final ID WUI_HOSTNAME = ID.registerProperty((String)"WUI_HOSTNAME");
    static final ID WUI_CLIENT_DATE = ID.registerProperty((String)"WUI_CLIENT_DATE");
    static final ID WUI_CLIENT_TZ = ID.registerProperty((String)"WUI_CLIENT_TZ");
    static final ID WUI_CLIENT_JAVA_VERSION = ID.registerProperty((String)"WUI_CLIENT_JAVA_VERSION");
    static final ID WUI_SYSTEM_PROPERTY = ID.registerProperty((String)"WUI_SYSTEM_PROPERTY");
    private String m_property = null;

    public void setBeanInfo() {
        this.setBeanName("WebUtil GetClientInfo Utility");
        this.setBeanShortName("WUI");
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUI_HOSTNAME) {
            this.getPropertyLogBefore(propName);
            result = this.getHostname();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUI_CLIENT_DATE) {
            this.getPropertyLogBefore(propName);
            result = this.getDate();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUI_CLIENT_JAVA_VERSION) {
            this.getPropertyLogBefore(propName);
            result = this.getSystemProperty("java.version");
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUI_CLIENT_TZ) {
            this.getPropertyLogBefore(propName);
            result = this.getSystemProperty("user.timezone");
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUI_SYSTEM_PROPERTY) {
            this.getPropertyLogBefore(propName);
            result = this.getSystemProperty(this.m_property);
            this.m_property = null;
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUI_SYSTEM_PROPERTY) {
            this.setPropertyLogBefore(propName, value);
            if (this.checkPLSQLString(value)) {
                this.m_property = (String)value;
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                result = false;
            }
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    private String getSystemProperty(String systemProperty) {
        this.log((byte)1, "getSystemProperty()", "Getting property: " + systemProperty);
        String result = null;
        if (systemProperty != null && systemProperty != "") {
            try {
                result = System.getProperty(systemProperty);
            }
            catch (AccessControlException ace) {
                this.error(306, "getSystemProperty()", this.getTranslatedMessage("ERROR306"));
                result = new String("");
            }
        }
        if (result == null) {
            this.error(304, "getSystemProperty()", this.getTranslatedMessage("ERROR304", systemProperty, null, null));
            result = new String("");
        }
        return result;
    }

    private String getHostname() {
        String host = null;
        if (this.getLocalHost() != null) {
            host = this.getLocalHost().getHostName();
            this.log((byte)1, "getHostName()", host);
        } else {
            this.error(301, "getHostName()", "Could not obtain Host Name");
            host = new String("");
        }
        return host;
    }

    public String getDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy M d HH:mm:ss");
        format.setCalendar(Calendar.getInstance());
        return format.format(format.getCalendar().getTime());
    }
}

