/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import java.util.StringTokenizer;
import oracle.forms.webutil.cApi.CApiFunctions;

public class CParameter {
    public static final int C_VOID = 30;
    public static final int C_CHAR = 31;
    public static final int C_SHORT = 32;
    public static final int C_INT = 33;
    public static final int C_LONG = 34;
    public static final int C_FLOAT = 35;
    public static final int C_DOUBLE = 36;
    public static final int C_PTR = 94;
    public static final int C_CHAR_PTR = 95;
    public static final int C_SHORT_PTR = 96;
    public static final int C_INT_PTR = 97;
    public static final int C_LONG_PTR = 98;
    public static final int C_FLOAT_PTR = 99;
    public static final int C_DOUBLE_PTR = 100;
    public static final int C_IN = 50;
    public static final int C_INOUT = 51;
    public static final int C_OUT = 52;
    private int m_Type;
    private int m_InOut;
    private String m_Value = null;
    private int m_MaxLen;
    private CApiFunctions m_bean = null;

    public CParameter(CApiFunctions bean) {
        this.m_bean = bean;
    }

    public static boolean isValidType(int typ) {
        return typ >= 30 && typ <= 36 || typ >= 94 && typ <= 100;
    }

    public boolean isOutOnly() {
        return this.m_InOut == 52;
    }

    public boolean isOut() {
        return this.m_InOut != 50;
    }

    public String getValue() {
        return this.m_Value;
    }

    public void setValue(String value) {
        if (this.m_Type == 95 && this.m_Value != null && this.m_Value.length() > this.m_MaxLen) {
            this.m_bean.error(915, "CParameter.setValue()", this.m_bean.getTranslatedMessage("ERROR915", null, null, null));
        }
        this.m_Value = value;
    }

    public void setType(String type) {
        try {
            int iType = Integer.parseInt(type);
            if (iType >= 30 && iType <= 100 && (iType <= 36 || iType >= 94)) {
                this.m_Type = iType;
            } else {
                this.m_bean.error(916, "CParameter.setType()", this.m_bean.getTranslatedMessage("ERROR916", type, null, null));
            }
        }
        catch (NumberFormatException nfe) {
            this.m_bean.error(916, "CParameter.setType()", this.m_bean.getTranslatedMessage("ERROR916", type, null, null));
        }
    }

    public void setInOut(String inOut) {
        try {
            int iInOut = Integer.parseInt(inOut);
            if (iInOut >= 50 && iInOut <= 52) {
                this.m_InOut = iInOut;
            } else {
                this.m_bean.error(937, "CParameter.setInOut()", this.m_bean.getTranslatedMessage("ERROR937", inOut, null, null));
            }
        }
        catch (NumberFormatException nfe) {
            this.m_bean.error(937, "CParameter.setInOut()", this.m_bean.getTranslatedMessage("ERROR937", inOut, null, null));
        }
    }

    public int getMaxLen() {
        return this.m_MaxLen;
    }

    public void setMaxLen(String maxLen) {
        try {
            int iMaxLen = Integer.parseInt(maxLen);
            if (iMaxLen > 32768 || iMaxLen < 0) {
                throw new NumberFormatException();
            }
            this.m_MaxLen = iMaxLen;
        }
        catch (NumberFormatException nfe) {
            this.m_bean.error(938, "CParameter.setMaxLen()", this.m_bean.getTranslatedMessage("ERROR938", maxLen, null, null));
        }
    }

    public int getType() {
        return this.m_Type;
    }

    public boolean setProperties(StringTokenizer st, boolean bind) {
        boolean result = true;
        try {
            if (bind) {
                this.setType(st.nextToken());
                this.setInOut(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.setMaxLen(st.nextToken());
            } else if (this.getType() == 95) {
                this.setMaxLen("32768");
            } else {
                this.setMaxLen("0");
            }
        }
        catch (Exception e) {
            result = false;
            this.m_bean.error(922, "CParameter.setProperties()", this.m_bean.getTranslatedMessage("ERROR922", null, null, null));
        }
        try {
            if (st.hasMoreTokens()) {
                this.setValue(st.nextToken());
            } else if (!this.isOutOnly()) {
                result = false;
                this.m_bean.error(923, "CParameter.setProperties()", this.m_bean.getTranslatedMessage("ERROR923"));
            } else {
                this.setValue("0");
            }
        }
        catch (Exception e) {
            result = false;
            this.m_bean.error(922, "CParameter.setProperties()", this.m_bean.getTranslatedMessage("ERROR922", e.toString(), null, null));
        }
        return result;
    }

    public static void main(String[] args) {
        CParameter cpar = new CParameter(null);
        StringTokenizer st = new StringTokenizer("33|51|100|abc");
        cpar.setProperties(st, false);
        st = new StringTokenizer("|100|xyzxyz");
        cpar.setProperties(st, false);
    }
}

