/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import java.util.Vector;
import oracle.forms.webutil.cApi.CApiFunctions;
import oracle.forms.webutil.cApi.CMalloc;
import oracle.forms.webutil.cApi.CParameter;

public class CParamList {
    static final int C_BYTE_LEN = 1;
    static final int C_DOUBLE_LEN = 8;
    static final int C_FLOAT_LEN = 4;
    static final int C_INT_LEN = 4;
    static final int C_LONG_LEN = 4;
    static final int C_SHORT_LEN = 2;
    static final int C_PTR_LEN = 4;
    static final byte SENTINEL = 85;
    private CApiFunctions m_bean = null;
    private Vector m_plist;

    public CParamList(CApiFunctions bean) {
        this.m_bean = bean;
        this.m_plist = new Vector();
    }

    public int numParams() {
        return this.m_plist.size();
    }

    public CParameter selectParameter(int idx) {
        return (CParameter)this.m_plist.elementAt(idx);
    }

    public int addParameter(CParameter cParm) {
        int parhnd = -1;
        try {
            this.m_plist.add(cParm);
            parhnd = this.m_plist.size() - 1;
        }
        catch (Exception e) {
            this.m_bean.error(939, "CParamList.addParamater()", this.m_bean.getTranslatedMessage("ERROR939", null, null, null));
        }
        return parhnd;
    }

    public Object[] toArray() {
        Vector<Object> parArr = new Vector<Object>();
        int numparams = this.m_plist.size();
        CMalloc ptr = null;
        block15: for (int i = 0; i < numparams; ++i) {
            CParameter par = (CParameter)this.m_plist.get(i);
            String value = par.getValue();
            if (par.isOutOnly() && value == null) {
                value = "0";
            }
            switch (par.getType()) {
                case 32: {
                    short tmpShort = Short.parseShort(value);
                    parArr.add(new Short(tmpShort));
                    continue block15;
                }
                case 31: {
                    char tmpChar = par.getValue().charAt(0);
                    parArr.add(new Character(tmpChar));
                    continue block15;
                }
                case 33: {
                    int tmpInt = Integer.parseInt(value);
                    parArr.add(new Integer(tmpInt));
                    continue block15;
                }
                case 34: {
                    long tmpLong = Long.parseLong(value);
                    parArr.add(new Long(tmpLong));
                    continue block15;
                }
                case 35: {
                    float tmpFloat = Float.parseFloat(value);
                    parArr.add(new Float(tmpFloat));
                    continue block15;
                }
                case 36: {
                    double tmpDouble = Double.parseDouble(value);
                    parArr.add(new Double(tmpDouble));
                    continue block15;
                }
                case 94: {
                    long tmpPtr = Long.parseLong(value);
                    parArr.add(new Long(tmpPtr));
                    continue block15;
                }
                case 95: {
                    int maxlen = par.getMaxLen();
                    if (value.length() > maxlen) {
                        this.m_bean.error(915, "CParamList.toArray()", this.m_bean.getTranslatedMessage("ERROR915", "", null, null));
                    }
                    ptr = new CMalloc(maxlen + 1 + 1);
                    ptr.setString(0, value);
                    ptr.setByte(maxlen + 1, (byte)85);
                    parArr.add(ptr);
                    continue block15;
                }
                case 96: {
                    ptr = new CMalloc(2);
                    ptr.setShort(0, Short.parseShort(value));
                    parArr.add(ptr);
                    continue block15;
                }
                case 97: {
                    ptr = new CMalloc(4);
                    ptr.setInt(0, Integer.parseInt(value));
                    parArr.add(ptr);
                    continue block15;
                }
                case 98: {
                    ptr = new CMalloc(4);
                    ptr.setLong(0, Long.parseLong(value));
                    parArr.add(ptr);
                    continue block15;
                }
                case 99: {
                    ptr = new CMalloc(4);
                    ptr.setFloat(0, Float.parseFloat(value));
                    parArr.add(ptr);
                    continue block15;
                }
                case 100: {
                    ptr = new CMalloc(8);
                    ptr.setDouble(0, Double.parseDouble(value));
                    parArr.add(ptr);
                    continue block15;
                }
                default: {
                    this.m_bean.error(916, "CParamList.toArray()", this.m_bean.getTranslatedMessage("ERROR916", "" + par.getType(), null, null));
                    continue block15;
                }
            }
        }
        return parArr.toArray();
    }

    public boolean fromArray(Object[] params) {
        boolean result = true;
        Object typ = null;
        Object inOut = null;
        Object value = null;
        Object maxstrlen = null;
        int numparams = this.m_plist.size();
        CMalloc ptr = null;
        if (numparams != params.length) {
            this.m_bean.error(940, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR940", null, null, null));
        }
        if (numparams == 0) {
            return true;
        }
        block9: for (int i = 0; i < numparams; ++i) {
            CParameter cPar = (CParameter)this.m_plist.get(i);
            if (!cPar.isOut()) continue;
            switch (cPar.getType()) {
                case 95: {
                    byte sentinel;
                    int maxLen = cPar.getMaxLen();
                    if (!(params[i] instanceof CMalloc)) {
                        this.m_bean.error(912, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR912", "", null, null));
                        result = false;
                    }
                    if ((sentinel = (ptr = (CMalloc)params[i]).getByte(maxLen + 1)) != 85) {
                        this.m_bean.error(913, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR913", "", null, null));
                        result = false;
                    }
                    cPar.setValue(ptr.getString(0));
                    ptr.free();
                    continue block9;
                }
                case 94: {
                    this.m_bean.error(917, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR917", "", null, null));
                    continue block9;
                }
                case 96: {
                    ptr = (CMalloc)params[i];
                    cPar.setValue("" + ptr.getShort(0));
                    ptr.free();
                    continue block9;
                }
                case 97: {
                    ptr = (CMalloc)params[i];
                    cPar.setValue("" + ptr.getInt(0));
                    ptr.free();
                    continue block9;
                }
                case 98: {
                    ptr = (CMalloc)params[i];
                    cPar.setValue("" + ptr.getLong(0));
                    ptr.free();
                    continue block9;
                }
                case 99: {
                    ptr = (CMalloc)params[i];
                    cPar.setValue("" + ptr.getFloat(0));
                    ptr.free();
                    continue block9;
                }
                case 100: {
                    ptr = (CMalloc)params[i];
                    cPar.setValue("" + ptr.getDouble(0));
                    ptr.free();
                    continue block9;
                }
                default: {
                    this.m_bean.error(914, "CApiFunctions.fetchOutParams()", this.m_bean.getTranslatedMessage("ERROR914", "", null, null));
                    result = false;
                    continue block9;
                }
            }
        }
        return result;
    }
}

