/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.forms.properties.ID;
import oracle.forms.webutil.cApi.CFunc;
import oracle.forms.webutil.cApi.CParamList;
import oracle.forms.webutil.cApi.CParameter;
import oracle.forms.webutil.cApi.CPtr;
import oracle.forms.webutil.common.VBeanCommon;

public class CApiFunctions
extends VBeanCommon {
    static final ID WUL_REGISTER_FUNCTION = ID.registerProperty((String)"WUL_REGISTER_FUNCTION");
    static final ID WUL_DEREGISTER_FUNCTION = ID.registerProperty((String)"WUL_DEREGISTER_FUNCTION");
    static final ID WUL_CREATE_PARAMLIST = ID.registerProperty((String)"WUL_CREATE_PARAMLIST");
    static final ID WUL_DESTROY_PARAMLIST = ID.registerProperty((String)"WUL_DESTROY_PARAMLIST");
    static final ID WUL_ADD_PARAMETER = ID.registerProperty((String)"WUL_ADD_PARAMETER");
    static final ID WUL_INVOKE = ID.registerProperty((String)"WUL_INVOKE");
    static final ID WUL_FUNCTION_SPEC = ID.registerProperty((String)"WUL_FUNCTION_SPEC");
    static final ID WUL_PARAM_PROPERTIES = ID.registerProperty((String)"WUL_PARAM_PROPERTIES");
    static final ID WUL_PARAM_VALUE = ID.registerProperty((String)"WUL_PARAM_VALUE");
    static final ID WUL_INVOKE_SPEC = ID.registerProperty((String)"WUL_INVOKE_SPEC");
    static final ID WUL_INVOKEONCE_SPEC = ID.registerProperty((String)"WUL_INVOKEONCE_SPEC");
    private int m_argID = -1;
    private Object m_obj = null;
    private String m_libName = "";
    private String m_funcName = "";
    private CFunc m_cfunc = null;
    private int m_returnType = -1;
    private String m_returnValue = "";
    private CParamList m_paramList = null;
    private int m_paramListHnd = -1;
    private String m_paramValue = "";
    private CParameter m_cpar = null;

    public void setBeanInfo() {
        this.setBeanName("WebUtil C API Functions");
        this.setBeanShortName("WUL");
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUL_CREATE_PARAMLIST) {
            this.getPropertyLogBefore(propName);
            result = "" + this.create_paramlist();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUL_ADD_PARAMETER) {
            this.getPropertyLogBefore(propName);
            result = "" + this.add_parameter();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUL_REGISTER_FUNCTION) {
            this.getPropertyLogBefore(propName);
            result = this.register_function();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUL_INVOKE) {
            this.getPropertyLogBefore(propName);
            result = this.invokeCApi();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUL_PARAM_VALUE) {
            this.getPropertyLogBefore(propName);
            result = this.fetch_paramval();
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUL_PARAM_PROPERTIES) {
            this.setPropertyLogBefore(propName, value);
            if (this.checkPLSQLString(value)) {
                this.setParamProperties((String)value);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                result = false;
            }
        } else if (id == WUL_INVOKE_SPEC) {
            this.setPropertyLogBefore(propName, value);
            if (this.checkPLSQLString(value)) {
                result = this.set_invokespec((String)value);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                result = false;
            }
        } else if (id == WUL_INVOKEONCE_SPEC) {
            this.setPropertyLogBefore(propName, value);
            if (this.checkPLSQLString(value)) {
                result = this.set_invokeoncespec((String)value);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                result = false;
            }
        } else if (id == WUL_FUNCTION_SPEC) {
            this.setPropertyLogBefore(propName, value);
            if (this.checkPLSQLString((String)value)) {
                result = this.set_funcSpec((String)value);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                result = false;
            }
        } else if (id == WUL_DESTROY_PARAMLIST) {
            this.setPropertyLogBefore(propName, value);
            result = this.destroy_paramlist(this.defaultNullPropertyValue(value, null));
        } else if (id == WUL_DEREGISTER_FUNCTION) {
            this.setPropertyLogBefore(propName, value);
            result = this.deregister_function(this.defaultNullPropertyValue(value, null));
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    private boolean set_funcSpec(String funcspec) {
        StringTokenizer st = new StringTokenizer(funcspec, "|");
        return this.parse_funcSpec(st);
    }

    private boolean parse_funcSpec(StringTokenizer st) {
        boolean result = false;
        try {
            this.m_libName = st.nextToken();
            this.m_funcName = st.nextToken();
            result = true;
        }
        catch (Exception e) {
            this.error(924, "CApiFunctions.parse_funcspec()", this.getTranslatedMessage("ERROR924", "", null, null));
        }
        return result;
    }

    private boolean parse_funcHnd(StringTokenizer st) {
        boolean result = false;
        String funcHnd = "";
        try {
            funcHnd = st.nextToken();
            if (this.setHandle(funcHnd)) {
                if (this.m_obj instanceof CFunc) {
                    this.m_cfunc = (CFunc)this.m_obj;
                    result = true;
                } else {
                    this.error(925, "CApiFunctions.parse_funcHnd()", this.getTranslatedMessage("ERROR925", "CFunc", null, null));
                }
            } else {
                this.error(926, "CApiFunctions.parse_funcHnd()", this.getTranslatedMessage("ERROR926", funcHnd, null, null));
            }
        }
        catch (Exception e) {
            this.error(927, "CApiFunctions.parse_funcHnd()", this.getTranslatedMessage("ERROR927", "funcHnd", null, null));
        }
        return result;
    }

    private boolean parse_paramListHnd(StringTokenizer st) {
        boolean result = false;
        String paramListHnd = "";
        try {
            paramListHnd = st.nextToken();
            if (paramListHnd.equalsIgnoreCase("(null)")) {
                this.m_paramListHnd = -1;
                this.m_paramList = null;
                result = true;
            } else if (this.setHandle(paramListHnd)) {
                this.m_paramListHnd = this.m_argID;
                if (this.m_obj instanceof CParamList) {
                    this.m_paramList = (CParamList)this.m_obj;
                    result = true;
                } else {
                    this.error(925, "CApiFunctions.parse_paramListHnd()", this.getTranslatedMessage("ERROR925", "paramListHnd", null, null));
                }
            } else {
                this.error(926, "CApiFunctions.parse_paramListHnd()", this.getTranslatedMessage("ERROR926", paramListHnd, null, null));
            }
        }
        catch (Exception e) {
            this.error(927, "CApiFunctions.parse_paramListHnd()", this.getTranslatedMessage("ERROR927", "paramListHnd", null, null));
        }
        return result;
    }

    private boolean parse_returnType(StringTokenizer st) {
        boolean result = true;
        String returnType = "";
        try {
            returnType = st.nextToken();
            this.m_returnType = Integer.parseInt(returnType);
            if (!CParameter.isValidType(this.m_returnType)) {
                result = false;
                this.m_returnType = -1;
                this.error(911, "CApiFunctions.parse_returnType()", this.getTranslatedMessage("ERROR911", returnType, null, null));
            }
        }
        catch (Exception e) {
            result = false;
            this.error(927, "CApiFunctions.parse_returnType()", this.getTranslatedMessage("ERROR927", "returnType", null, null));
        }
        return result;
    }

    private boolean set_invokespec(String invokespec) {
        boolean result = false;
        StringTokenizer st = new StringTokenizer(invokespec, "|");
        result = this.parse_funcHnd(st) && this.parse_paramListHnd(st) && this.parse_returnType(st);
        return result;
    }

    private boolean set_invokeoncespec(String invokeoncespec) {
        boolean result = false;
        StringTokenizer st = new StringTokenizer(invokeoncespec, "|");
        boolean bl = result = this.parse_funcSpec(st) && this.parse_paramListHnd(st) && this.parse_returnType(st);
        if (result) {
            try {
                this.m_cfunc = new CFunc(this.m_libName, this.m_funcName);
            }
            catch (UnsatisfiedLinkError ule) {
                result = false;
                this.error(928, "CApiFunctions.set_invokeoncespec()", this.getTranslatedMessage("ERROR928", this.m_libName, this.m_funcName, null));
            }
            catch (Exception e) {
                result = false;
                this.error(928, "CApiFunctions.set_invokeoncespec()", this.getTranslatedMessage("ERROR928", this.m_libName, this.m_funcName, null));
            }
        }
        return result;
    }

    private int create_paramlist() {
        try {
            this.m_paramList = new CParamList(this);
            this.m_paramListHnd = this.storeInObjectCache(this.m_paramList);
        }
        catch (Exception e) {
            this.error(901, "CApiFunctions.create_paramlist()", this.getTranslatedMessage("ERROR901", e.toString(), null, null));
            this.m_paramListHnd = -1;
            this.m_paramList = null;
        }
        return this.m_paramListHnd;
    }

    private boolean destroy_paramlist(String handle) {
        boolean result = false;
        if (this.setHandle(handle)) {
            if (this.m_obj instanceof CParamList) {
                try {
                    this.eraseFromObjectCache(this.m_argID);
                    result = true;
                }
                catch (Exception e) {
                    this.error(902, "CApiFunctions.destroy_paramlist()", this.getTranslatedMessage("ERROR902", e.toString(), null, null));
                }
            } else {
                this.error(12, "CApiFunctions.destroy_paramlist()", this.getTranslatedMessage("ERROR012", "CParamList", null, null));
            }
        }
        this.m_argID = -1;
        this.m_obj = null;
        this.m_paramListHnd = -1;
        this.m_paramList = null;
        return result;
    }

    private boolean setParamProperties(String propcombo) {
        boolean result = true;
        StringTokenizer st = new StringTokenizer(propcombo, "|");
        boolean bind = false;
        String action = st.nextToken();
        if (action.compareTo("B") == 0) {
            bind = true;
        } else if (action.compareTo("R") == 0 || action.compareTo("F") == 0) {
            bind = false;
        } else {
            this.error(929, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR929", action, null, null));
            return false;
        }
        if (bind) {
            this.m_cpar = new CParameter(this);
        }
        try {
            String parlisthnd = st.nextToken();
            if (this.select_paramlist(parlisthnd)) {
                String parhnd;
                if (!bind && !this.select_parameter(parhnd = st.nextToken())) {
                    this.error(930, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR930", parlisthnd, parhnd, null));
                }
                if (action.compareTo("B") == 0 || action.compareTo("R") == 0) {
                    result = this.m_cpar.setProperties(st, bind);
                }
            } else {
                this.error(931, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR931", parlisthnd, null, null));
            }
        }
        catch (Exception e) {
            this.error(932, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR932", e.toString(), null, null));
        }
        return result;
    }

    private String add_parameter() {
        String result = null;
        if (this.m_paramList != null) {
            try {
                result = "" + this.m_paramList.addParameter(this.m_cpar);
            }
            catch (Exception e) {
                this.error(903, "CApiFunctions.add_parameter()", this.getTranslatedMessage("ERROR903", e.toString(), null, null));
                result = null;
            }
        } else {
            this.error(933, "CApiFunctions.add_parameter()", this.getTranslatedMessage("ERROR933", "", null, null));
        }
        return result;
    }

    private String fetch_paramval() {
        String result = null;
        if (this.m_cpar != null) {
            try {
                result = this.m_cpar.getValue();
            }
            catch (Exception e) {
                this.error(907, "CApiFunctions.fetch_paramval()", this.getTranslatedMessage("ERROR907", e.toString(), null, null));
            }
        } else {
            this.error(934, "CApiFunctions.fetch_paramval()", this.getTranslatedMessage("ERROR934", "", null, null));
        }
        return result;
    }

    private boolean select_paramlist(String parlisthnd) {
        boolean result = false;
        if (this.setHandle(parlisthnd)) {
            this.m_paramListHnd = this.m_argID;
            if (this.m_obj instanceof CParamList) {
                this.m_paramList = (CParamList)this.m_obj;
                result = true;
            } else {
                this.error(925, "CApiFunctions.select_paramlist()", this.getTranslatedMessage("ERROR925", "CParamList", null, null));
            }
        } else {
            this.error(926, "CApiFunctions.fetch_paramval()", this.getTranslatedMessage("ERROR926", parlisthnd, null, null));
        }
        return result;
    }

    private boolean select_parameter(String parhnd) {
        boolean result = false;
        int paridx = -1;
        try {
            paridx = Integer.parseInt(parhnd);
            if (this.m_paramList == null || paridx < 0 || paridx > this.m_paramList.numParams() - 1) {
                this.error(935, "CApiFunctions.select_parameter()", this.getTranslatedMessage("ERROR935", "", null, null));
            } else {
                this.m_cpar = this.m_paramList.selectParameter(paridx);
                result = true;
            }
        }
        catch (Exception e) {
            this.error(932, "CApiFunctions.select_parameter()", this.getTranslatedMessage("ERROR932", e.toString(), null, null));
        }
        return result;
    }

    private Object register_function() {
        String funcHnd = null;
        if (this.m_libName == "" || this.m_libName == null || this.m_funcName == "" || this.m_funcName == null) {
            this.error(936, "CApiFunctions.register_function()", this.getTranslatedMessage("ERROR936", this.m_libName, this.m_funcName, null));
        } else {
            try {
                this.m_cfunc = new CFunc(this.m_libName, this.m_funcName);
                funcHnd = "" + this.storeInObjectCache(this.m_cfunc);
            }
            catch (UnsatisfiedLinkError ule) {
                this.error(928, "CApiFunctions.register_function()", this.getTranslatedMessage("ERROR928", this.m_libName, this.m_funcName, null));
            }
            catch (Exception e) {
                this.error(908, "CApiFunctions.register_function()", this.getTranslatedMessage("ERROR908", String.valueOf(this.m_libName) + ':' + this.m_funcName, null, null));
            }
        }
        return funcHnd;
    }

    private boolean deregister_function(String handle) {
        boolean result = false;
        if (this.setHandle(handle)) {
            if (this.m_obj instanceof CFunc) {
                try {
                    this.eraseFromObjectCache(this.m_argID);
                    this.m_argID = -1;
                    this.m_obj = null;
                    result = true;
                }
                catch (Exception e) {
                    this.error(909, "CApiFunctions.deregister_function()", this.getTranslatedMessage("ERROR909", e.toString(), null, null));
                    result = false;
                }
            } else {
                this.error(12, "CApiFunctions.deregister_function()", this.getTranslatedMessage("ERROR012", "String", null, null));
                result = false;
            }
        }
        return result;
    }

    private String invokeCApi() {
        boolean result = false;
        Object[] params = null;
        try {
            int intResult = 0;
            float floatResult = 0.0f;
            double doubleResult = 0.0;
            CPtr charptrResult = null;
            this.m_returnValue = "";
            params = this.m_paramList != null ? this.m_paramList.toArray() : new Vector().toArray();
            switch (this.m_returnType) {
                case 30: {
                    this.m_cfunc.callVoid(params);
                    this.m_returnValue = "";
                    break;
                }
                case 33: {
                    intResult = this.m_cfunc.callInt(params);
                    this.m_returnValue = "" + intResult;
                    break;
                }
                case 35: {
                    floatResult = this.m_cfunc.callFloat(params);
                    this.m_returnValue = "" + floatResult;
                    break;
                }
                case 36: {
                    doubleResult = this.m_cfunc.callDouble(params);
                    this.m_returnValue = "" + doubleResult;
                    break;
                }
                case 95: {
                    charptrResult = this.m_cfunc.callCPtr(params);
                    this.m_returnValue = charptrResult.getString(0);
                    break;
                }
                case 94: {
                    charptrResult = this.m_cfunc.callCPtr(params);
                    this.m_returnValue = "" + charptrResult;
                    break;
                }
                default: {
                    this.error(911, "CApiFunctions.invokeCApi()", this.getTranslatedMessage("ERROR911", "", "" + this.m_returnType, null));
                }
            }
            if (this.m_paramList != null) {
                result = this.m_paramList.fromArray(params);
            }
        }
        catch (Exception e) {
            this.error(910, "CApiFunctions.invokeCApi()", this.getTranslatedMessage("ERROR910", e.toString(), null, null));
            result = false;
        }
        return this.m_returnValue;
    }

    private boolean setHandle(String handle) {
        boolean result = false;
        int handle_id = -1;
        try {
            handle_id = Integer.parseInt(handle);
            if (handle_id < 0) {
                throw new NumberFormatException();
            }
            Object ob = this.getFromObjectCache(handle_id);
            this.m_argID = handle_id;
            this.m_obj = ob;
            result = true;
        }
        catch (NumberFormatException nfe) {
            this.error(904, "CApiFunctions.setHandle()", this.getTranslatedMessage("ERROR904", handle, null, null));
        }
        catch (NullPointerException npe) {
            this.error(905, "CApiFunctions.setHandle()", this.getTranslatedMessage("ERROR905", handle, null, null));
        }
        return result;
    }

    public static void main(String[] args) {
        CApiFunctions capi = new CApiFunctions();
        String paramListHnd = null;
        Object paramHnd = null;
        String paramHnd1 = null;
        String paramHnd2 = null;
        String s = "hello world";
        int l = 0;
        Object funcHnd = null;
        paramListHnd = (String)capi.getProperty(WUL_CREATE_PARAMLIST);
        s = "qweaaaaaaaaaaaaaaaaaaaaaaaaaaaaxyz";
        capi.setProperty(WUL_PARAM_PROPERTIES, "B|" + paramListHnd + "|" + 95 + "|" + 51 + "|" + s.length() + "|" + s);
        paramHnd1 = (String)capi.getProperty(WUL_ADD_PARAMETER);
        l = s.length();
        capi.setProperty(WUL_PARAM_PROPERTIES, "B|" + paramListHnd + "|" + 97 + "|" + 51 + "|" + 0 + "|" + l);
        paramHnd2 = (String)capi.getProperty(WUL_ADD_PARAMETER);
        capi.setProperty(WUL_INVOKEONCE_SPEC, "testwebutil.dll|PopulateString|" + paramListHnd + "|" + 33);
        s = (String)capi.getProperty(WUL_INVOKE);
        capi.setProperty(WUL_PARAM_PROPERTIES, "F|" + paramListHnd + '|' + paramHnd1);
        s = (String)capi.getProperty(WUL_PARAM_VALUE);
        capi.setProperty(WUL_PARAM_PROPERTIES, "F|" + paramListHnd + '|' + paramHnd2);
        l = Integer.parseInt((String)capi.getProperty(WUL_PARAM_VALUE));
        capi.setProperty(WUL_DESTROY_PARAMLIST, paramListHnd);
        capi.setProperty(WUL_INVOKEONCE_SPEC, "testwebutil.dll|fifteen|(null)|33");
        s = (String)capi.getProperty(WUL_INVOKE);
    }

    public void destroy() {
        super.destroy();
        System.gc();
    }
}

