/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.browser;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import oracle.forms.engine.Main;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;

public class BrowserFunctions
extends VBeanCommon {
    private static final ID WUB_SHOWMENUBAR = ID.registerProperty((String)"WUB_SHOWMENUBAR");
    private static final ID WUB_SHOWSTATUSBAR = ID.registerProperty((String)"WUB_SHOWSTATUSBAR");
    private static final ID WUB_SEPARATEFRAME_TITLE = ID.registerProperty((String)"WUB_SEPARATEFRAME_TITLE");
    private static final ID WUB_SEPARATEFRAME_RESIZABLE = ID.registerProperty((String)"WUB_SEPARATEFRAME_RESIZABLE");
    private static final ID WUB_SEPARATEFRAME_CENTER = ID.registerProperty((String)"WUB_SEPARATEFRAME_CENTER");
    private static final ID WUB_SEPARATEFRAME_ICON = ID.registerProperty((String)"WUB_SEPARATEFRAME_ICON");
    private static final ID WUB_BROWSER_MESSAGE = ID.registerProperty((String)"WUB_BROWSER_MESSAGE");
    private static final ID WUB_SEPARATEFRAME_MODE = ID.registerProperty((String)"WUB_SEPARATEFRAME_MODE");
    private static final ID WUB_APPLET_SIZE = ID.registerProperty((String)"WUB_APPLET_SIZE");
    private static final ID WUB_APPLET_PARAMETER = ID.registerProperty((String)"WUB_APPLET_PARAMETER");
    private boolean m_separateFrame = false;
    private boolean m_useCodeBase = false;
    private Main m_formsApplet = null;
    private String m_property = null;

    public void setBeanInfo() {
        this.setBeanName("WebUtil Browser Functions");
        this.setBeanShortName("WUB");
    }

    public void init(IHandler handler) {
        super.init(handler);
        this.m_separateFrame = "TRUE".equalsIgnoreCase(handler.getApplet().getParameter("separateFrame"));
        this.m_useCodeBase = "CODEBASE".equalsIgnoreCase(handler.getApplet().getParameter("ImageBase"));
        this.m_formsApplet = (Main)handler.getApplet();
    }

    public boolean setProperty(ID id, Object value) {
        boolean result = true;
        this.setErrorCondition(0);
        String propName = id.getName();
        if (id == WUB_SHOWMENUBAR) {
            this.setPropertyLogBefore(propName, value);
            result = this.showMenuBar(this.defaultNullPropertyValue(value, "TRUE"));
        } else if (id == WUB_SHOWSTATUSBAR) {
            this.setPropertyLogBefore(propName, value);
            result = this.showStatusBar(this.defaultNullPropertyValue(value, "TRUE"));
        } else if (id == WUB_SEPARATEFRAME_TITLE) {
            this.setPropertyLogBefore(propName, value);
            result = this.setSeparateFrameTitle(this.defaultNullPropertyValue(value, ""));
        } else if (id == WUB_SEPARATEFRAME_RESIZABLE) {
            this.setPropertyLogBefore(propName, value);
            result = this.setSeparateFrameResizable(this.defaultNullPropertyValue(value, "TRUE"));
        } else if (id == WUB_SEPARATEFRAME_CENTER) {
            this.setPropertyLogBefore(propName, value);
            result = this.centerSeparateFrame(this.defaultNullPropertyValue(value, "TRUE"));
        } else if (id == WUB_SEPARATEFRAME_ICON) {
            this.setPropertyLogBefore(propName, value);
            result = this.setSeparateFrameIcon(this.defaultNullPropertyValue(value, null));
        } else if (id == WUB_BROWSER_MESSAGE) {
            this.setPropertyLogBefore(propName, value);
            this.message(this.safePrint(value));
        } else if (id == WUB_APPLET_PARAMETER) {
            this.setPropertyLogBefore(propName, value);
            this.m_property = this.defaultNullPropertyValue(value, null);
        } else {
            result = super.setProperty(id, value);
        }
        return result;
    }

    public Object getProperty(ID id) {
        Object result = null;
        if (id != VBeanCommon.WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String propName = id.getName();
        if (id == WUB_SEPARATEFRAME_MODE) {
            this.getPropertyLogBefore(propName);
            result = this.m_separateFrame ? "TRUE" : "FALSE";
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUB_APPLET_SIZE) {
            this.getPropertyLogBefore(propName);
            result = this.getAppletSize();
            this.getPropertyLogAfter(propName, result);
        } else if (id == WUB_APPLET_PARAMETER) {
            this.getPropertyLogBefore(propName);
            result = this.getAppletParam(this.m_property);
            this.m_property = null;
            this.getPropertyLogAfter(propName, result);
        } else {
            result = super.getProperty(id);
        }
        return result;
    }

    private boolean showMenuBar(String showBar) {
        boolean state;
        boolean bl = state = !"FALSE".equalsIgnoreCase(showBar);
        if (this.m_formsApplet.getMDIContainer().getDefaultMenuBar() != null) {
            this.m_formsApplet.getMDIContainer().getDefaultMenuBar().setVisible(state);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.showMenuBar()", "No default menu bar found");
        }
        return true;
    }

    private boolean showStatusBar(String showBar) {
        boolean state;
        boolean bl = state = !"FALSE".equalsIgnoreCase(showBar);
        if (this.m_formsApplet.getMDIContainer().getDefaultStatusBar() != null) {
            this.m_formsApplet.getMDIContainer().getDefaultStatusBar().setVisible(state);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.showMenuBar()", "No default status bar found");
        }
        return true;
    }

    private boolean setSeparateFrameTitle(String title) {
        if (this.m_separateFrame) {
            this.getFrame().setTitle(title);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.setSeparateFrameTitle()", "Not running in separateFrame - can't change frame title");
        }
        return true;
    }

    private boolean setSeparateFrameIcon(String iconName) {
        boolean result = false;
        Image icon = null;
        URL iconLocation1 = null;
        URL iconLocation2 = null;
        URL iconLoaded = null;
        if (this.m_separateFrame) {
            if (iconName != null && !iconName.equals("")) {
                ImageIcon image;
                if (this.m_useCodeBase) {
                    if (this.isLogging()) {
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "Searching Codebase for icon");
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "CODEBASE=" + this.m_formsApplet.getCodeBase().toString());
                    }
                    try {
                        iconLocation1 = new URL(this.m_formsApplet.getCodeBase(), iconName);
                        image = new ImageIcon(iconLocation1);
                        if (image.getImageLoadStatus() == 4) {
                            icon = null;
                        } else {
                            icon = image.getImage();
                            iconLoaded = iconLocation1;
                        }
                    }
                    catch (MalformedURLException mue) {
                        this.error(600, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR600"));
                    }
                }
                if (icon == null) {
                    if (this.isLogging()) {
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "Searching DocumentBase for icon");
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "DOCUMENTBASE=" + this.m_formsApplet.getDocumentBase().toString());
                    }
                    try {
                        iconLocation2 = new URL(this.m_formsApplet.getDocumentBase(), iconName);
                        image = new ImageIcon(iconLocation2);
                        if (image.getImageLoadStatus() == 4) {
                            icon = null;
                        } else {
                            icon = image.getImage();
                            iconLoaded = iconLocation2;
                        }
                    }
                    catch (MalformedURLException mue2) {
                        this.error(601, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR601"));
                    }
                }
                if (icon != null) {
                    this.getFrame().setIconImage(icon);
                    result = true;
                    this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "Loaded icon image " + iconLoaded.toString());
                } else if (iconLocation1 != null && !iconLocation1.equals(iconLocation2)) {
                    this.error(603, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR603", String.valueOf(iconLocation1.toString()) + " or " + iconLocation2.toString(), null, null));
                } else {
                    this.error(603, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR603", iconLocation2.toString(), null, null));
                }
            } else {
                this.error(602, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR602"));
            }
        } else {
            if (this.isLogging()) {
                this.log((byte)0, "BrowserFunctions.setSeparateFrameIcon()", "Not running in separateFrame - Icon not set");
            }
            result = true;
        }
        return result;
    }

    private boolean centerSeparateFrame(String nudgeY) {
        if (this.m_separateFrame) {
            int fudgeY = 0;
            try {
                fudgeY = Integer.parseInt(nudgeY);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.getFrame().getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.getFrame().setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 + fudgeY);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.centerSeparateFrame()", "Not running in separateFrame - Center command ignored");
        }
        return true;
    }

    private boolean setSeparateFrameResizable(String allowResize) {
        if (this.m_separateFrame) {
            this.getFrame().setResizable(!"FALSE".equalsIgnoreCase(allowResize));
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.setSeparateFrameResizable()", "Not running in separateFrame - can't change frame attributes");
        }
        return true;
    }

    private String getAppletSize() {
        return "" + this.m_formsApplet.getMDIContainer().getWidth() + "," + this.m_formsApplet.getMDIContainer().getHeight();
    }

    public String getAppletParam(String paramName) {
        String result = null;
        result = paramName != null ? this.m_formsApplet.getParameter(paramName) : new String("");
        return result;
    }
}

