/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.demos.enhancedItems;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.forms.properties.ID;
import oracle.forms.ui.VButton;

public class InfoButton
extends VButton {
    public static final ID INFOBUTTON_FIELDPOS = ID.registerProperty((String)"INFOBUTTON_FIELDPOS");
    public static final ID INFOBUTTON_TEXT = ID.registerProperty((String)"INFOBUTTON_TEXT");
    private static final ID DEBUGMESSAGES = ID.registerProperty((String)"DEBUGMESSAGES");
    private static final ID DEBUGMESSAGES_ALL = ID.registerProperty((String)"DEBUGMESSAGES_ALL");
    private final String CLASSNAME = this.getDefaultName();
    private LWCommonText m_infoField;
    private boolean m_isFound = false;
    private InfoButtonMouseAdapter m_mouseAdapter;
    private String m_text;
    private String m_savedText;
    private boolean m_debug = false;
    private static boolean m_debugAll = false;

    public InfoButton() {
        this.log("Debugging on: Creating Button Instance");
    }

    public boolean setProperty(ID iD, Object object) {
        if (iD == ID.LABEL) {
            this.log("Setting Label to " + object.toString());
            String string = object.toString().trim();
            if (string.startsWith("(")) {
                this.log("Rounding left edge of " + string);
                this.setLeftmost(true);
                string = string.substring(1);
            }
            if (string.endsWith(")")) {
                this.log("Rounding right edge of " + string);
                this.setRightmost(true);
                string = string.substring(0, string.length() - 1);
            }
            return super.setProperty(iD, (Object)string);
        }
        if (iD == INFOBUTTON_TEXT) {
            this.m_text = object.toString();
            return true;
        }
        if (iD == INFOBUTTON_FIELDPOS) {
            this.log("Setting FieldPos to " + object.toString());
            int n = object.toString().indexOf(",");
            if (n > 0) {
                int n2 = Integer.parseInt(object.toString().substring(0, n));
                int n3 = Integer.parseInt(object.toString().substring(n + 1));
                this.defineInfoField(new Point(n2, n3));
            }
            return true;
        }
        if (iD == DEBUGMESSAGES) {
            this.m_debug = object.toString().equalsIgnoreCase("true");
            this.log("Debugging " + this.m_debug);
            return true;
        }
        if (iD == DEBUGMESSAGES_ALL) {
            m_debugAll = object.toString().equalsIgnoreCase("true");
            this.log("Debugging " + m_debugAll);
            return true;
        }
        return super.setProperty(iD, object);
    }

    private void defineInfoField(Point point) {
        this.log("Searching for Info field at " + point.toString());
        Container container = ((Component)((Object)this)).getParent();
        Component component = container.getComponentAt(point);
        if (component instanceof LWCommonText) {
            this.log("Found TextField");
            this.m_infoField = (LWCommonText)component;
            this.m_isFound = true;
        } else {
            Container container2 = (Container)component;
            if ((component = container2.getComponent(0)) instanceof LWCommonText) {
                this.log("Found TextArea");
                this.m_infoField = (LWCommonText)component;
                this.m_isFound = true;
            } else {
                this.log("Error: Unable to find suitable Text Item to write to");
                this.m_isFound = false;
            }
        }
        if (this.m_mouseAdapter == null) {
            this.log("Creating mouse adaptor");
            this.m_mouseAdapter = new InfoButtonMouseAdapter();
            ((Component)((Object)this)).addMouseListener(this.m_mouseAdapter);
        }
    }

    public void log(String string) {
        if (this.m_debug || m_debugAll) {
            System.out.println(this.CLASSNAME + ": " + string);
        }
    }

    class InfoButtonMouseAdapter
    extends MouseAdapter {
        InfoButtonMouseAdapter() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((Component)((Object)InfoButton.this)).setCursor(new Cursor(12));
            if (InfoButton.this.m_isFound) {
                InfoButton.this.m_savedText = InfoButton.this.m_infoField.getText();
                InfoButton.this.m_infoField.setText(InfoButton.this.m_text);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (InfoButton.this.m_isFound) {
                InfoButton.this.m_infoField.setText(InfoButton.this.m_savedText);
            }
        }
    }
}

