/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.demos.beans;

import java.awt.image.BufferedImage;
import java.net.InetAddress;
import java.text.DateFormat;
import java.util.Calendar;
import oracle.forms.demos.beans.CBarcodeReader;
import oracle.forms.demos.beans.CImage;
import oracle.forms.demos.beans.MySimple;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.ui.VBean;

public class GetClientInfo
extends VBean {
    private final String CLASSNAME = ((Object)((Object)this)).getClass().getName();
    static final ID CLIENTDATE;
    static final ID CLIENT_JAVA_VERSION;
    private final String DEFAULTMESSAGE = "NOT AVAILABLE";
    static final ID HOSTNAME;
    static final ID IMGSCAN;
    static final ID IPADDRESS;
    static final ID LDATA;
    static final ID RDATA;
    static final ID USERNAME;
    private boolean m_debug = false;
    IHandler m_handler = null;
    private InetAddress m_localhost = null;

    static {
        USERNAME = ID.registerProperty((String)"USERNAME");
        HOSTNAME = ID.registerProperty((String)"HOSTNAME");
        IPADDRESS = ID.registerProperty((String)"IPADDRESS");
        CLIENTDATE = ID.registerProperty((String)"CLIENTDATE");
        CLIENT_JAVA_VERSION = ID.registerProperty((String)"CLIENT_JAVA_VERSION");
        IMGSCAN = ID.registerProperty((String)"IMGSCAN");
        LDATA = ID.registerProperty((String)"LDATA");
        RDATA = ID.registerProperty((String)"RDATA");
    }

    public void GetClientInfo() {
        this.log("constructing GetClientInfo object");
    }

    private void findLocalHost() {
        if (this.m_localhost == null) {
            try {
                this.log("obtaining LocalHost info from InetAddress");
                this.m_localhost = InetAddress.getLocalHost();
            }
            catch (Exception e) {
                this.log("ERROR obtaining LocalHost info from InetAddress");
                e.printStackTrace();
            }
        }
    }

    public String getDATE() {
        DateFormat format = DateFormat.getDateInstance(0);
        format.setCalendar(Calendar.getInstance());
        return format.format(format.getCalendar().getTime());
    }

    public boolean getDebug() {
        this.log("getDebug()");
        return this.m_debug;
    }

    public String getHOSTNAME() {
        this.findLocalHost();
        if (this.m_localhost != null) {
            return this.m_localhost.getHostName();
        }
        return "NOT AVAILABLE";
    }

    public String getIMGSCAN() {
        MySimple m = new MySimple();
        return m.getImage();
    }

    public String getIPADDRESS() {
        this.findLocalHost();
        if (this.m_localhost != null) {
            return this.m_localhost.getHostAddress();
        }
        return "NOT AVAILABLE";
    }

    public String getLDATA() {
        CImage image = new CImage("c:\\temp.jpg");
        CBarcodeReader reader1 = new CBarcodeReader();
        reader1.setImage((BufferedImage)image.getDNBarcodeImage());
        reader1.obtainSequence();
        String retStr = reader1.getData();
        return retStr;
    }

    public Object getProperty(ID pid) {
        this.log("getProperty(" + this.getPropertyName(pid) + ")");
        if (pid == USERNAME) {
            return this.getUSERNAME();
        }
        if (pid == HOSTNAME) {
            return this.getHOSTNAME();
        }
        if (pid == IPADDRESS) {
            return this.getIPADDRESS();
        }
        if (pid == CLIENTDATE) {
            return this.getDATE();
        }
        if (pid == IMGSCAN) {
            return this.getIMGSCAN();
        }
        if (pid == LDATA) {
            return this.getLDATA();
        }
        if (pid == RDATA) {
            return this.getRDATA();
        }
        if (pid == CLIENT_JAVA_VERSION) {
            return this.getSystemProperty("java.version");
        }
        return super.getProperty(pid);
    }

    private String getPropertyName(ID pid) {
        try {
            return pid.getName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRDATA() {
        CImage image = new CImage("c:\\temp.jpg");
        CBarcodeReader reader = new CBarcodeReader();
        reader.setImage((BufferedImage)image.getCNBarcodeImage());
        reader.obtainSequence();
        String retStr = reader.getData();
        return retStr;
    }

    public String getSystemProperty(String systemProperty) {
        this.log("getSystemProperty(" + systemProperty + ")");
        return System.getProperty(systemProperty);
    }

    public String getUSERNAME() {
        return System.getProperty("user.name");
    }

    public void init(IHandler handler) {
        this.log("init()");
        this.m_handler = handler;
        this.findLocalHost();
    }

    public void log(String msg) {
        if (this.m_debug) {
            System.out.println(this.CLASSNAME + ": " + msg);
        }
    }

    public static void main(String[] args) {
        System.out.println("Running GetClientInfo()");
        GetClientInfo ci = new GetClientInfo();
        ci.findLocalHost();
        System.out.println("Username : " + ci.getUSERNAME());
        System.out.println("Hostname : " + ci.getHOSTNAME());
        System.out.println("IP       : " + ci.getIPADDRESS());
        System.out.println("Date     : " + ci.getDATE());
        System.out.println("LDATA     : " + ci.getLDATA());
        System.out.println("RDATA     : " + ci.getRDATA());
    }

    public void setDebug(boolean debugMode) {
        this.log("setDebug(" + debugMode + ")");
        this.m_debug = debugMode;
    }
}

