/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.demos.beans;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class CBarcodeReader {
    private boolean m_bHasData = false;
    private int m_iHeight;
    private int m_iWidth;
    private BufferedImage m_imageBarCode;
    private ArrayList m_listSampleData = new ArrayList();
    private String m_strData;
    private String m_strSequence;
    private String m_strStatus;

    private String extractData(String strSequence) {
        int l_iConBS = 0;
        int l_iMaxWidth = 0;
        char last = strSequence.charAt(0);
        int index = 1;
        while (index < strSequence.length()) {
            if (strSequence.charAt(index) == 'W') {
                if (last == 'B') {
                    if (l_iConBS > l_iMaxWidth) {
                        l_iMaxWidth = l_iConBS;
                    }
                    l_iConBS = 0;
                }
            } else {
                ++l_iConBS;
            }
            last = strSequence.charAt(index);
            ++index;
        }
        int widthBar = l_iMaxWidth;
        int thinsBar = l_iMaxWidth / 2;
        last = strSequence.charAt(0);
        l_iConBS = 0;
        int l_iConWS = 0;
        String strRetVal = "";
        int barCount = 0;
        int index2 = 1;
        while (index2 < strSequence.length()) {
            if (strSequence.charAt(index2) == 'W') {
                if (last == 'B') {
                    strRetVal = l_iConBS > thinsBar ? strRetVal + "W" : strRetVal + "T";
                    if (++barCount != 0 && barCount % 5 == 0) {
                        strRetVal = strRetVal + " ";
                    }
                    l_iConBS = 0;
                }
                ++l_iConWS;
            } else {
                if (last == 'W') {
                    strRetVal = l_iConWS > thinsBar ? strRetVal + "w" : strRetVal + "t";
                    if (++barCount != 0 && barCount % 10 == 0) {
                        strRetVal = strRetVal + " ";
                    }
                    l_iConWS = 0;
                }
                ++l_iConBS;
            }
            last = strSequence.charAt(index2);
            ++index2;
        }
        return strRetVal;
    }

    private String getBarCodeSequence() {
        String strBarCode = "";
        int horIndex = 0;
        while (horIndex < this.m_imageBarCode.getWidth()) {
            int WS = 0;
            int BS = 0;
            int verIndex = 0;
            while (verIndex < this.m_listSampleData.size()) {
                if (((String)this.m_listSampleData.get(verIndex)).charAt(horIndex) == 'W') {
                    ++WS;
                } else {
                    ++BS;
                }
                ++verIndex;
            }
            strBarCode = WS > BS ? strBarCode + "W" : strBarCode + "B";
            ++horIndex;
        }
        return strBarCode;
    }

    private String getColorSequence(int y) {
        if (y > this.m_iHeight) {
            return "";
        }
        String strData = new String();
        int index = 0;
        while (index < this.m_iWidth) {
            Color col = new Color(this.m_imageBarCode.getRGB(index, y));
            strData = col.getRed() > 200 && col.getGreen() > 200 && col.getBlue() > 200 ? strData + "W" : strData + "B";
            ++index;
        }
        return strData;
    }

    public String getData() {
        if (this.m_bHasData) {
            String strLocal = null;
            if (this.m_strData.length() == 0 || this.m_strData.indexOf("#") != -1) {
                strLocal = JOptionPane.showInputDialog(null, "Current read data is '" + this.m_strData + "' probably has some error.\nPlease Enter the Data.", this.m_strData);
            }
            if (strLocal != null && strLocal.length() != 0) {
                this.m_strData = strLocal;
            }
            return this.m_strData;
        }
        String strLocal = null;
        strLocal = JOptionPane.showInputDialog(null, "Current read data is '" + this.m_strData + "' probably has some error.\nPlease Enter the Data.", this.m_strData);
        if (strLocal != null && strLocal.length() != 0) {
            this.m_strData = strLocal;
        }
        return this.m_strData;
    }

    private String getDataFromPattern(String strPattern) {
        String strData = "";
        StringTokenizer token = new StringTokenizer(strPattern, " ");
        int tokenCount = 0;
        while (token.hasMoreTokens()) {
            String strToken = token.nextToken();
            if (++tokenCount == 1 || strToken.length() < 10) continue;
            strToken = strToken.substring(1);
            if (tokenCount == 2) {
                if (strToken.equals("WtTtTwTtW")) {
                    strData = strData + "A";
                    continue;
                }
                if (strToken.equals("WtWtTwTtT")) {
                    strData = strData + "C";
                    continue;
                }
                if (strToken.equals("TtTtWwTtW")) {
                    strData = strData + "D";
                    continue;
                }
                if (strToken.equals("WtTtWwTtT")) {
                    strData = strData + "E";
                    continue;
                }
                if (strToken.equals("WtTtTtWwT")) {
                    strData = strData + "R";
                    continue;
                }
                if (strToken.equals("WtTtTwWtT")) {
                    strData = strData + "H";
                    continue;
                }
                if (strToken.equals("WwWtTtTtT")) {
                    strData = strData + "W";
                    continue;
                }
                if (strToken.equals("TtWtTtWwT")) {
                    strData = strData + "S";
                    continue;
                }
                strData = strData + "#";
                this.m_strStatus = "ERROR";
                continue;
            }
            if (strToken.equals("TtTwWtWtT")) {
                strData = strData + "0";
                continue;
            }
            if (strToken.equals("WtTwTtTtW")) {
                strData = strData + "1";
                continue;
            }
            if (strToken.equals("TtWwTtTtW")) {
                strData = strData + "2";
                continue;
            }
            if (strToken.equals("WtWwTtTtT")) {
                strData = strData + "3";
                continue;
            }
            if (strToken.equals("TtTwWtTtW")) {
                strData = strData + "4";
                continue;
            }
            if (strToken.equals("WtTwWtTtT")) {
                strData = strData + "5";
                continue;
            }
            if (strToken.equals("TtWwWtTtT")) {
                strData = strData + "6";
                continue;
            }
            if (strToken.equals("TtTwTtWtW")) {
                strData = strData + "7";
                continue;
            }
            if (strToken.equals("WtTwTtWtT")) {
                strData = strData + "8";
                continue;
            }
            if (strToken.equals("TtWwTtWtT")) {
                strData = strData + "9";
                continue;
            }
            strData = strData + "#";
            this.m_strStatus = "ERROR";
        }
        strData = strData.substring(0, strData.length() - 1);
        return strData;
    }

    public String getReadStatus() {
        return this.m_strStatus;
    }

    private boolean isValidSample(String strSample) {
        int l_iNoWS = 0;
        int l_iNoBS = 0;
        int l_iConWS = 0;
        int l_iConBS = 0;
        int l_iNoiseBS = 0;
        int l_iNoiseWS = 0;
        int l_iNoWSLong = 0;
        int l_iNoBSLong = 0;
        char last = strSample.charAt(0);
        boolean isBarCode = true;
        int index = 1;
        while (index < strSample.length()) {
            if (strSample.charAt(index) == 'W') {
                if (last == 'W') {
                    ++l_iConWS;
                } else {
                    if ((double)l_iConBS < (double)this.m_imageBarCode.getWidth() * 0.1) {
                        ++l_iNoBS;
                        if (l_iConBS < 2) {
                            ++l_iNoiseBS;
                        }
                    } else {
                        ++l_iNoBSLong;
                    }
                    l_iConBS = 0;
                }
            } else if (last == 'B') {
                ++l_iConBS;
            } else {
                if ((double)l_iConWS < (double)this.m_imageBarCode.getWidth() * 0.1) {
                    ++l_iNoWS;
                    if (l_iConWS < 2) {
                        ++l_iNoiseWS;
                    }
                } else {
                    ++l_iNoWSLong;
                }
                l_iConWS = 0;
            }
            last = strSample.charAt(index);
            ++index;
        }
        if (l_iConWS > 0) {
            ++l_iNoWS;
        }
        if ((double)l_iConWS > (double)this.m_imageBarCode.getWidth() * 0.1 && (l_iNoBS < l_iNoWS / 2 || l_iNoWS == 0 || l_iNoBS == 0)) {
            isBarCode = false;
        }
        if (l_iConBS > 0) {
            ++l_iNoBS;
        }
        if ((double)l_iConBS > (double)this.m_imageBarCode.getWidth() * 0.1) {
            isBarCode = false;
        }
        if ((double)l_iNoiseWS > (double)l_iNoWS * 0.9) {
            isBarCode = false;
        }
        if ((double)l_iNoiseBS > (double)l_iNoBS * 0.9) {
            isBarCode = false;
        }
        return isBarCode;
    }

    public boolean obtainAlterNativeSequence() {
        ArrayList<String> list = new ArrayList<String>();
        int index = 1;
        while (index < this.m_iHeight - 2) {
            String strVal = this.getColorSequence(index);
            if (this.isValidSample(strVal)) {
                list.add(strVal);
            }
            index += 2;
        }
        if (list.size() < 1) {
            return false;
        }
        String strData = this.getDataFromPattern(this.extractData(this.getBarCodeSequence()));
        return this.getData().equals(strData);
    }

    public void obtainSequence() {
        int index = 0;
        while (index < this.m_iHeight - 2) {
            String strVal = this.getColorSequence(index);
            boolean ok = this.isValidSample(strVal);
            if (ok) {
                this.m_listSampleData.add(strVal);
            }
            index += 2;
        }
        if (this.m_listSampleData.size() < 1) {
            this.m_strStatus = "ERROR";
            return;
        }
        this.m_strSequence = this.getBarCodeSequence();
        String strPatt = this.extractData(this.m_strSequence);
        this.m_strData = this.getDataFromPattern(strPatt);
        this.m_strStatus = "OK";
        this.m_bHasData = true;
    }

    public void setImage(BufferedImage image) {
        this.m_imageBarCode = image;
        this.m_iWidth = this.m_imageBarCode.getWidth();
        this.m_iHeight = this.m_imageBarCode.getHeight();
    }
}

