<?php

/**
 * This config file contains some global variables that are used by almost all classes (app-wide config).
 */



return [


    // VELOX global directory structure.
    'paths' => [
        'root'      => BASE_PATH,
        'app'       => '{global.paths.root}/app',
        'classes'   => '{global.paths.root}/classes',
        'functions' => '{global.paths.root}/functions',
        'includes'  => '{global.paths.root}/includes',
        'themes'    => '{global.paths.root}/themes',
        'config'    => '{global.paths.root}/config',
        'storage'   => '{global.paths.root}/storage',
        'public'    => '{global.paths.root}/public',
    ],


    // VELOX current environment, [DEV = development, PROD = production].
    'env' => 'DEV',


    // VELOX base URL, overrides server default base URL.
    'baseUrl' => null,


    // VELOX default timezone, this will be used by all date/time functions.
    'timezone' => 'Europe/Berlin',


    // VELOX error pages, view files to render for HTTP errors.
    // The view set here will also be rendered when calling "App::abort($code)" instead of the default page.
    'errorPages' => [
        // A view file for "500 Internal Server Error" responses, if an uncaught exception was thrown in production environment.
        '500' => 'error/500',
        // A view file for "401 Unauthorized" responses, if a unauthenticated user requested a page that requires authentication.
        '401' => 'error/401',
        // A view file for "403 Forbidden" responses, if request CSRF token is invalid.
        '403' => 'error/403',
        // A view file for "404 Not Found" responses, if requested route was not found.
        '404' => 'error/404',
        // A view file for "405 Not Allowed" responses, if requested method is not allowed.
        '405' => 'error/405',
    ],


    // VELOX logging configuration.
    'logging' => [
        // Whether or not to enable logging of different events of the app. Note that exception will be logged no matter what the value here is.
        'enabled'          => true,
        // The maximum file size of the log file in bytes before it gets truncated.
        'maxFileSize'      => 6.4e+7,
        // The default file name for logs without explicitly given file name on function call.
        'defaultFilename'  => 'autogenerated-' . date('Ymd'),
        // The default writing directory for logs without explicitly given writing directory on function call.
        'defaultDirectory' => '{global.paths.storage}/logs/',
    ],


];
